// qexception.cpp

#include "stdafx.h"
#include "qexception.h"

// CQException::CQException( ostrstream &os )
//
// Construct an exception object from the text in the output string stream os
CQException::CQException( ostrstream &os )
{
    // Find the length
    m_iLen = os.pcount();

    // Allocate a new string
    m_pStr = new char [ m_iLen + 1 ];
    ASSERT( m_pStr );
    strncpy( m_pStr, os.str(), m_iLen );

    // Null terminate our copy
    m_pStr[ m_iLen ] = 0;

    // Unlock the string stream
    os.rdbuf()->freeze( 0 );
}

// CQException::~CQException(  )
//
// Destroy an exception object
CQException::~CQException(  )
{
    if( m_pStr ){
        delete [] m_pStr;
        m_pStr = NULL;
    }
}

// CQException::CQException( CQException &qex )
//
// Copy an exception object
CQException::CQException( CQException &qex )
{
    m_iLen = qex.m_iLen;
    m_pStr = new char [ qex.m_iLen + 1];
    strcpy( m_pStr, qex.m_pStr );
}
