/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.core;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import org.spoofax.interpreter.library.IOAgent;

public class StackTracer {
    private static final int MAX_REPORTED_FRAMES = 130;
    private static final int MAX_REPORTED_FRAMES_TAIL = 30;
    private IOAgent ioAgent;
    private String[] frames = new String[50];
    private int currentDepth;
    private int failureDepth;

    public final void push(String name) {
        int depth;
        if (this.frames.length == (depth = this.currentDepth++)) {
            String[] oldframes = this.frames;
            this.frames = new String[this.frames.length * 2];
            System.arraycopy(oldframes, 0, this.frames, 0, oldframes.length);
        }
        this.frames[depth] = name;
        this.failureDepth = this.currentDepth;
    }

    public final void popOnFailure() {
        --this.currentDepth;
    }

    public final void popOnSuccess() {
        this.failureDepth = --this.currentDepth;
    }

    public void popOnExit(boolean success) {
        this.currentDepth = 0;
        if (success) {
            this.failureDepth = 0;
        }
    }

    public IOAgent getIOAgent() {
        return this.ioAgent;
    }

    public void setIOAgent(IOAgent ioAgent) {
        this.ioAgent = ioAgent;
    }

    public int getTraceDepth() {
        return this.failureDepth;
    }

    public int getTraceDepth(boolean onlyCurrent) {
        return onlyCurrent ? this.currentDepth : this.failureDepth;
    }

    public String[] getTrace() {
        return this.getTrace(false);
    }

    public String[] getTrace(boolean onlyCurrent) {
        int depth = onlyCurrent ? this.currentDepth : this.failureDepth;
        String[] frames = this.frames;
        String[] results = new String[depth];
        int i = 0;
        while (i < depth) {
            results[results.length - i - 1] = frames[i];
            ++i;
        }
        return results;
    }

    public String getTraceString() {
        StringWriter writer = new StringWriter();
        this.printStackTrace(writer, false);
        return writer.toString();
    }

    public void setTrace(String[] trace) {
        if (trace.length == 0) {
            this.failureDepth = 0;
            this.currentDepth = 0;
            this.frames = new String[10];
        } else {
            this.currentDepth = Math.min(trace.length, this.currentDepth);
            this.failureDepth = trace.length;
            this.frames = trace;
        }
    }

    public final void printStackTrace() {
        this.printStackTrace(false);
    }

    public final void printStackTrace(boolean onlyCurrent) {
        Writer writer = this.getIOAgent() == null ? new OutputStreamWriter(System.err) : this.getIOAgent().getWriter(2);
        this.printStackTrace(writer, onlyCurrent);
    }

    public void printStackTrace(PrintStream stream, boolean onlyCurrent) {
        this.printStackTrace(new OutputStreamWriter(stream), onlyCurrent);
    }

    private void printStackTrace(Writer writer, boolean onlyCurrent) {
        try {
            int depth = onlyCurrent ? this.currentDepth : this.failureDepth;
            String[] frames = (String[])this.frames.clone();
            int i = 0;
            while (i < depth) {
                if (i == 100) {
                    writer.write("...truncated...\n");
                    i = Math.max(i + 1, depth - 30);
                }
                writer.write("\t" + frames[i] + "\n");
                ++i;
            }
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

