/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.java;

import java.util.HashMap;
import java.util.Map;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.library.AbstractStrategoOperatorRegistry;
import org.spoofax.interpreter.library.java.JFF_find_class;
import org.spoofax.interpreter.library.java.JFF_find_primitive_type;
import org.spoofax.interpreter.library.java.JFF_get_constructor;
import org.spoofax.interpreter.library.java.JFF_get_method;
import org.spoofax.interpreter.library.java.JFF_invoke_method;
import org.spoofax.interpreter.library.java.JFF_new_instance;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.Term;

public class JFFLibrary
extends AbstractStrategoOperatorRegistry {
    public static final String REGISTRY_NAME = "JFF";
    private Map<Integer, Object> objectWrappers;
    private int objectCounter;
    private IStrategoConstructor objWrapCtor;
    private ITermFactory termFactory;

    public JFFLibrary(ITermFactory termFactory) {
        this.termFactory = termFactory;
        this.initRegistry();
        this.init();
    }

    public String getOperatorRegistryName() {
        return REGISTRY_NAME;
    }

    private void initRegistry() {
        this.add(new JFF_find_class());
        this.add(new JFF_find_primitive_type());
        this.add(new JFF_new_instance());
        this.add(new JFF_get_constructor());
        this.add(new JFF_invoke_method());
        this.add(new JFF_get_method());
    }

    public void init() {
        this.objectCounter = 0;
        if (this.objectWrappers != null) {
            this.objectWrappers.clear();
        } else {
            this.objectWrappers = new HashMap<Integer, Object>();
        }
        this.objWrapCtor = this.termFactory.makeConstructor("ObjWrap", 1);
    }

    public static JFFLibrary instance(IContext env) {
        return (JFFLibrary)env.getOperatorRegistry(REGISTRY_NAME);
    }

    public IStrategoTerm wrapObject(Object obj) {
        int idx = this.objectCounter++;
        this.objectWrappers.put(idx, obj);
        return this.termFactory.makeAppl(this.objWrapCtor, this.termFactory.makeInt(idx));
    }

    public Object unwrapObject(IStrategoAppl term) {
        IStrategoTerm t = term.getSubterm(0);
        if (!Term.isTermInt(t)) {
            return null;
        }
        return this.objectWrappers.get(((IStrategoInt)t).intValue());
    }

    public Object unpackTerm(IStrategoTerm term) {
        switch (term.getTermType()) {
            case 3: {
                return ((IStrategoInt)term).intValue();
            }
            case 4: {
                return ((IStrategoReal)term).realValue();
            }
            case 5: {
                return ((IStrategoString)term).stringValue();
            }
            case 1: {
                return this.unwrapObject((IStrategoAppl)term);
            }
        }
        return null;
    }
}

