/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spoofax.interpreter.library.language.SemanticIndexEntryFactory;
import org.spoofax.interpreter.library.language.SemanticIndexEntryParent;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticIndexEntry {
    private IStrategoTerm type;
    private IStrategoList id;
    private IStrategoTerm namespace;
    private IStrategoTerm data;
    private URI file;
    private List<SemanticIndexEntry> tail = null;
    private transient IStrategoAppl term;

    protected SemanticIndexEntry(IStrategoTerm type, IStrategoTerm namespace, IStrategoList id, IStrategoTerm data, URI file) {
        this.type = type;
        this.id = id;
        this.namespace = namespace;
        this.data = data;
        this.file = file;
        assert (id != null && namespace != null && id != null);
        assert (data != null || type instanceof IStrategoConstructor);
    }

    public IStrategoTerm getType() {
        return this.type;
    }

    public IStrategoList getId() {
        return this.id;
    }

    public IStrategoTerm getNamespace() {
        return this.namespace;
    }

    public IStrategoTerm getData() {
        return this.data;
    }

    public URI getFile() {
        return this.file;
    }

    public List<SemanticIndexEntry> getTail() {
        if (this.tail == null) {
            return Collections.emptyList();
        }
        return this.tail;
    }

    public boolean isParent() {
        return this.type == SemanticIndexEntryParent.TYPE;
    }

    public void setTail(List<SemanticIndexEntry> tail) {
        this.tail = tail;
    }

    public void addToTail(SemanticIndexEntry entry) {
        if (this.tail == null) {
            this.tail = new ArrayList<SemanticIndexEntry>();
        }
        this.tail.add(entry);
    }

    public void removeFromTail(SemanticIndexEntry entry) {
        if (this.tail == null) {
            return;
        }
        this.tail.remove(entry);
    }

    protected void internalReinit(IStrategoTerm type, IStrategoTerm namespace, IStrategoList id, IStrategoTerm data) {
        this.type = type;
        this.namespace = namespace;
        this.id = id;
        this.data = data;
    }

    public IStrategoAppl toTerm(SemanticIndexEntryFactory factory) {
        if (this.term != null) {
            return this.term;
        }
        ITermFactory terms = factory.getTermFactory();
        IStrategoList namespaceId = terms.makeListCons(this.namespace, this.id);
        if (!this.isDataEntry()) {
            this.term = terms.makeAppl((IStrategoConstructor)this.type, namespaceId);
        } else {
            assert (!(this.type instanceof IStrategoConstructor)) : "DefData expected";
            this.term = terms.makeAppl(factory.getDefDataCon(), namespaceId, this.type, this.data);
        }
        return this.forceImploderAttachment(this.term);
    }

    private boolean isDataEntry() {
        return this.data != null;
    }

    private IStrategoAppl forceImploderAttachment(IStrategoAppl term) {
        ImploderAttachment attach = ImploderAttachment.get(this.id);
        if (attach != null) {
            ImploderAttachment.putImploderAttachment(term, false, attach.getSort(), attach.getLeftToken(), attach.getRightToken());
        } else {
            String fn = this.file == null ? null : this.file.toString();
            term.putAttachment(ImploderAttachment.createCompactPositionAttachment(fn, 0, 0, 0, -1));
        }
        return term;
    }

    public String toString() {
        if (this.isDataEntry()) {
            return "DefData(" + this.namespace + "," + this.id + "," + this.type + "," + this.data + ")";
        }
        return String.valueOf(((IStrategoConstructor)this.type).getName()) + "(" + this.namespace + "," + this.id + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.namespace.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemanticIndexEntry)) {
            return false;
        }
        SemanticIndexEntry other = (SemanticIndexEntry)obj;
        if (this.type != other.type) {
            if (!this.isDataEntry()) {
                assert (this.type instanceof IStrategoConstructor && !this.type.equals(other.type));
                return false;
            }
            if (!this.type.match(other.type)) {
                return false;
            }
        }
        if (this.namespace != other.namespace && !this.namespace.match(other.namespace)) {
            return false;
        }
        return this.id == other.id || this.id.match(other.id);
    }
}

