/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.ssl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.terms.AbstractSimpleTerm;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.TermFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrategoSet
extends AbstractSimpleTerm
implements IStrategoTerm,
Serializable {
    private static final long serialVersionUID = -4514696890481283123L;
    private int counter;
    private final Map<IStrategoTerm, Integer> map;

    public StrategoSet(int initialSize, int maxLoad) {
        this.map = new HashMap<IStrategoTerm, Integer>(initialSize, 1.0f * (float)maxLoad / 100.0f);
        this.counter = 0;
    }

    public int put(IStrategoTerm value) {
        int idx = this.counter++;
        this.map.put(value, idx);
        return idx;
    }

    public int getIndex(IStrategoTerm t) {
        Integer r = this.map.get(t);
        return r == null ? -1 : r;
    }

    public boolean containsValue(IStrategoTerm t) {
        return this.map.containsKey(t);
    }

    public Collection<Integer> values() {
        return this.map.values();
    }

    public boolean remove(IStrategoTerm t) {
        return this.map.remove(t) != null;
    }

    public void clear() {
        this.counter = 0;
        this.map.clear();
    }

    public Collection<IStrategoTerm> keySet() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class X
        implements Comparable<X> {
            IStrategoTerm t;
            Integer i;

            X(IStrategoTerm t, Integer i) {
                this.t = t;
                this.i = i;
            }

            @Override
            public int compareTo(X o) {
                return this.i.compareTo(o.i);
            }
        }
        ArrayList<X> xs = new ArrayList<X>();
        for (Map.Entry<IStrategoTerm, Integer> e : this.map.entrySet()) {
            xs.add(new X(e.getKey(), e.getValue()));
        }
        Collections.sort(xs);
        ArrayList<IStrategoTerm> r = new ArrayList<IStrategoTerm>();
        for (X x : xs) {
            r.add(x.t);
        }
        return r;
    }

    public boolean containsKey(IStrategoTerm t) {
        return this.map.containsKey(t);
    }

    public int size() {
        return this.map.size();
    }

    public Set<Map.Entry<IStrategoTerm, Integer>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public IStrategoTerm[] getAllSubterms() {
        return AbstractTermFactory.EMPTY;
    }

    @Override
    public IStrategoList getAnnotations() {
        return TermFactory.EMPTY_LIST;
    }

    @Override
    public int getStorageType() {
        return 0;
    }

    @Override
    public IStrategoTerm getSubterm(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSubtermCount() {
        return 0;
    }

    @Override
    public int getTermType() {
        return 9;
    }

    @Override
    public boolean match(IStrategoTerm second) {
        return second == this;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public void prettyPrint(ITermPrinter pp) {
        pp.print(this.toString());
    }

    public String toString() {
        return String.valueOf(this.hashCode());
    }

    @Override
    public String toString(int maxDepth) {
        return this.toString();
    }

    @Override
    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append(this.toString());
    }

    @Override
    public boolean isList() {
        return false;
    }
}

