/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.stratego;

import java.util.ArrayList;
import org.spoofax.DebugUtil;
import org.spoofax.NotImplementedException;
import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.Pair;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.stratego.StupidFormatter;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoRef;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;

public class Match
extends Strategy {
    protected IStrategoAppl pattern;

    public Match(IStrategoAppl pattern) {
        this.pattern = pattern;
    }

    public IConstruct eval(IContext env) throws InterpreterException {
        IStrategoTerm current;
        Results r;
        if (DebugUtil.isDebugging()) {
            Match.debug("Match.eval() - ", " !", env.current(), " ; ?", this.pattern);
        }
        if ((r = this.match(env, current = env.current(), this.pattern)) == null) {
            return this.getHook().pop().onFailure(env);
        }
        boolean b = env.bindVars(r);
        if (b) {
            return this.getHook().pop().onSuccess(env);
        }
        return this.getHook().pop().onFailure(env);
    }

    public Results matchAppl(IContext env, IStrategoAppl t, IStrategoAppl p) throws InterpreterException {
        if (Tools.isAnno(p, env)) {
            return this.matchAnyAnno(env, t, p);
        }
        if (Tools.isOp(p, env)) {
            return this.matchApplOp(env, t, p);
        }
        if (Tools.isInt(p, env)) {
            return this.matchApplInt(env, t, p);
        }
        if (Tools.isStr(p, env)) {
            return null;
        }
        if (Tools.isVar(p, env)) {
            return this.matchAnyVar(t, p);
        }
        if (Tools.isExplode(p, env)) {
            return this.matchAnyExplode(env, t, p);
        }
        if (Tools.isAs(p, env)) {
            return this.matchCompoundAs(env, t, p);
        }
        if (Tools.isWld(p, env)) {
            return this.matchAnyWld(p);
        }
        throw new InterpreterException("Unknown Appl case '" + p + "'");
    }

    protected Results matchApplInt(IContext env, IStrategoTerm t, IStrategoAppl p) throws InterpreterException {
        if (Tools.isTermInt(t)) {
            return this.match(env, Tools.intAt(t, 0), Tools.applAt(p, 0));
        }
        return null;
    }

    protected Results matchApplStr(IStrategoTerm t, IStrategoTerm p) {
        throw new NotImplementedException();
    }

    protected Results matchApplOp(IContext env, IStrategoAppl t, IStrategoAppl p) throws InterpreterException {
        String c = Tools.javaStringAt(p, 0);
        if (c.equals("Cons")) {
            return null;
        }
        if (c.equals("Nil")) {
            return null;
        }
        if (c.equals("")) {
            return this.matchApplTuple(env, t, p);
        }
        IStrategoList ctorArgs = Tools.listAt(p, 1);
        if (ctorArgs.getSubtermCount() != t.getSubtermCount()) {
            return null;
        }
        if (!t.getConstructor().getName().equals(c)) {
            return null;
        }
        Results r = this.emptyList();
        int i = 0;
        while (i < ctorArgs.size()) {
            Results m = this.match(env, t.getSubterm(i), (IStrategoAppl)ctorArgs.getSubterm(i));
            if (m == null) {
                return null;
            }
            r.addAll(m);
            ++i;
        }
        return r;
    }

    private Results matchApplTuple(IContext env, IStrategoAppl t, IStrategoAppl p) throws InterpreterException {
        String c = Tools.javaStringAt(p, 0);
        if (!c.equals("")) {
            return null;
        }
        IStrategoList ctorArgs = Tools.listAt(p, 1);
        IStrategoTerm[] args = t.getAllSubterms();
        if (ctorArgs.size() != args.length) {
            return null;
        }
        Results r = this.emptyList();
        int i = 0;
        while (i < ctorArgs.size()) {
            Results m = this.match(env, args[i], (IStrategoAppl)ctorArgs.getSubterm(i));
            if (m == null) {
                return null;
            }
            r.addAll(m);
            ++i;
        }
        return r;
    }

    private Results emptyList() {
        return new Results();
    }

    protected Results matchInt(IContext env, IStrategoInt t, IStrategoAppl p) throws InterpreterException {
        if (DebugUtil.isDebugging()) {
            Match.debug("term is Int");
        }
        if (Tools.isAnno(p, env)) {
            return this.matchAnyAnno(env, t, p);
        }
        if (Tools.isInt(p, env)) {
            return this.matchIntInt(t, p);
        }
        if (Tools.isReal(p, env)) {
            return null;
        }
        if (Tools.isVar(p, env)) {
            return this.matchAnyVar(t, p);
        }
        if (Tools.isOp(p, env)) {
            return null;
        }
        if (Tools.isExplode(p, env)) {
            return this.matchAnyExplode(env, t, p);
        }
        if (Tools.isWld(p, env)) {
            return this.matchAnyWld(p);
        }
        if (Tools.isAs(p, env)) {
            return this.matchCompoundAs(env, t, p);
        }
        if (Tools.isStr(p, env)) {
            return null;
        }
        throw new InterpreterException("Unknown Int case '" + p + "'");
    }

    protected Results matchReal(IContext env, IStrategoReal t, IStrategoAppl p) throws InterpreterException {
        if (DebugUtil.isDebugging()) {
            Match.debug("term is Real");
        }
        if (Tools.isAnno(p, env)) {
            return this.matchAnyAnno(env, t, p);
        }
        if (Tools.isInt(p, env)) {
            return null;
        }
        if (Tools.isReal(p, env)) {
            return this.matchRealReal(t, p);
        }
        if (Tools.isVar(p, env)) {
            return this.matchAnyVar(t, p);
        }
        if (Tools.isOp(p, env)) {
            return null;
        }
        if (Tools.isExplode(p, env)) {
            return this.matchAnyExplode(env, t, p);
        }
        if (Tools.isWld(p, env)) {
            return this.matchAnyWld(p);
        }
        if (Tools.isAs(p, env)) {
            return this.matchCompoundAs(env, t, p);
        }
        if (Tools.isStr(p, env)) {
            return null;
        }
        throw new InterpreterException("Unknown Real case '" + p + "'");
    }

    private Results matchRealReal(IStrategoReal t, IStrategoAppl p) {
        Double realVal = new Double(Tools.javaStringAt(p, 0));
        if (realVal.doubleValue() == t.realValue()) {
            return this.emptyList();
        }
        return null;
    }

    private Results matchAnyWld(IStrategoAppl p) {
        return this.emptyList();
    }

    protected Results matchAnyAnno(IContext env, IStrategoTerm t, IStrategoAppl p) throws InterpreterException {
        Results r1 = this.matchList(env, t.getAnnotations(), Tools.applAt(p, 1));
        if (r1 == null) {
            return null;
        }
        Results r2 = this.match(env, t, Tools.applAt(p, 0));
        if (r2 == null) {
            return null;
        }
        r2.addAll(r1);
        return r2;
    }

    protected Results matchIntInt(IStrategoInt t, IStrategoAppl p) {
        Integer intVal = new Integer(Tools.javaStringAt(p, 0));
        if (intVal.intValue() == t.intValue()) {
            return this.emptyList();
        }
        return null;
    }

    private Results newResult(Binding initial) {
        Results r = new Results();
        r.add(initial);
        return r;
    }

    private Results matchAnyExplode(IContext env, IStrategoTerm t, IStrategoAppl p) throws InterpreterException {
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug("  pattern is Explode");
        }
        IStrategoAppl opPattern = Tools.applAt(p, 0);
        IStrategoAppl argsPattern = Tools.applAt(p, 1);
        IStrategoTerm op = this.getTermConstructor(env, t);
        IStrategoTerm args = this.getTermArguments(env, t);
        Results opResult = this.match(env, op, opPattern);
        Results argsResult = this.match(env, args, argsPattern);
        if (opResult == null || argsResult == null) {
            return null;
        }
        opResult.addAll(argsResult);
        return opResult;
    }

    private IStrategoTerm getTermArguments(IContext env, IStrategoTerm t) throws InterpreterException {
        switch (t.getTermType()) {
            case 3: 
            case 4: {
                return env.getFactory().makeList();
            }
            case 1: {
                IStrategoAppl a = (IStrategoAppl)t;
                if (Tools.isNil(a, env) || Tools.isCons(a, env)) {
                    return t;
                }
                return env.getFactory().makeList(a.getAllSubterms());
            }
            case 2: {
                return t;
            }
            case 5: {
                return env.getFactory().makeList();
            }
            case 7: {
                IStrategoTuple tup = (IStrategoTuple)t;
                IStrategoTerm[] args = new IStrategoTerm[tup.getSubtermCount()];
                int i = 0;
                while (i < args.length) {
                    args[i] = tup.get(i);
                    ++i;
                }
                return env.getFactory().makeList(args);
            }
        }
        throw new InterpreterException("Unknown term '" + t + "'");
    }

    private IStrategoTerm getTermConstructor(IContext env, IStrategoTerm t) throws InterpreterException {
        if (Tools.isTermInt(t) || Tools.isTermReal(t)) {
            return t;
        }
        if (Tools.isTermString(t)) {
            return env.getFactory().makeString("\"" + ((IStrategoString)t).stringValue() + "\"");
        }
        if (Tools.isTermAppl(t)) {
            IStrategoAppl a = (IStrategoAppl)t;
            if (Tools.isCons(a, env) || Tools.isNil(a, env)) {
                return env.getFactory().makeAppl(env.getStrategoSignature().getNil(), new IStrategoTerm[0]);
            }
            return env.getFactory().makeString(((IStrategoAppl)t).getConstructor().getName());
        }
        if (Tools.isTermList(t)) {
            return env.getFactory().makeList();
        }
        if (Tools.isTermTuple(t)) {
            return env.getFactory().makeString("");
        }
        throw new InterpreterException("Unknown term '" + t + "'");
    }

    public Results match(IContext env, IStrategoTerm t, IStrategoAppl p) throws InterpreterException {
        if (t == null) {
            throw new InterpreterException("Null term while matching: term library or one of the primitives is defective");
        }
        switch (t.getTermType()) {
            case 1: {
                return this.matchAppl(env, (IStrategoAppl)t, p);
            }
            case 3: {
                return this.matchInt(env, (IStrategoInt)t, p);
            }
            case 4: {
                return this.matchReal(env, (IStrategoReal)t, p);
            }
            case 5: {
                return this.matchString(env, (IStrategoString)t, p);
            }
            case 2: {
                return this.matchList(env, (IStrategoList)t, p);
            }
            case 7: {
                return this.matchTuple(env, (IStrategoTuple)t, p);
            }
            case 8: {
                return this.matchRef(env, (IStrategoRef)t, p);
            }
            case 9: {
                return this.matchBlob(env, t, p);
            }
        }
        throw new InterpreterException("Unsupported term type : " + t.getClass().toString() + " [" + t.getTermType() + "]");
    }

    private Results matchBlob(IContext env, IStrategoTerm t, IStrategoAppl p) throws InterpreterException {
        if (DebugUtil.isDebugging()) {
            Match.debug("term is Blob");
        }
        if (Tools.isAnno(p, env)) {
            return this.matchAnyAnno(env, t, p);
        }
        if (Tools.isWld(p, env)) {
            return this.matchAnyWld(p);
        }
        if (Tools.isAs(p, env)) {
            return this.matchCompoundAs(env, t, p);
        }
        if (Tools.isVar(p, env)) {
            return this.matchAnyVar(t, p);
        }
        if (Tools.isExplode(p, env)) {
            return null;
        }
        if (Tools.isStr(p, env)) {
            return null;
        }
        if (Tools.isInt(p, env)) {
            return null;
        }
        if (Tools.isReal(p, env)) {
            return null;
        }
        if (Tools.isOp(p, env)) {
            return null;
        }
        throw new InterpreterException("Unknown Tuple case '" + p + "'");
    }

    private Results matchRef(IContext env, IStrategoRef ref, IStrategoAppl p) {
        throw new NotImplementedException();
    }

    private Results matchTuple(IContext env, IStrategoTuple t, IStrategoAppl p) throws InterpreterException {
        if (DebugUtil.isDebugging()) {
            Match.debug("term is Tuple");
        }
        if (Tools.isAnno(p, env)) {
            return this.matchAnyAnno(env, t, p);
        }
        if (Tools.isInt(p, env)) {
            return null;
        }
        if (Tools.isReal(p, env)) {
            return null;
        }
        if (Tools.isVar(p, env)) {
            return this.matchAnyVar(t, p);
        }
        if (Tools.isOp(p, env)) {
            return this.matchTupleOp(env, t, p);
        }
        if (Tools.isWld(p, env)) {
            return this.matchAnyWld(p);
        }
        if (Tools.isAs(p, env)) {
            return this.matchCompoundAs(env, t, p);
        }
        if (Tools.isExplode(p, env)) {
            return this.matchAnyExplode(env, t, p);
        }
        if (Tools.isStr(p, env)) {
            return null;
        }
        throw new InterpreterException("Unknown Tuple case '" + p + "'");
    }

    private Results matchTupleOp(IContext env, IStrategoTuple t, IStrategoAppl p) throws InterpreterException {
        String c = Tools.javaStringAt(p, 0);
        if (!c.equals("")) {
            return null;
        }
        IStrategoList ctorArgs = Tools.listAt(p, 1);
        if (ctorArgs.size() != t.size()) {
            return null;
        }
        Results r = this.emptyList();
        int i = 0;
        while (i < ctorArgs.size()) {
            Results m = this.match(env, t.get(i), (IStrategoAppl)ctorArgs.getSubterm(i));
            if (m == null) {
                return null;
            }
            r.addAll(m);
            ++i;
        }
        return r;
    }

    protected Results matchList(IContext env, IStrategoList t, IStrategoAppl p) throws InterpreterException {
        if (DebugUtil.isDebugging()) {
            Match.debug("term is List");
        }
        if (Tools.isAnno(p, env)) {
            return this.matchAnyAnno(env, t, p);
        }
        if (Tools.isInt(p, env)) {
            return null;
        }
        if (Tools.isReal(p, env)) {
            return null;
        }
        if (Tools.isVar(p, env)) {
            return this.matchAnyVar(t, p);
        }
        if (Tools.isOp(p, env)) {
            return this.matchListOp(env, t, p);
        }
        if (Tools.isWld(p, env)) {
            return this.matchAnyWld(p);
        }
        if (Tools.isAs(p, env)) {
            return this.matchCompoundAs(env, t, p);
        }
        if (Tools.isExplode(p, env)) {
            return this.matchAnyExplode(env, t, p);
        }
        if (Tools.isStr(p, env)) {
            return null;
        }
        throw new InterpreterException("Unknown List case '" + p + "'");
    }

    private Results matchCompoundAs(IContext env, IStrategoTerm t, IStrategoAppl p) throws InterpreterException {
        Results r = this.match(env, t, Tools.applAt(p, 1));
        if (r == null) {
            return null;
        }
        if (DebugUtil.isDebugging()) {
            Match.debug("matching CompoundAs", p);
        }
        String varName = Tools.javaStringAt(Tools.applAt(p, 0), 0);
        r.add(new Binding(varName, t));
        return r;
    }

    private Results matchListOp(IContext env, IStrategoList t, IStrategoAppl p) throws InterpreterException {
        String c = Tools.javaStringAt(p, 0);
        if (c.equals("Nil")) {
            if (t.size() == 0) {
                return this.emptyList();
            }
        } else if (c.equals("Cons")) {
            if (t.size() < 1) {
                return null;
            }
            IStrategoTerm head = t.head();
            IStrategoList tail = t.tail();
            IStrategoList pattern = Tools.listAt(p, 1);
            Results r = this.match(env, head, (IStrategoAppl)pattern.getSubterm(0));
            if (r == null) {
                return null;
            }
            Results r2 = this.match(env, tail, (IStrategoAppl)pattern.getSubterm(1));
            if (r2 == null) {
                return null;
            }
            r.addAll(r2);
            return r;
        }
        return null;
    }

    private Results matchAnyVar(IStrategoTerm t, IStrategoAppl p) {
        String varName = Tools.javaStringAt(p, 0);
        return this.newResult(new Binding(varName, t));
    }

    private Results matchString(IContext env, IStrategoString t, IStrategoAppl p) throws InterpreterException {
        if (DebugUtil.isDebugging()) {
            Match.debug("term is String");
        }
        if (Tools.isAnno(p, env)) {
            return this.matchAnyAnno(env, t, p);
        }
        if (Tools.isStr(p, env)) {
            return this.matchStrStr(env, t, p);
        }
        if (Tools.isInt(p, env)) {
            return null;
        }
        if (Tools.isReal(p, env)) {
            return null;
        }
        if (Tools.isVar(p, env)) {
            return this.matchAnyVar(t, p);
        }
        if (Tools.isOp(p, env)) {
            return null;
        }
        if (Tools.isExplode(p, env)) {
            return this.matchAnyExplode(env, t, p);
        }
        if (Tools.isWld(p, env)) {
            return this.matchAnyWld(p);
        }
        if (Tools.isAs(p, env)) {
            return this.matchCompoundAs(env, t, p);
        }
        throw new InterpreterException("Unknown String case '" + p + "'");
    }

    private Results matchStrStr(IContext env, IStrategoString t, IStrategoAppl p) {
        IStrategoString s;
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug("  pattern is Str");
        }
        if ((s = Tools.stringAt(p, 0)).stringValue().equals(t.stringValue())) {
            return this.emptyList();
        }
        return null;
    }

    public void prettyPrint(StupidFormatter sf) {
        sf.first("Match(" + this.pattern.toString() + ")");
    }

    protected String getTraceName() {
        return String.valueOf(super.getTraceName()) + "(" + this.pattern + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Binding
    extends Pair<String, IStrategoTerm> {
        public Binding(String first, IStrategoTerm second) {
            super(first, second);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Results
    extends ArrayList<Binding> {
    }
}

