/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.test.library;

import java.io.IOException;
import java.util.TreeMap;
import junit.textui.TestRunner;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.test.AbstractInterpreterTest;

public class LibraryTest
extends AbstractInterpreterTest {
    protected void setUp() throws Exception {
        super.setUp("tests/data/library");
    }

    public void testChar() throws IOException, InterpreterException {
        this.interpTest("char-test", "(3,0)");
    }

    public void testOldParseOptions() throws IOException, InterpreterException {
        this.interpTest("old-parse-options-test", "(2,0)");
    }

    public void testTuple() throws IOException, InterpreterException {
        this.interpTest("tuple-test", "(2,0)");
    }

    public void testReals() throws IOException, InterpreterException {
        this.interpTest("reals-test", "(8,0)");
    }

    public void testListSet() throws IOException, InterpreterException {
        this.interpTest("list-set-test", "(25,0)");
    }

    public void testListSort() throws IOException, InterpreterException {
        this.interpTest("list-sort-test", "(7,0)");
    }

    public void testListZip() throws IOException, InterpreterException {
        this.interpTest("list-zip-test", "(4,0)");
    }

    public void testIntList() throws IOException, InterpreterException {
        this.interpTest("int-list-test", "(15,0)");
    }

    public void testListMisc() throws IOException, InterpreterException {
        this.interpTest("list-misc-test", "(23,0)");
    }

    public void testListIndex() throws IOException, InterpreterException {
        this.interpTest("list-index-test", "(17,0)");
    }

    public void testListFilter() throws IOException, InterpreterException {
        this.interpTest("list-filter-test", "(2,0)");
    }

    public void testIntegers() throws IOException, InterpreterException {
        this.interpTest("integers-test", "(101,0)");
    }

    public void testIteration() throws IOException, InterpreterException {
        this.interpTest("iteration-test", "(25,0)");
    }

    public void testUnification() throws IOException, InterpreterException {
        this.interpTest("unification-test", "(2,0)");
    }

    public void testStrcmp() throws IOException, InterpreterException {
        this.interpTest("strcmp-test", "(16,0)");
    }

    public void testTermZip() throws IOException, InterpreterException {
        this.interpTest("term-zip-test", "(8,0)");
    }

    public void testEnvTraversal() throws IOException, InterpreterException {
        this.interpTest("env-traversal-test", "(2,0)");
    }

    public void testSets() throws IOException, InterpreterException {
        this.interpTest("sets-test", "(15,0)");
    }

    public void testTables() throws IOException, InterpreterException {
        this.interpTest("tables-test", "(59,0)");
    }

    public void testSubstitution() throws IOException, InterpreterException {
        this.interpTest("substitution-test", "(1,0)");
    }

    public void testTermCommon() throws IOException, InterpreterException {
        this.interpTest("term-common-test", "(14,0)");
    }

    public void testListBasic() throws IOException, InterpreterException {
        this.interpTest("list-basic-test", "(41,0)");
    }

    public void testStringMisc() throws IOException, InterpreterException {
        this.interpTest("string-misc-test", "(29,0)");
    }

    public void testDynamicRulesLowlevel() throws IOException, InterpreterException {
        this.interpTest("dynamic-rules-lowlevel-test", "(46,0)");
    }

    public void testDynamicRulesHighlevel() throws IOException, InterpreterException {
        this.interpTest("dynamic-rules-highlevel-test", "(10,0)");
    }

    public void testSystemIOFile() throws IOException, InterpreterException {
        this.interpTest("system-io-file-test", "(104,0)");
    }

    public void testPOSIX() throws IOException, InterpreterException {
        this.interpTest("system-posix-test", "(0,0)");
    }

    public void testPOSIXXSI() throws IOException, InterpreterException {
        this.interpTest("system-posix-xsi-test", "(0,0)");
    }

    public void testAnnotation() throws IOException, InterpreterException {
        this.interpTest("annotation-test", "(24,0)");
    }

    public void testString() throws IOException, InterpreterException {
        this.interpTest("string-test", "(71,0)");
    }

    public void testRename() throws IOException, InterpreterException {
        this.interpTest("rename-test", "(2,0)");
    }

    public void testScopedFiniteMap() throws IOException, InterpreterException {
        this.interpTest("scoped-finite-map-test", "(5,0)");
    }

    public void testSimpleTraversal() throws IOException, InterpreterException {
        this.interpTest("simple-traversal-test", "(6,0)");
    }

    public void testCollect() throws IOException, InterpreterException {
        this.interpTest("collect-test", "(15,0)");
    }

    public void testParenthesize() throws IOException, InterpreterException {
        this.interpTest("parenthesize-test", "(4,0)");
    }

    public void testParseOptions() throws IOException, InterpreterException {
        this.interpTest("parse-options-test", "(23,0)");
    }

    public void interpTest(String test, String result) throws IOException, InterpreterException {
        super.interpTest(test, "()", result);
    }

    public static void main(String[] args) {
        TreeMap<Integer, Long> timeSpans = new TreeMap<Integer, Long>();
        long timeSpan = 0L;
        int i = 0;
        while (i < 1) {
            long timeStart = System.currentTimeMillis();
            TestRunner.run(LibraryTest.class);
            timeSpan = System.currentTimeMillis() - timeStart;
            timeSpans.put(i, timeSpan);
            ++i;
        }
        for (Integer i2 : timeSpans.keySet()) {
            System.out.println("->" + i2 + " = " + timeSpans.get(i2));
        }
    }
}

