/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.util.ArrayList;
import org.spoofax.PushbackStringIterator;
import org.spoofax.jsglr.client.IndentInfo;
import org.spoofax.jsglr.client.IndentationHandler;
import org.spoofax.jsglr.client.SGLR;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserHistory {
    private IndentationHandler indentHandler;
    private IndentationHandler recoveryIndentHandler;
    private ArrayList<IndentInfo> newLinePoints = new ArrayList();
    private int recoverTokenCount;
    private int tokenIndex;

    public int getTokenIndex() {
        return this.tokenIndex;
    }

    public int getIndexLastToken() {
        return this.recoverTokenCount - 1;
    }

    public void setTokenIndex(int tokenIndex) {
        this.tokenIndex = tokenIndex;
    }

    public ParserHistory() {
        this.clear();
    }

    public void clear() {
        this.newLinePoints.clear();
        this.recoverTokenCount = 0;
        this.tokenIndex = 0;
        this.indentHandler = new IndentationHandler();
        this.recoveryIndentHandler = new IndentationHandler();
    }

    public void resetRecoveryIndentHandler(int indentValue) {
        this.recoveryIndentHandler = new IndentationHandler();
        this.recoveryIndentHandler.setInLeftMargin(true);
        this.recoveryIndentHandler.setIndentValue(indentValue);
    }

    public void readRecoverToken(SGLR myParser, boolean keepRecoveredLines) {
        if (this.hasFinishedRecoverTokens()) {
            if (myParser.getCurrentToken() != 256 && this.getIndexLastToken() >= 0) {
                myParser.readNextToken();
                this.indentHandler.updateIndentation(myParser.getCurrentToken());
                ++this.recoverTokenCount;
                if (this.indentHandler.lineMarginEnded() || myParser.getCurrentToken() == 256) {
                    this.keepNewLinePoint(myParser, myParser.tokensSeen - 1, true, this.indentHandler);
                }
            }
        } else {
            myParser.setCurrentToken(this.readCharAt(this.tokenIndex, myParser.currentInputStream));
            if (myParser.getCurrentToken() == -1) {
                myParser.setCurrentToken(256);
            }
            if (keepRecoveredLines) {
                this.recoveryIndentHandler.updateIndentation(myParser.getCurrentToken());
                if (this.recoveryIndentHandler.lineMarginEnded() || myParser.getCurrentToken() == 256) {
                    this.keepNewLinePoint(myParser, this.tokenIndex, false, this.recoveryIndentHandler);
                }
            }
        }
        ++this.tokenIndex;
    }

    public boolean hasFinishedRecoverTokens() {
        return this.tokenIndex >= this.recoverTokenCount;
    }

    public int getTokensSeenStartLine(int tokPosition, PushbackStringIterator chars) {
        int tokIndexLine = tokPosition;
        while (this.readCharAt(tokIndexLine, chars) != 10 && tokIndexLine > 0) {
            --tokIndexLine;
        }
        return tokIndexLine;
    }

    private int readCharAt(int offset, PushbackStringIterator chars) {
        chars.setOffset(offset);
        return chars.read();
    }

    public void keepTokenAndState(SGLR myParser) {
        this.indentHandler.updateIndentation(myParser.getCurrentToken());
        ++this.recoverTokenCount;
        ++this.tokenIndex;
        if (this.indentHandler.lineMarginEnded() || myParser.getCurrentToken() == 256 || this.tokenIndex == 1) {
            this.keepNewLinePoint(myParser, myParser.tokensSeen - 1, false, this.indentHandler);
        }
    }

    public void keepInitialState(SGLR myParser) {
        IndentInfo newLinePoint = new IndentInfo(0, 0, 0);
        newLinePoint.fillStackNodes(myParser.activeStacks);
        this.newLinePoints.add(newLinePoint);
    }

    private void keepNewLinePoint(SGLR myParser, int tokSeen, boolean inRecoverMode, IndentationHandler anIndentHandler) {
        int indent = anIndentHandler.getIndentValue();
        IndentInfo newLinePoint = new IndentInfo(myParser.lineNumber, tokSeen, indent);
        this.newLinePoints.add(newLinePoint);
        if (!inRecoverMode) {
            newLinePoint.fillStackNodes(myParser.activeStacks);
        }
    }

    public String getFragment(int startTok, int endTok, PushbackStringIterator chars) {
        String fragment = "";
        int i = startTok;
        while (i <= endTok) {
            int nextChar = this.readCharAt(i, chars);
            if (i >= this.recoverTokenCount || nextChar == -1) break;
            fragment = String.valueOf(fragment) + (char)nextChar;
            ++i;
        }
        return fragment;
    }

    public String readLine(int StartTok, PushbackStringIterator chars) {
        String fragment = "";
        int pos = StartTok;
        int currentTok = 32;
        while (currentTok != 10 && currentTok != 256 && pos < this.recoverTokenCount) {
            currentTok = this.readCharAt(pos, chars);
            fragment = String.valueOf(fragment) + (char)currentTok;
            ++pos;
        }
        return fragment;
    }

    public IndentInfo getLine(int index) {
        if (index < 0 || index > this.getIndexLastLine()) {
            return null;
        }
        return this.newLinePoints.get(index);
    }

    public IndentInfo getLastLine() {
        return this.newLinePoints.get(this.newLinePoints.size() - 1);
    }

    public int getIndexLastLine() {
        return this.newLinePoints.size() - 1;
    }

    public ArrayList<IndentInfo> getLinesFromTo(int startIndex, int endLocation) {
        int indexLine = startIndex;
        ArrayList<IndentInfo> result = new ArrayList<IndentInfo>();
        IndentInfo firstLine = this.newLinePoints.get(indexLine);
        while (indexLine < this.newLinePoints.size()) {
            firstLine = this.newLinePoints.get(indexLine);
            if (firstLine.getTokensSeen() < endLocation) {
                result.add(firstLine);
                ++indexLine;
                continue;
            }
            indexLine = this.newLinePoints.size();
        }
        return result;
    }

    public void deleteLinesFrom(int startIndexErrorFragment) {
        if (startIndexErrorFragment >= 0 && startIndexErrorFragment < this.newLinePoints.size() - 1) {
            ArrayList<IndentInfo> shrinkedList = new ArrayList<IndentInfo>();
            shrinkedList.addAll(this.newLinePoints.subList(0, startIndexErrorFragment));
            this.newLinePoints = shrinkedList;
        } else if (startIndexErrorFragment > this.newLinePoints.size() - 1) {
            System.err.println("StartIndex Error Fragment: " + startIndexErrorFragment);
            System.err.println("Numeber Of Lines in History: : " + this.newLinePoints.size());
            System.err.println("Unexpected index of history new-line-points");
        }
    }

    public int getLineOfTokenPosition(int tokPos) {
        int i = 1;
        while (i < this.newLinePoints.size()) {
            IndentInfo line = this.newLinePoints.get(i);
            if (line.getTokensSeen() > tokPos) {
                return i - 1;
            }
            ++i;
        }
        return this.newLinePoints.size() - 1;
    }
}

