/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import org.spoofax.jsglr.client.FineGrainedOnRegion;
import org.spoofax.jsglr.client.Frame;
import org.spoofax.jsglr.client.IRecoveryParser;
import org.spoofax.jsglr.client.IRecoveryResult;
import org.spoofax.jsglr.client.Link;
import org.spoofax.jsglr.client.ParserHistory;
import org.spoofax.jsglr.client.RegionRecovery;
import org.spoofax.jsglr.client.SGLR;
import org.spoofax.jsglr.shared.ArrayDeque;
import org.spoofax.jsglr.shared.BadTokenException;
import org.spoofax.jsglr.shared.SGLRException;
import org.spoofax.jsglr.shared.TokenExpectedException;

public class RecoveryConnector {
    private SGLR mySGLR;
    private IRecoveryParser recoveryParser;
    private RegionRecovery skipRecovery;
    private boolean useBridgeParser;
    private boolean useFineGrained;
    private boolean onlyFineGrained;

    public void setOnlyFineGrained(boolean onlyFG) {
        this.onlyFineGrained = onlyFG;
    }

    public void setUseFineGrained(boolean useFG) {
        this.useFineGrained = useFG;
    }

    public void setUseBridgeParser(boolean useBridgeParser) {
        this.useBridgeParser = useBridgeParser;
    }

    public RecoveryConnector(SGLR parser, IRecoveryParser recoveryParser) {
        this.mySGLR = parser;
        this.skipRecovery = new RegionRecovery(this.mySGLR);
        this.useFineGrained = true;
        this.onlyFineGrained = false;
        if (recoveryParser != null) {
            this.recoveryParser = recoveryParser;
            this.useBridgeParser = true;
        } else {
            this.useBridgeParser = false;
        }
    }

    private ParserHistory getHistory() {
        return this.mySGLR.getHistory();
    }

    public void recover() {
        this.mySGLR.getPerformanceMeasuring().startRecovery();
        this.combinedRecover();
        this.mySGLR.getPerformanceMeasuring().endRecovery(this.recoverySucceeded());
    }

    private void combinedRecover() {
        if (this.onlyFineGrained) {
            this.mySGLR.getPerformanceMeasuring().startFG();
            boolean fg = this.tryFineGrainedRepair();
            if (fg) {
                System.out.println("FG-only Succeeded");
            }
            this.mySGLR.getPerformanceMeasuring().endFG(fg);
            return;
        }
        this.mySGLR.getPerformanceMeasuring().startCG();
        boolean skipSucceeded = this.skipRecovery.selectErroneousFragment();
        this.mySGLR.getPerformanceMeasuring().endCG(skipSucceeded);
        this.mySGLR.acceptingStack = null;
        this.mySGLR.activeStacks.clear();
        if (this.useBridgeParser) {
            String errorFragment = this.skipRecovery.getErrorFragmentWithLeftMargin();
            this.mySGLR.getPerformanceMeasuring().startBP();
            boolean succeeded = this.tryBridgeRepair(errorFragment);
            this.mySGLR.getPerformanceMeasuring().endBP(succeeded);
            if (succeeded) {
                return;
            }
        }
        if (this.useFineGrained) {
            this.mySGLR.getPerformanceMeasuring().startFG();
            boolean FGSucceeded = this.tryFineGrainedRepair();
            this.mySGLR.getPerformanceMeasuring().endFG(FGSucceeded);
            if (FGSucceeded) {
                this.addSkipOption(skipSucceeded);
                return;
            }
        }
        if (skipSucceeded) {
            this.getHistory().deleteLinesFrom(this.skipRecovery.getStartIndexErrorFragment());
            this.getHistory().resetRecoveryIndentHandler(this.skipRecovery.getStartLineErrorFragment().getIndentValue());
            this.parseErrorFragmentAsWhiteSpace(false);
            boolean bl = this.parseRemainingTokens(true);
        }
    }

    private void addSkipOption(boolean skipSucceeded) {
        ArrayDeque<Frame> fgStacks = new ArrayDeque<Frame>();
        fgStacks.addAll(this.mySGLR.activeStacks);
        if (skipSucceeded && this.parseErrorFragmentAsWhiteSpace(false) && this.parseRemainingTokens(false)) {
            for (Frame frame : this.mySGLR.activeStacks) {
                for (Link l : frame.getAllLinks()) {
                    l.recoverCount = 5;
                }
            }
            for (Frame frame : fgStacks) {
                this.mySGLR.addStack(frame);
            }
        }
    }

    private boolean recoverySucceeded() {
        return this.mySGLR.activeStacks.size() > 0 || this.mySGLR.acceptingStack != null;
    }

    private boolean tryFineGrainedRepair() {
        FineGrainedOnRegion fgRepair = new FineGrainedOnRegion(this.mySGLR);
        if (!this.onlyFineGrained) {
            fgRepair.setRegionInfo(this.skipRecovery.getErroneousRegion(), this.skipRecovery.getAcceptPosition());
        } else {
            fgRepair.setInfoFGOnly();
        }
        fgRepair.recover();
        fgRepair.parseRemainingTokens();
        return this.recoverySucceeded();
    }

    private boolean tryBridgeRepair(String errorFragment) {
        String repairedFragment = this.repairBridges(errorFragment);
        this.mySGLR.activeStacks.addAll(this.skipRecovery.getStartLineErrorFragment().getStackNodes());
        this.tryParsing(repairedFragment, false);
        return this.parseRemainingTokens(true);
    }

    private String repairBridges(String errorFragment) {
        try {
            IRecoveryResult bpResult = null;
            bpResult = this.recoveryParser.recover(errorFragment);
            return bpResult.getResult();
        }
        catch (TokenExpectedException e) {
            e.printStackTrace();
        }
        catch (BadTokenException e) {
            e.printStackTrace();
        }
        catch (SGLRException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errorFragment;
    }

    private void tryParsing(String fragment, boolean asLayout) {
        int indexFragment = this.findFirstNonLayoutToken(fragment);
        while (indexFragment < fragment.length() && this.mySGLR.activeStacks.size() > 0) {
            this.mySGLR.setCurrentToken(fragment.charAt(indexFragment));
            ++indexFragment;
            if (!asLayout) {
                this.mySGLR.doParseStep();
                continue;
            }
            this.parseAsLayout();
        }
    }

    public boolean parseErrorFragmentAsWhiteSpace(boolean keepLines) {
        this.mySGLR.activeStacks.clear();
        this.mySGLR.activeStacks.addAll(this.skipRecovery.getStartLineErrorFragment().getStackNodes());
        this.getHistory().setTokenIndex(this.skipRecovery.getStartPositionErrorFragment());
        while (this.getHistory().getTokenIndex() < this.skipRecovery.getEndPositionErrorFragment() && this.mySGLR.activeStacks.size() > 0 && this.mySGLR.acceptingStack == null) {
            this.getHistory().readRecoverToken(this.mySGLR, keepLines);
            this.parseAsLayout();
        }
        return this.recoverySucceeded();
    }

    public boolean parseRemainingTokens(boolean keepHistory) {
        this.getHistory().setTokenIndex(this.skipRecovery.getEndPositionErrorFragment());
        while (!this.getHistory().hasFinishedRecoverTokens() && this.mySGLR.activeStacks.size() > 0 && this.mySGLR.acceptingStack == null) {
            this.getHistory().readRecoverToken(this.mySGLR, keepHistory);
            this.mySGLR.doParseStep();
        }
        return this.recoverySucceeded();
    }

    private void parseAsLayout() {
        if (!RecoveryConnector.isLayoutCharacter((char)this.mySGLR.getCurrentToken()) && this.mySGLR.getCurrentToken() != 256) {
            this.mySGLR.setCurrentToken(32);
        }
        this.mySGLR.doParseStep();
    }

    public static boolean isLayoutCharacter(char aChar) {
        return aChar == ' ' || aChar == '\t' || aChar == '\n';
    }

    private int findFirstNonLayoutToken(String repairedFragment) {
        int indexFragment = 0;
        while (indexFragment < repairedFragment.length() - 1 && RecoveryConnector.isLayoutCharacter(repairedFragment.charAt(indexFragment))) {
            ++indexFragment;
        }
        return indexFragment;
    }
}

