/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.util.ArrayList;
import org.spoofax.jsglr.client.IndentInfo;
import org.spoofax.jsglr.client.IndentationHandler;
import org.spoofax.jsglr.client.NewStructureSkipper;
import org.spoofax.jsglr.client.ParserHistory;
import org.spoofax.jsglr.client.SGLR;
import org.spoofax.jsglr.client.StructureSkipSuggestion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionRecovery {
    private SGLR myParser;
    private StructureSkipSuggestion erroneousRegion;
    private int errorDetectionLocation;
    public static int NR_OF_LINES_TILL_SUCCESS = 6;
    private int acceptPosition;

    public int getAcceptPosition() {
        return this.acceptPosition;
    }

    public RegionRecovery(SGLR sglr) {
        this.myParser = sglr;
    }

    private ParserHistory getHistory() {
        return this.myParser.getHistory();
    }

    public IndentInfo getStartLineErrorFragment() {
        return this.erroneousRegion.getStartSkip();
    }

    public int getEndPositionErrorFragment() {
        return this.erroneousRegion.getEndSkip().getTokensSeen();
    }

    public int getStartPositionErrorFragment() {
        return this.erroneousRegion.getStartSkip().getTokensSeen();
    }

    public String getErrorFragmentWithLeftMargin() {
        int tokIndexLine = this.getHistory().getTokensSeenStartLine(this.getStartLineErrorFragment().getTokensSeen(), this.myParser.currentInputStream);
        return this.getHistory().getFragment(tokIndexLine, this.getEndPositionErrorFragment() - 1, this.myParser.currentInputStream);
    }

    public String getErrorFragment() {
        int tokIndexLine = this.getStartPositionErrorFragment();
        return this.getHistory().getFragment(tokIndexLine, this.getEndPositionErrorFragment() - 1, this.myParser.currentInputStream);
    }

    public int getStartPositionErrorFragment_InclLeftMargin() {
        int tokIndexLine = this.getHistory().getTokensSeenStartLine(this.getStartLineErrorFragment().getTokensSeen(), this.myParser.currentInputStream);
        return tokIndexLine;
    }

    public ArrayList<IndentInfo> getSkippedLines() {
        return this.getHistory().getLinesFromTo(this.erroneousRegion.getIndexHistoryStart(), this.getEndPositionErrorFragment());
    }

    public boolean selectErroneousFragment() {
        boolean eofReached = this.myParser.getCurrentToken() == 256;
        this.acceptPosition = -1;
        NewStructureSkipper newRegionSelector = new NewStructureSkipper(this.myParser);
        int failureIndex = this.getHistory().getIndexLastLine();
        assert (failureIndex >= 0);
        this.errorDetectionLocation = this.getHistory().getIndexLastToken();
        ArrayList<StructureSkipSuggestion> prevRegions = newRegionSelector.getPreviousSkipSuggestions(failureIndex);
        if (this.trySetErroneousRegion(prevRegions)) {
            ArrayList<StructureSkipSuggestion> decomposedRegions = newRegionSelector.getZoomOnPreviousSuggestions(this.erroneousRegion);
            this.trySetErroneousRegion(decomposedRegions);
            return true;
        }
        ArrayList<StructureSkipSuggestion> currentRegions = newRegionSelector.getCurrentSkipSuggestions(failureIndex);
        if (this.trySetErroneousRegion(currentRegions)) {
            return true;
        }
        ArrayList<StructureSkipSuggestion> priorRegions = newRegionSelector.getPriorSkipSuggestions(failureIndex);
        if (this.trySetErroneousRegion(priorRegions)) {
            ArrayList<StructureSkipSuggestion> decomposedRegions = newRegionSelector.getZoomOnPreviousSuggestions(this.erroneousRegion);
            this.trySetErroneousRegion(decomposedRegions);
            return true;
        }
        ArrayList<StructureSkipSuggestion> siblingForWardRegions = newRegionSelector.getSibblingForwardSuggestions(failureIndex);
        if (this.trySetErroneousRegion(siblingForWardRegions)) {
            return true;
        }
        ArrayList<StructureSkipSuggestion> siblingBackWardRegions = newRegionSelector.getSibblingBackwardSuggestions(failureIndex);
        if (this.trySetErroneousRegion(siblingBackWardRegions)) {
            return true;
        }
        ArrayList<StructureSkipSuggestion> siblingSurroundingRegions = newRegionSelector.getSibblingSurroundingSuggestions(failureIndex);
        if (this.trySetErroneousRegion(siblingSurroundingRegions)) {
            return true;
        }
        ArrayList<StructureSkipSuggestion> parentRegion = newRegionSelector.getParentSkipSuggestions(failureIndex);
        if (this.trySetErroneousRegion(parentRegion)) {
            return true;
        }
        this.erroneousRegion = newRegionSelector.getErroneousPrefix(failureIndex);
        ArrayList<StructureSkipSuggestion> decomposedRegions = newRegionSelector.getZoomOnPreviousSuggestions(this.erroneousRegion);
        boolean findSmallerPart = this.trySetErroneousRegion(decomposedRegions);
        if (!findSmallerPart) {
            if (eofReached) {
                int structStart = this.getHistory().getLastLine().structureStartPosition();
                int structStartIndex = this.getHistory().getLineOfTokenPosition(structStart);
                ArrayList<StructureSkipSuggestion> structRegions = newRegionSelector.getBlockSuggestions(structStartIndex);
                if (this.trySetErroneousRegion(structRegions)) {
                    return true;
                }
            }
            int indexAccept = this.getHistory().getIndexLastLine() >= failureIndex + NR_OF_LINES_TILL_SUCCESS ? failureIndex + NR_OF_LINES_TILL_SUCCESS : this.getHistory().getIndexLastLine();
            this.acceptPosition = this.getHistory().getLine(indexAccept).getTokensSeen();
            IndentInfo openEnd = new IndentInfo();
            openEnd.setTokensSeen(Integer.MAX_VALUE);
            this.erroneousRegion.setEndSkip(openEnd, Integer.MAX_VALUE);
            return false;
        }
        return true;
    }

    private boolean trySetErroneousRegion(ArrayList<StructureSkipSuggestion> regions) {
        StructureSkipSuggestion aSkip = new StructureSkipSuggestion();
        int indexSkips = 0;
        this.myParser.acceptingStack = null;
        this.myParser.activeStacks.clear();
        boolean hasFoundErroneousRegion = false;
        while (indexSkips < regions.size() && !hasFoundErroneousRegion) {
            aSkip = regions.get(indexSkips);
            hasFoundErroneousRegion = this.testRegion(aSkip);
            ++indexSkips;
        }
        if (hasFoundErroneousRegion) {
            this.erroneousRegion = aSkip;
        }
        return hasFoundErroneousRegion;
    }

    private boolean testRegion(StructureSkipSuggestion aSkip) {
        IndentInfo endPos = aSkip.getEndSkip();
        this.getHistory().setTokenIndex(endPos.getTokensSeen());
        this.myParser.activeStacks.clear();
        this.myParser.acceptingStack = null;
        this.myParser.activeStacks.addAll(endPos.getStackNodes());
        this.parseAdditionalTokens(aSkip);
        int nrOfParsedLines = 0;
        IndentationHandler indentHandler = new IndentationHandler();
        indentHandler.setInLeftMargin(false);
        while (this.myParser.activeStacks.size() > 0 && nrOfParsedLines < NR_OF_LINES_TILL_SUCCESS) {
            this.getHistory().readRecoverToken(this.myParser, false);
            indentHandler.updateIndentation(this.myParser.getCurrentToken());
            this.myParser.doParseStep();
            if (this.getHistory().getTokenIndex() <= this.errorDetectionLocation || !indentHandler.lineMarginEnded()) continue;
            ++nrOfParsedLines;
        }
        if (this.successCriterion()) {
            this.acceptPosition = this.getHistory().getTokenIndex();
            return true;
        }
        return false;
    }

    private void parseAdditionalTokens(StructureSkipSuggestion aSkip) {
        char[] cArray = aSkip.getAdditionalTokens();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char aChar = cArray[n2];
            this.myParser.setCurrentToken(aChar);
            this.myParser.doParseStep();
            ++n2;
        }
        if (aSkip.getAdditionalTokens().length > 0) {
            aSkip.getStartSkip().fillStackNodes(this.myParser.activeStacks);
            aSkip.getEndSkip().fillStackNodes(this.myParser.activeStacks);
            aSkip.getStartSkip().setTokensSeen(aSkip.getStartSkip().getTokensSeen() + aSkip.getAdditionalTokens().length);
            aSkip.setAdditionalTokens(new char[0]);
        }
    }

    private String getInputFragment(StructureSkipSuggestion aSkip) {
        return this.getHistory().getFragment(aSkip.getStartSkip().getTokensSeen(), aSkip.getEndSkip().getTokensSeen() - 1, this.myParser.currentInputStream);
    }

    private boolean successCriterion() {
        return this.myParser.activeStacks.size() > 0 || this.myParser.acceptingStack != null;
    }

    public int getStartIndexErrorFragment() {
        return this.erroneousRegion.getIndexHistoryStart();
    }

    public StructureSkipSuggestion getErroneousRegion() {
        return this.erroneousRegion;
    }
}

