/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.spoofax.jsglr.client.Action;
import org.spoofax.jsglr.client.ActionItem;
import org.spoofax.jsglr.client.Goto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State
implements Serializable {
    static final long serialVersionUID = 3383369639779986307L;
    public final int stateNumber;
    private final Goto[] gotos;
    private final Action[] actions;

    public State(int stateNumber, Goto[] gotos, Action[] actions) {
        this.stateNumber = stateNumber;
        this.gotos = gotos;
        this.actions = actions;
    }

    @Deprecated
    public List<ActionItem> getActionItems(int currentToken) {
        ArrayList<ActionItem> ret = new ArrayList<ActionItem>(this.actions.length);
        Action[] actionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            Action a = actionArray[n2];
            if (a.accepts(currentToken)) {
                ActionItem[] actionItemArray = a.getActionItems();
                int n3 = actionItemArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ActionItem it = actionItemArray[n4];
                    ret.add(it);
                    ++n4;
                }
            }
            ++n2;
        }
        return ret;
    }

    public Action[] getActions() {
        return this.actions;
    }

    public Action getSingularAction() {
        return this.actions.length == 1 ? this.actions[0] : null;
    }

    public int go(int labelNumber) {
        Goto[] gotoArray = this.gotos;
        int n = this.gotos.length;
        int n2 = 0;
        while (n2 < n) {
            Goto g = gotoArray[n2];
            if (g.hasProd(labelNumber)) {
                return g.nextState;
            }
            ++n2;
        }
        throw new IllegalStateException("Cannot go to label #" + labelNumber);
    }

    public boolean rejectable() {
        Action[] actionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            Action a = actionArray[n2];
            if (a.rejectable()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getActionItemCount() {
        int total = 0;
        Action[] actionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            Action a = actionArray[n2];
            total += a.getActionItems().length;
            ++n2;
        }
        return total;
    }

    public int getGotoCount() {
        return this.gotos.length;
    }

    public int getActionCount() {
        return this.actions.length;
    }

    public boolean hasPrefer() {
        Action[] actionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            Action a = actionArray[n2];
            if (a.hasPrefer()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasAvoid() {
        Action[] actionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            Action a = actionArray[n2];
            if (a.hasAvoid()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("State(");
        sb.append(this.stateNumber);
        sb.append(", #");
        sb.append(this.actions.length);
        sb.append(" actions, #");
        sb.append(this.gotos.length);
        sb.append(" gotos)");
        sb.append("\n - [");
        int i = 0;
        while (i < this.gotos.length) {
            sb.append(this.gotos[i]);
            if (i < this.gotos.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("]\n - [");
        i = 0;
        while (i < this.actions.length) {
            sb.append(this.actions[i]);
            if (i < this.actions.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

