/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.incremental;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.jsglr.client.imploder.AbstractTokenizer;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokenizer;
import org.spoofax.jsglr.client.imploder.ITreeFactory;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.jsglr.client.imploder.Token;
import org.spoofax.jsglr.client.imploder.Tokenizer;
import org.spoofax.jsglr.client.incremental.DamageRegionAnalyzer;
import org.spoofax.jsglr.client.incremental.IncrementalSGLR;
import org.spoofax.jsglr.client.incremental.IncrementalSGLRException;
import org.spoofax.jsglr.client.incremental.IncrementalSortSet;
import org.spoofax.terms.SimpleTermVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalTreeBuilder<TNode extends ISimpleTerm> {
    private static final int NO_STOP_OFFSET = Integer.MAX_VALUE;
    private final ITreeFactory<TNode> factory;
    private final IncrementalSortSet incrementalSorts;
    private final int damageStart;
    private final int damageEnd;
    private final int skippedChars;
    private final int damageSizeChange;
    private final Set<ISimpleTerm> damageNodes;
    private final List<ISimpleTerm> repairedNodes;
    private final Tokenizer newTokenizer;
    private final DamageRegionAnalyzer damageAnalyzer;
    private final List<TNode> reconstructedNodes = new ArrayList<TNode>();
    private boolean isRepairedNodesInserted;

    public IncrementalTreeBuilder(IncrementalSGLR<TNode> parser, DamageRegionAnalyzer damageAnalyzer, String input, String filename, Set<ISimpleTerm> damageNodes, List<ISimpleTerm> repairedTreeNodes, int skippedChars) {
        this.damageAnalyzer = damageAnalyzer;
        this.damageNodes = damageNodes;
        this.factory = parser.factory;
        this.incrementalSorts = damageAnalyzer.incrementalSorts;
        this.damageStart = damageAnalyzer.damageStart;
        this.damageEnd = damageAnalyzer.damageEnd;
        this.skippedChars = skippedChars;
        this.damageSizeChange = damageAnalyzer.damageSizeChange;
        this.repairedNodes = repairedTreeNodes;
        this.newTokenizer = new Tokenizer(input, filename, parser.parser.getParseTable().getKeywordRecognizer());
    }

    public TNode buildOutput(ISimpleTerm oldTreeNode) throws IncrementalSGLRException {
        this.isRepairedNodesInserted = false;
        TNode result = this.buildOutputSubtree(oldTreeNode, 0, false, false);
        assert (result != null);
        if (!this.isRepairedNodesInserted) {
            throw new IncrementalSGLRException("Postcondition failed: unable to insert repaired tree nodes in original tree: " + this.repairedNodes);
        }
        this.newTokenizer.makeToken(this.newTokenizer.getStartOffset() - 1, 8, true);
        this.newTokenizer.setAst((ISimpleTerm)result);
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertionsEnabled) {
            this.newTokenizer.initAstNodeBinding();
        }
        return result;
    }

    public List<TNode> getLastReconstructedNodes() {
        return this.reconstructedNodes;
    }

    private TNode buildOutputSubtree(ISimpleTerm treeNode, int offsetChange, boolean expectDamagedNode, boolean isRepairedNode) throws IncrementalSGLRException {
        List<ISimpleTerm> children;
        IToken beforeStartToken = this.newTokenizer.currentToken();
        IToken startToken = ImploderAttachment.getLeftToken(treeNode);
        this.sanityCheckOldTreeNode(treeNode);
        if (!isRepairedNode && treeNode.isList() && this.incrementalSorts.isIncrementalContainerNode(treeNode)) {
            children = this.buildDamagedSubtree(treeNode, offsetChange, startToken);
        } else {
            if (!isRepairedNode && this.damageAnalyzer.isDamageTreeNode(treeNode, true, this.skippedChars)) {
                if (!expectDamagedNode) {
                    throw new IncrementalSGLRException(new IllegalStateException("Constructing resulting tree failed; unexpected damaged tree node: " + treeNode + " should be in a list of one of the sorts: " + this.incrementalSorts));
                }
                return null;
            }
            children = IncrementalTreeBuilder.copyChildrenToList(treeNode);
            int i = 0;
            while (i < children.size()) {
                ISimpleTerm child = children.get(i);
                int myOffsetChange = offsetChange + (this.isRepairedNodesInserted ? this.damageSizeChange : 0);
                this.copyTokens(startToken, AbstractTokenizer.findLeftMostLayoutToken(ImploderAttachment.getLeftToken(child)), Integer.MAX_VALUE, myOffsetChange);
                startToken = AbstractTokenizer.getTokenAfter(ImploderAttachment.getRightToken(child));
                TNode child2 = this.buildOutputSubtree(child, offsetChange, expectDamagedNode, isRepairedNode);
                if (child2 == null) {
                    return null;
                }
                children.set(i, (ISimpleTerm)child2);
                ++i;
            }
        }
        int myOffsetChange = offsetChange + (this.isRepairedNodesInserted ? this.damageSizeChange : 0);
        IToken stopToken = AbstractTokenizer.getTokenAfter(ImploderAttachment.getRightToken(treeNode));
        this.copyTokens(startToken, stopToken, Integer.MAX_VALUE, myOffsetChange);
        return this.buildOutputNode(treeNode, children, beforeStartToken);
    }

    private List<ISimpleTerm> buildDamagedSubtree(ISimpleTerm treeNode, int offsetChange, IToken startToken) throws IncrementalSGLRException {
        ArrayList<ISimpleTerm> results = new ArrayList<ISimpleTerm>(treeNode.getSubtermCount() + this.repairedNodes.size());
        Iterator<ISimpleTerm> iterator = SimpleTermVisitor.tryGetListIterator(treeNode);
        int i = 0;
        int max2 = treeNode.getSubtermCount();
        while (i < max2) {
            ISimpleTerm child;
            ISimpleTerm iSimpleTerm = child = iterator == null ? treeNode.getSubterm(i) : iterator.next();
            if (this.damageNodes.contains(child)) {
                this.copyTokensAndTryAddRepairedNodes(treeNode, results, startToken, ImploderAttachment.getLeftToken(child), ImploderAttachment.getRightToken(child));
            } else {
                startToken = AbstractTokenizer.getTokenAfter(ImploderAttachment.getRightToken(child));
                TNode child2 = this.buildOutputSubtree(child, offsetChange, true, false);
                if (child2 != null) {
                    results.add((ISimpleTerm)child2);
                }
            }
            ++i;
        }
        IToken stopToken = AbstractTokenizer.getTokenAfter(AbstractTokenizer.findRightMostLayoutToken(ImploderAttachment.getRightToken(treeNode)));
        this.copyTokensAndTryAddRepairedNodes(treeNode, results, startToken, stopToken, stopToken);
        return results;
    }

    private void sanityCheckOldTreeNode(ISimpleTerm oldTreeNode) {
        ISimpleTerm tOldTreeNode = oldTreeNode;
        assert (this.factory.tryGetAmbChildren(tOldTreeNode) == null) : "Incremental tree building with ambiguities not implemented";
    }

    private TNode buildOutputNode(ISimpleTerm oldTreeNode, List<ISimpleTerm> children, IToken beforeStartToken) {
        IToken startToken = this.newTokenizer.currentToken() == beforeStartToken ? this.newTokenizer.makeToken(this.newTokenizer.getStartOffset() - 1, 0, true) : AbstractTokenizer.getTokenAfter(beforeStartToken);
        return (TNode)this.factory.recreateNode(oldTreeNode, startToken, this.newTokenizer.currentToken(), children);
    }

    private void copyTokensAndTryAddRepairedNodes(ISimpleTerm oldTreeNode, List<ISimpleTerm> results, IToken firstToken, IToken stopToken, IToken childEndToken) throws IncrementalSGLRException {
        if (!this.isRepairedNodesInserted && childEndToken.getEndOffset() >= this.damageStart) {
            this.copyTokens(firstToken, stopToken, this.damageStart, 0);
            this.insertRepairedNodes(oldTreeNode, results);
            this.copyTokens(firstToken, stopToken, this.damageEnd + this.damageSizeChange - this.skippedChars + 1, this.damageSizeChange);
        } else {
            this.copyTokens(firstToken, stopToken, this.damageStart, 0);
        }
    }

    private void insertRepairedNodes(ISimpleTerm oldTreeNode, List<ISimpleTerm> results) throws IncrementalSGLRException {
        if (this.repairedNodes.size() > 0) {
            IToken firstToken = AbstractTokenizer.getTokenBefore(ImploderAttachment.getLeftToken(this.repairedNodes.get(0)));
            for (ISimpleTerm node : this.repairedNodes) {
                this.copyTokens(firstToken, ImploderAttachment.getLeftToken(node), Integer.MAX_VALUE, this.skippedChars);
                firstToken = AbstractTokenizer.getTokenAfter(ImploderAttachment.getRightToken(node));
                TNode reconstructed = this.buildOutputSubtree(node, this.skippedChars, false, true);
                this.reconstructedNodes.add(reconstructed);
                results.add((ISimpleTerm)reconstructed);
            }
        }
        this.isRepairedNodesInserted = true;
    }

    private void copyTokens(IToken startToken, IToken stopToken, int stopOffset, int offsetChange) {
        ITokenizer fromTokenizer = startToken.getTokenizer();
        assert (fromTokenizer == stopToken.getTokenizer());
        int oldStartOffset = this.newTokenizer.getStartOffset();
        int i = AbstractTokenizer.findLeftMostLayoutToken(startToken).getIndex();
        int last = stopToken.getIndex();
        while (i < last) {
            IToken fromToken = fromTokenizer.getTokenAt(i);
            int myEndOffset = Math.min(stopOffset, fromToken.getEndOffset()) + offsetChange;
            if (myEndOffset >= oldStartOffset) {
                Token toToken = this.newTokenizer.makeToken(myEndOffset, fromToken.getKind(), IncrementalTreeBuilder.isEssentialToken(fromToken));
                assert (toToken == null || myEndOffset < fromToken.getEndOffset() + offsetChange || fromToken.toString().equals(this.newTokenizer.getInput().substring(fromToken.getStartOffset() + offsetChange, fromToken.getEndOffset() + offsetChange + 1))) : "Expected '" + fromToken + "' in copied tokenstream, not '" + toToken + "'";
            }
            ++i;
        }
    }

    private static boolean isEssentialToken(IToken token) {
        switch (token.getKind()) {
            case 9: 
            case 10: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private static List<ISimpleTerm> copyChildrenToList(ISimpleTerm tree) {
        ArrayList<ISimpleTerm> results = new ArrayList<ISimpleTerm>(tree.getSubtermCount());
        Iterator<ISimpleTerm> iterator = SimpleTermVisitor.tryGetListIterator(tree);
        int i = 0;
        int max2 = tree.getSubtermCount();
        while (i < max2) {
            ISimpleTerm child = iterator == null ? tree.getSubterm(i) : iterator.next();
            results.add(child);
            ++i;
        }
        return results;
    }
}

