/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.tests;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.Asfix2TreeBuilder;
import org.spoofax.jsglr.client.InvalidParseTableException;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.jsglr.client.ParserException;
import org.spoofax.jsglr.client.PathListPool;
import org.spoofax.jsglr.client.PooledPathList;
import org.spoofax.jsglr.client.SGLR;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.jsglr.client.imploder.TermTreeFactory;
import org.spoofax.jsglr.client.imploder.TreeBuilder;
import org.spoofax.jsglr.client.incremental.CommentDamageExpander;
import org.spoofax.jsglr.client.incremental.IncrementalSGLR;
import org.spoofax.jsglr.client.incremental.IncrementalSortSet;
import org.spoofax.jsglr.io.FileTools;
import org.spoofax.jsglr.io.ParseTableManager;
import org.spoofax.jsglr.shared.SGLRException;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.attachments.ParentTermFactory;
import org.spoofax.terms.io.binary.TermReader;

public abstract class ParseTestCase
extends TestCase {
    private static final ParseTableManager parseTables = new ParseTableManager();
    protected SGLR sglr;
    protected String suffix;
    protected ParseTable table;
    protected IncrementalSGLR<IStrategoTerm> incrementalSGLR;
    static final TermFactory pf = new TermFactory();
    boolean doCompare = true;

    protected final void setUp() throws Exception {
        this.gwtSetUp();
    }

    protected void gwtSetUp() throws Exception {
    }

    public void gwtSetUp(String grammar, String suffix, String ... incrementalSorts) throws ParserException, InvalidParseTableException {
        this.suffix = suffix;
        String fn = "tests/grammars/" + grammar + ".tbl";
        try {
            this.table = parseTables.loadFromFile(fn);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.sglr = new SGLR(new Asfix2TreeBuilder(this.table.getFactory()), this.table);
        if (incrementalSorts.length > 0) {
            ParentTermFactory termFactory = new ParentTermFactory(this.sglr.getParseTable().getFactory());
            TermTreeFactory factory = new TermTreeFactory(termFactory);
            TreeBuilder builder = new TreeBuilder(factory);
            this.sglr.setTreeBuilder(builder);
            IncrementalSortSet sorts = IncrementalSortSet.create(this.table, true, incrementalSorts);
            this.incrementalSGLR = new IncrementalSGLR<IStrategoTerm>(this.sglr, CommentDamageExpander.C_STYLE, factory, sorts);
            IncrementalSGLR.DEBUG = true;
        }
    }

    private IStrategoTerm tryReadTermFromFile(String fn) throws ParseError {
        try {
            return new TermReader(pf).parseFromFile(fn);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void tearDown() throws Exception {
    }

    public IStrategoTerm doParseTest(String s) {
        String result = this.loadAsString(s);
        ParseTestCase.assertNotNull("Data file is missing: " + s, result);
        long parseTime = System.nanoTime();
        IStrategoTerm parsed2 = null;
        try {
            parsed2 = (IStrategoTerm)this.sglr.parse(result, null, null);
        }
        catch (SGLRException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        parseTime = System.nanoTime() - parseTime;
        System.out.println("Parsing " + s + " took " + parseTime / 1000L / 1000L + " millis.");
        ParseTestCase.assertNotNull(parsed2);
        if (this.doCompare) {
            this.doCompare(s, parsed2);
        } else {
            if (ImploderAttachment.getLeftToken(parsed2) != null) {
                System.out.println(ImploderAttachment.getLeftToken(parsed2).getTokenizer());
            }
            System.out.println(ParseTestCase.toCompactString(parsed2));
        }
        System.out.println(PathListPool.asyncCacheMisses);
        System.out.println(PooledPathList.maxRemembered);
        System.out.println(PooledPathList.maxAllocated);
        return parsed2;
    }

    public IStrategoTerm doParseIncrementalTest(IStrategoTerm oldTree, String newFile, String ... repairTypes) throws Exception {
        String extension;
        String contents = this.loadAsString(newFile);
        ParseTestCase.assertNotNull(contents);
        long parseTime = System.nanoTime();
        System.out.println("------------------------");
        System.out.println("Parsing " + newFile);
        this.incrementalSGLR.setLastAst(oldTree);
        IStrategoTerm newTree = this.incrementalSGLR.parseIncremental(contents, newFile, null);
        parseTime = System.nanoTime() - parseTime;
        System.out.println("Incremental parsing " + newFile + " took " + parseTime / 1000L / 1000L + " millis" + (IncrementalSGLR.DEBUG ? " including debug printing" : ""));
        String string = extension = this.sglr.getTreeBuilder() instanceof TreeBuilder ? ".itrm" : ".trm";
        if (this.doCompare) {
            IStrategoTerm iStrategoTerm = this.tryReadTermFromFile("tests/data/" + newFile + extension);
            System.out.println(ParseTestCase.toCompactString(newTree));
            System.out.println(ParseTestCase.toCompactString(iStrategoTerm));
            if (!newTree.match(iStrategoTerm)) {
                ParseTestCase.fail("Incremental result not same as non-incremental result");
            }
            this.doTokenStreamEqualityTest(oldTree, newTree);
        } else {
            System.out.println(ParseTestCase.toCompactString(newTree));
        }
        if (repairTypes.length > 0) {
            for (ISimpleTerm iSimpleTerm : this.incrementalSGLR.getLastReconstructedNodes()) {
                if (Arrays.asList(repairTypes).contains(ImploderAttachment.getSort(iSimpleTerm))) continue;
                ParseTestCase.fail("Unexpected repaired tree node of type " + ImploderAttachment.getSort(iSimpleTerm) + ": " + iSimpleTerm);
            }
        }
        return newTree;
    }

    private void doTokenStreamEqualityTest(IStrategoTerm oldTree, IStrategoTerm newTree) {
        String tokens = ImploderAttachment.getLeftToken(newTree).getTokenizer().toString();
        if (tokens.length() > 300) {
            tokens = String.valueOf(tokens.substring(0, 300)) + "...";
        }
        System.out.println(tokens);
    }

    protected String loadAsString(String testFile) {
        return FileTools.tryLoadFileAsString("tests/data/" + testFile + "." + this.suffix);
    }

    private void doCompare(String s, IStrategoTerm parsed2) {
        IStrategoTerm wanted;
        String extension = this.sglr.getTreeBuilder() instanceof TreeBuilder ? ".itrm" : ".trm";
        try {
            long parseTime = System.nanoTime();
            wanted = new TermReader(pf).parseFromFile("tests/data/" + s + extension);
            parseTime = System.nanoTime() - parseTime;
            System.out.println("reading term " + s + extension + " took " + parseTime / 1000L / 1000L + " millis");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ParseTestCase.assertNotNull(wanted);
        System.out.println(ParseTestCase.toCompactString(parsed2));
        System.out.println(ParseTestCase.toCompactString(wanted));
        if (!parsed2.match(wanted)) {
            ParseTestCase.fail();
        }
    }

    private static String toCompactString(IStrategoTerm term) {
        return term.toString();
    }

    public String getModuleName() {
        return "org.spoofax.JsglrGWT";
    }
}

