/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.tests;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokenizer;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.jsglr.client.imploder.TreeBuilder;
import org.spoofax.jsglr.tests.ParseTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTokenize
extends ParseTestCase {
    @Override
    protected void gwtSetUp() throws Exception {
        super.gwtSetUp("Java-15", "java", new String[0]);
        this.sglr.setTreeBuilder(new TreeBuilder());
        this.sglr.setUseStructureRecovery(true);
        this.doCompare = false;
    }

    public void testJava5() throws FileNotFoundException, IOException {
        IStrategoTerm parsed2 = this.doParseTest("java5");
        ITokenizer tokenizer = ImploderAttachment.getLeftToken(parsed2).getTokenizer();
        Iterator<IToken> tokens = tokenizer.iterator();
        System.out.println(tokenizer);
        TestTokenize.assertEquals(1, ((IToken)tokens.next()).getLine());
        IToken packageToken = TestTokenize.getNonEmptyToken(tokens);
        TestTokenize.assertEquals("package", packageToken.toString());
        TestTokenize.assertEquals("package", packageToken.toString());
        TestTokenize.assertEquals(1, packageToken.getLine());
        TestTokenize.assertEquals(" ", TestTokenize.getNonEmptyToken(tokens).toString());
        TestTokenize.assertEquals("java", TestTokenize.getNonEmptyToken(tokens).toString());
        TestTokenize.assertEquals(".", TestTokenize.getNonEmptyToken(tokens).toString());
        TestTokenize.assertEquals("java5", TestTokenize.getNonEmptyToken(tokens).toString());
        TestTokenize.assertEquals(";", TestTokenize.getNonEmptyToken(tokens).toString());
        TestTokenize.assertEquals("\n", TestTokenize.getNonEmptyToken(tokens).toString());
        TestTokenize.assertEquals("\n", TestTokenize.getNonEmptyToken(tokens).toString());
        IToken classToken = TestTokenize.getNonEmptyToken(tokens);
        IToken classToken2 = TestTokenize.getNonEmptyToken(tokens);
        System.out.println(classToken2.getLine());
        TestTokenize.assertEquals("class", classToken.toString());
        TestTokenize.assertEquals(4, classToken.getKind());
        TestTokenize.assertEquals(3, classToken.getLine());
        TestTokenize.assertEquals(8, tokenizer.getTokenAt(tokenizer.getTokenCount() - 1).getLine());
    }

    private static IToken getNonEmptyToken(Iterator<IToken> tokens) {
        IToken token;
        while ((token = tokens.next()).getEndOffset() < token.getStartOffset()) {
        }
        return token;
    }

    public void testJava6() throws FileNotFoundException, IOException {
        this.suffix = "java.recover";
        IStrategoTerm parsed2 = this.doParseTest("java6");
        ITokenizer tokenizer = ImploderAttachment.getLeftToken(parsed2).getTokenizer();
        Iterator<IToken> tokens = tokenizer.iterator();
        System.out.println(tokenizer);
        while (!TestTokenize.getNonEmptyToken(tokens).toString().equals("the")) {
        }
        IToken token = TestTokenize.getNonEmptyToken(tokens);
        TestTokenize.assertEquals(" ", token.toString());
        TestTokenize.assertEquals(9, token.getKind());
        token = TestTokenize.getNonEmptyToken(tokens);
        TestTokenize.assertEquals("int", token.toString());
        TestTokenize.assertEquals(10, token.getKind());
        token = TestTokenize.getNonEmptyToken(tokens);
        TestTokenize.assertEquals(" ", token.toString());
        TestTokenize.assertEquals(9, token.getKind());
        token = TestTokenize.getNonEmptyToken(tokens);
        TestTokenize.assertEquals("bar", token.toString());
        TestTokenize.assertEquals(9, token.getKind());
    }
}

