/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.io.IOException;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.terms.StrategoTerm;

public class StrategoTuple
extends StrategoTerm
implements IStrategoTuple {
    private IStrategoTerm[] kids;

    public StrategoTuple(IStrategoTerm[] kids, IStrategoList annotations, int storageType) {
        super(annotations, storageType);
        this.kids = kids;
    }

    public IStrategoTerm get(int index) {
        return this.kids[index];
    }

    public IStrategoTerm[] getAllSubterms() {
        IStrategoTerm[] r = new IStrategoTerm[this.kids.length];
        int i = 0;
        while (i < this.kids.length) {
            r[i] = this.kids[i];
            ++i;
        }
        return r;
    }

    public int size() {
        return this.kids.length;
    }

    public IStrategoTerm getSubterm(int index) {
        return this.kids[index];
    }

    public int getSubtermCount() {
        return this.kids.length;
    }

    public int getTermType() {
        return 7;
    }

    protected boolean doSlowMatch(IStrategoTerm second, int commonStorageType) {
        IStrategoList secondAnnotations;
        IStrategoList annotations;
        if (second.getTermType() != 7) {
            return false;
        }
        IStrategoTuple snd = (IStrategoTuple)second;
        if (this.size() != snd.size()) {
            return false;
        }
        IStrategoTerm[] kids = this.kids;
        IStrategoTerm[] secondKids = snd.getAllSubterms();
        if (kids != secondKids) {
            int i = 0;
            int sz = kids.length;
            while (i < sz) {
                IStrategoTerm kid = kids[i];
                IStrategoTerm secondKid = secondKids[i];
                if (kid != secondKid && !kid.match(secondKid)) {
                    if (commonStorageType == 2 && i != 0) {
                        System.arraycopy(secondKids, 0, kids, 0, i);
                    }
                    return false;
                }
                ++i;
            }
            if (commonStorageType == 2) {
                this.kids = secondKids;
            }
        }
        if ((annotations = this.getAnnotations()) == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        if (annotations.match(secondAnnotations)) {
            if (commonStorageType == 2) {
                this.internalSetAnnotations(secondAnnotations);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public void prettyPrint(ITermPrinter pp) {
        int sz = this.size();
        if (sz > 0) {
            pp.println("(");
            pp.indent(2);
            this.get(0).prettyPrint(pp);
            int i = 1;
            while (i < sz) {
                pp.print(",");
                pp.nextIndentOff();
                this.get(i).prettyPrint(pp);
                pp.println("");
                ++i;
            }
            pp.println("");
            pp.print(")");
            pp.outdent(2);
        } else {
            pp.print("()");
        }
        this.printAnnotations(pp);
    }

    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append('(');
        IStrategoTerm[] kids = this.getAllSubterms();
        if (kids.length > 0) {
            if (maxDepth == 0) {
                output.append("...");
            } else {
                kids[0].writeAsString(output, maxDepth - 1);
                int i = 1;
                while (i < kids.length) {
                    output.append(',');
                    kids[i].writeAsString(output, maxDepth - 1);
                    ++i;
                }
            }
        }
        output.append(')');
        this.appendAnnotations(output, maxDepth);
    }

    public int hashFunction() {
        long hc = 4831L;
        IStrategoTerm[] kids = this.getAllSubterms();
        int i = 0;
        while (i < kids.length) {
            hc *= (long)kids[i].hashCode();
            ++i;
        }
        return (int)(hc >> 10);
    }
}

