/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.io;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spoofax.NotImplementedException;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.StringTermReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAFTermReader
extends StringTermReader {
    private final StringBuilder sharedBuilder = new StringBuilder();

    public TAFTermReader(ITermFactory factory) {
        super(factory);
    }

    public IStrategoTerm parseFromFile(String path) throws IOException, ParseError {
        FileInputStream stream = new FileInputStream(path);
        try {
            IStrategoTerm iStrategoTerm = this.parseFromStream(stream);
            return iStrategoTerm;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    public IStrategoTerm parseFromStream(InputStream inputStream) throws IOException, ParseError {
        try {
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            PushbackInputStream bis = new PushbackInputStream(inputStream);
            IStrategoTerm iStrategoTerm = this.parseFromStream(bis);
            return iStrategoTerm;
        }
        finally {
            inputStream.close();
        }
    }

    protected IStrategoTerm parseFromStream(PushbackInputStream bis) throws IOException, ParseError {
        this.parseSkip(bis);
        int ch = bis.read();
        switch (ch) {
            case 91: {
                return this.parseAnno(bis, this.parseList(bis));
            }
            case 40: {
                return this.parseAnno(bis, this.parseTuple(bis));
            }
            case 34: {
                return this.parseAnno(bis, this.parseString(bis));
            }
            case 60: {
                return this.parsePlaceholder(bis);
            }
            case 33: {
                throw new ParseError("Unsupported ATerm format: TAF");
            }
        }
        bis.unread(ch);
        if (Character.isLetter(ch)) {
            return this.parseAnno(bis, this.parseAppl(bis));
        }
        if (Character.isDigit(ch) || ch == 45) {
            return this.parseAnno(bis, this.parseNumber(bis));
        }
        throw new ParseError("Invalid term: '" + (char)ch + "'");
    }

    private IStrategoTerm parseAnno(PushbackInputStream bis, IStrategoTerm term) throws IOException, ParseError {
        this.parseSkip(bis);
        int ch = bis.read();
        if (ch == 123) {
            List<IStrategoTerm> annos = this.parseTermSequence(bis, '}');
            return this.factory.annotateTerm(term, this.factory.makeList(annos));
        }
        bis.unread(ch);
        return term;
    }

    private IStrategoTerm parseString(PushbackInputStream bis) throws IOException, ParseError {
        int ch = bis.read();
        if (ch == 34) {
            return this.factory.makeString("");
        }
        StringBuilder sb = this.sharedBuilder;
        sb.setLength(0);
        boolean escaped = false;
        do {
            escaped = false;
            if (ch == 92) {
                escaped = true;
                ch = bis.read();
            }
            if (escaped) {
                switch (ch) {
                    case 110: {
                        sb.append('\n');
                        break;
                    }
                    case 116: {
                        sb.append('\t');
                        break;
                    }
                    case 98: {
                        sb.append('\b');
                        break;
                    }
                    case 102: {
                        sb.append('\f');
                        break;
                    }
                    case 114: {
                        sb.append('\r');
                        break;
                    }
                    case 92: {
                        sb.append('\\');
                        break;
                    }
                    case 39: {
                        sb.append('\'');
                        break;
                    }
                    case 34: {
                        sb.append('\"');
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        throw new NotImplementedException();
                    }
                    default: {
                        sb.append("\\" + (char)ch);
                    }
                }
                ch = bis.read();
                continue;
            }
            if (ch == 34) continue;
            if (ch == -1) {
                throw new ParseError("Unterminated string: " + sb);
            }
            sb.append((char)ch);
            ch = bis.read();
        } while (escaped || ch != 34);
        return this.factory.makeString(sb.toString());
    }

    private IStrategoTerm parseAppl(PushbackInputStream bis) throws IOException, ParseError {
        StringBuilder sb = this.sharedBuilder;
        sb.setLength(0);
        int ch = bis.read();
        do {
            sb.append((char)ch);
        } while (Character.isLetterOrDigit(ch = bis.read()) || ch == 95 || ch == 45 || ch == 43 || ch == 42 || ch == 36);
        String constructor = sb.toString();
        bis.unread(ch);
        this.parseSkip(bis);
        ch = bis.read();
        if (ch == 40) {
            List<IStrategoTerm> l = this.parseTermSequence(bis, ')');
            IStrategoConstructor c = this.factory.makeConstructor(constructor, l.size());
            return this.factory.makeAppl(c, l.toArray(new IStrategoTerm[l.size()]));
        }
        bis.unread(ch);
        IStrategoConstructor c = this.factory.makeConstructor(constructor, 0);
        return this.factory.makeAppl(c, AbstractTermFactory.EMPTY);
    }

    private IStrategoTerm parsePlaceholder(PushbackInputStream bis) throws IOException, ParseError {
        IStrategoTerm template = this.parseFromStream(bis);
        this.parseSkip(bis);
        if (bis.read() != 62) {
            throw new ParseError("Expected: '>'");
        }
        return this.factory.makePlaceholder(template);
    }

    private IStrategoTerm parseTuple(PushbackInputStream bis) throws IOException, ParseError {
        return this.factory.makeTuple(this.parseTermSequence(bis, ')').toArray(AbstractTermFactory.EMPTY));
    }

    private List<IStrategoTerm> parseTermSequence(PushbackInputStream bis, char endChar) throws IOException, ParseError {
        List<IStrategoTerm> els = Collections.emptyList();
        this.parseSkip(bis);
        int ch = bis.read();
        if (ch == endChar) {
            return els;
        }
        els = new ArrayList<IStrategoTerm>();
        bis.unread(ch);
        do {
            els.add(this.parseFromStream(bis));
            this.parseSkip(bis);
        } while ((ch = bis.read()) == 44);
        if (ch != endChar) {
            bis.unread(ch);
            this.parseSkip(bis);
            ch = bis.read();
        }
        if (ch != endChar) {
            throw new ParseError("Sequence must end with '" + endChar + "', saw '" + (char)ch + "' '" + (char)bis.read() + "' after items " + els);
        }
        return els;
    }

    private IStrategoTerm parseList(PushbackInputStream bis) throws IOException, ParseError {
        return this.factory.makeList(this.parseTermSequence(bis, ']'));
    }

    private IStrategoTerm parseNumber(PushbackInputStream bis) throws IOException {
        String whole = this.parseDigitSequence(bis);
        int ch = bis.read();
        if (ch == 46) {
            String frac = this.parseDigitSequence(bis);
            ch = bis.read();
            if (ch == 101 || ch == 69) {
                String exp = this.parseDigitSequence(bis);
                double d = Double.parseDouble(String.valueOf(whole) + "." + frac + "e" + exp);
                return this.factory.makeReal(d);
            }
            bis.unread(ch);
            double d = Double.parseDouble(String.valueOf(whole) + "." + frac);
            return this.factory.makeReal(d);
        }
        bis.unread(ch);
        return this.factory.makeInt(Integer.parseInt(whole));
    }

    private String parseDigitSequence(PushbackInputStream bis) throws IOException {
        StringBuilder sb = this.sharedBuilder;
        sb.setLength(0);
        int ch = bis.read();
        do {
            sb.append((char)ch);
        } while (Character.isDigit(ch = bis.read()));
        bis.unread(ch);
        return sb.toString();
    }

    private void parseSkip(PushbackInputStream input) throws IOException {
        int b;
        block3: while (true) {
            b = input.read();
            switch (b) {
                case 9: 
                case 10: 
                case 32: {
                    continue block3;
                }
            }
            break;
        }
        input.unread(b);
    }

    public void unparseToFile(IStrategoTerm t, OutputStream ous) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(ous));
        this.unparseToFile(t, out);
        ((Writer)out).flush();
    }

    public void unparseToFile(IStrategoTerm t, Writer out) throws IOException {
        t.writeAsString(out, Integer.MAX_VALUE);
    }
}

