/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.io.binary;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import org.spoofax.NotImplementedException;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.Term;
import org.spoofax.terms.io.binary.BitStream;

class BAFReader {
    private static final int BAF_MAGIC = 2991;
    public static final int BAF_MAGIC_SIZE = 8;
    private static final int BAF_VERSION = 768;
    private static final int HEADER_BITS = 32;
    private static final ThreadLocal<ArrayList<ReadTermFrame>> readerStacks = new ThreadLocal();
    private BitStream reader;
    private int nrUniqueSymbols = -1;
    private SymEntry[] symbols;
    private ITermFactory factory;
    public static final boolean isDebugging = false;
    int level = 0;

    public BAFReader(ITermFactory factory, InputStream inputStream) {
        this.factory = factory;
        this.reader = inputStream instanceof FileInputStream ? new BitStream(inputStream) : new BitStream(inputStream);
    }

    public IStrategoTerm readFromBinaryFile(boolean headerAlreadyRead) throws ParseError, IOException {
        if (!headerAlreadyRead && !BAFReader.isBinaryATerm(this.reader)) {
            throw new ParseError("Input is not a BAF file");
        }
        int val = this.reader.readInt();
        if (val != 768) {
            throw new ParseError("Wrong BAF version (wanted 768, got " + val + "), giving up");
        }
        this.nrUniqueSymbols = this.reader.readInt();
        int nrUniqueTerms = this.reader.readInt();
        if (this.isDebugging()) {
            this.debug(this.nrUniqueSymbols + " unique symbols");
            this.debug(nrUniqueTerms + " unique terms");
        }
        this.symbols = new SymEntry[this.nrUniqueSymbols];
        this.readAllSymbols();
        int i = this.reader.readInt();
        return this.readTerm(this.symbols[i]);
    }

    private boolean isDebugging() {
        return false;
    }

    public static boolean isBinaryATerm(BufferedInputStream in) throws IOException {
        in.mark(10);
        if (BAFReader.isBinaryATerm(new BitStream(in))) {
            return true;
        }
        in.reset();
        return false;
    }

    private static boolean isBinaryATerm(BitStream in) throws IOException {
        try {
            int w0 = in.readInt();
            int w1 = in.readInt();
            if (w0 == 0 && w1 == 2991) {
                return true;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isBinaryATerm(PushbackInputStream in) throws IOException {
        byte[] header = new byte[8];
        in.read(header);
        in.unread(header);
        return BAFReader.isBinaryATerm(new BitStream(new ByteArrayInputStream(header)));
    }

    private void debug(String s) {
        System.err.println(s);
    }

    private IStrategoTerm readTerm(SymEntry e) throws ParseError, IOException {
        ArrayList<ReadTermFrame> stack = readerStacks.get();
        if (stack == null) {
            stack = new ArrayList();
            readerStacks.set(stack);
        }
        ReadTermFrame frame = new ReadTermFrame(e);
        boolean resumingFrame = false;
        block0: while (true) {
            SymEntry input = frame.input;
            IStrategoTerm[] outputArgs = frame.outputArgs;
            if (!resumingFrame) {
                ++this.level;
                if (this.isDebugging()) {
                    this.debug("readTerm()/" + this.level + " - " + input.fun + "[" + input.arity + "]");
                }
            }
            int i = frame.index;
            int arity = input.arity;
            while (i < arity) {
                int val;
                SymEntry argSym;
                if (!resumingFrame) {
                    int symVal = this.reader.readBits(input.symWidth[i]);
                    if (this.isDebugging()) {
                        this.debug(" [" + i + "] - " + symVal);
                        this.debug(" [" + i + "] - " + input.topSyms[i].length);
                    }
                    argSym = this.symbols[input.topSyms[i][symVal]];
                    val = this.reader.readBits(argSym.termWidth);
                    if (argSym.terms[val] == null) {
                        if (this.isDebugging()) {
                            this.debug(" [" + i + "] - recurse");
                        }
                        frame.index = i;
                        frame.argSym = argSym;
                        frame.val = val;
                        stack.add(frame);
                        frame = new ReadTermFrame(argSym);
                        continue block0;
                    }
                } else {
                    resumingFrame = false;
                    argSym = frame.argSym;
                    val = frame.val;
                }
                if (argSym.terms[val] == null) {
                    throw new ParseError("Malformed ATerm: Cannot be null");
                }
                outputArgs[i] = argSym.terms[val];
                ++i;
            }
            IStrategoTerm result = this.readTermTop(input, outputArgs);
            if (stack.isEmpty()) {
                return result;
            }
            frame = stack.remove(stack.size() - 1);
            frame.argSym.terms[frame.val] = result;
            resumingFrame = true;
        }
    }

    private IStrategoTerm readTermTop(SymEntry e, IStrategoTerm[] args) throws IOException {
        if (Term.isTermString(e.fun)) {
            --this.level;
            return e.fun;
        }
        IStrategoConstructor fun = (IStrategoConstructor)e.fun;
        String name = fun.getName();
        int LONGEST_BUILTIN_NAME = 6;
        if (name.length() <= 6) {
            if (name.equals("<int>")) {
                int val = this.reader.readBits(32);
                --this.level;
                return this.factory.makeInt(val);
            }
            if (name.equals("<real>")) {
                this.reader.flushBitsFromReader();
                String s = this.reader.readString();
                --this.level;
                return this.factory.makeReal(new Double(s));
            }
            if (name.equals("[_,_]")) {
                if (this.isDebugging()) {
                    this.debug("--");
                    int i = 0;
                    while (i < args.length) {
                        this.debug(" + " + args[i].getClass());
                        ++i;
                    }
                }
                --this.level;
                return this.factory.makeListCons(args[0], (IStrategoList)args[1]);
            }
            if (name.equals("[]")) {
                --this.level;
                return this.factory.makeList();
            }
            if (name.equals("{_}")) {
                return this.factory.annotateTerm(args[0], (IStrategoList)args[1]);
            }
            if (name.equals("<_>")) {
                throw new NotImplementedException("ATerm placeholders");
            }
        }
        if (this.isDebugging()) {
            this.debug(e.fun + " / " + args);
            int i = 0;
            while (i < args.length) {
                this.debug("" + args[i]);
                ++i;
            }
        }
        --this.level;
        return this.factory.makeAppl(fun, args);
    }

    private void readAllSymbols() throws IOException {
        int i = 0;
        while (i < this.nrUniqueSymbols) {
            int v;
            IStrategoTerm fun;
            SymEntry e;
            this.symbols[i] = e = new SymEntry();
            e.fun = fun = this.readSymbol();
            e.arity = fun instanceof IStrategoConstructor ? ((IStrategoConstructor)fun).getArity() : 0;
            int arity = e.arity;
            e.nrTerms = v = this.reader.readInt();
            e.termWidth = this.bitWidth(v);
            IStrategoTerm[] iStrategoTermArray = e.terms = v == 0 ? null : new IStrategoTerm[v];
            if (arity == 0) {
                e.nrTopSyms = null;
                e.symWidth = null;
                e.topSyms = null;
            } else {
                e.nrTopSyms = new int[arity];
                e.symWidth = new int[arity];
                e.topSyms = new int[arity][];
            }
            int j = 0;
            while (j < arity) {
                e.nrTopSyms[j] = v = this.reader.readInt();
                e.symWidth[j] = this.bitWidth(v);
                e.topSyms[j] = new int[v];
                int k = 0;
                while (k < e.nrTopSyms[j]) {
                    e.topSyms[j][k] = v = this.reader.readInt();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private int bitWidth(int v) {
        nrBits = 0;
        if (v > 1) ** GOTO lbl6
        return 0;
lbl-1000:
        // 1 sources

        {
            v >>= 1;
            ++nrBits;
lbl6:
            // 2 sources

            ** while (v != 0)
        }
lbl7:
        // 1 sources

        return nrBits;
    }

    private IStrategoTerm readSymbol() throws IOException {
        String s = this.reader.readString();
        int arity = this.reader.readInt();
        int quoted = this.reader.readInt();
        if (this.isDebugging()) {
            this.debug(String.valueOf(s) + " / " + arity + " / " + quoted);
        }
        if (quoted != 0) {
            if (arity == 0) {
                return this.factory.makeString(s);
            }
            return this.factory.makeConstructor("\"" + s + "\"", arity);
        }
        return this.factory.makeConstructor(s, arity);
    }

    static class ReadTermFrame {
        final SymEntry input;
        final IStrategoTerm[] outputArgs;
        int index;
        SymEntry argSym;
        int val;

        public ReadTermFrame(SymEntry input) {
            this.input = input;
            this.outputArgs = new IStrategoTerm[input.arity];
        }
    }

    class SymEntry {
        public IStrategoTerm fun;
        public int arity;
        public int nrTerms;
        public int termWidth;
        public IStrategoTerm[] terms;
        public int[] nrTopSyms;
        public int[] symWidth;
        public int[][] topSyms;

        SymEntry() {
        }
    }
}

