/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.SRTS_all;
import org.strategoxt.lang.StrategoErrorExit;
import org.strategoxt.lang.StrategoException;
import org.strategoxt.lang.StrategoExit;
import org.strategoxt.lang.Strategy;
import org.strategoxt.lang.Term;

public class StackSaver
extends SRTS_all {
    public static int MAX_DEPTH = 1000;
    private static int activeThreadDepth;
    private final Strategy strategy;

    public StackSaver(Strategy strategy) {
        this.strategy = strategy;
    }

    public static boolean isNeededFor(Context context) {
        int n = context.getTraceDepth(true);
        return n - activeThreadDepth > MAX_DEPTH;
    }

    public IStrategoTerm invoke(Context context, IStrategoTerm iStrategoTerm) {
        if (StackSaver.isNeededFor(context)) {
            return this.invokeStackFriendly(context, iStrategoTerm, Term.NO_STRATEGIES, Term.NO_TERMS);
        }
        return super.invoke(context, iStrategoTerm);
    }

    public IStrategoTerm invoke(Context context, IStrategoTerm iStrategoTerm, Strategy strategy) {
        if (StackSaver.isNeededFor(context)) {
            return this.invokeStackFriendly(context, iStrategoTerm, new Strategy[]{strategy}, Term.NO_TERMS);
        }
        return super.invoke(context, iStrategoTerm, strategy);
    }

    public IStrategoTerm invokeStackFriendly(final Context context, final IStrategoTerm iStrategoTerm, final Strategy[] strategyArray, final IStrategoTerm[] iStrategoTermArray) {
        int n = context.getTraceDepth(true);
        activeThreadDepth += n;
        FutureTask<IStrategoTerm> futureTask = new FutureTask<IStrategoTerm>(new Callable<IStrategoTerm>(){

            @Override
            public IStrategoTerm call() throws Exception {
                return StackSaver.this.strategy.invokeDynamic(context, iStrategoTerm, strategyArray, iStrategoTermArray);
            }
        });
        new Thread(futureTask).start();
        try {
            IStrategoTerm iStrategoTerm2 = futureTask.get();
            return iStrategoTerm2;
        }
        catch (ExecutionException executionException) {
            try {
                throw executionException.getCause();
            }
            catch (StrategoErrorExit strategoErrorExit) {
                throw new StrategoErrorExit(strategoErrorExit.getMessage(), strategoErrorExit.getTerm(), executionException.getCause());
            }
            catch (StrategoExit strategoExit) {
                throw new StrategoExit(strategoExit.getValue(), executionException.getCause());
            }
            catch (StrategoException strategoException) {
                throw new StrategoException(strategoException.getMessage(), executionException.getCause());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(executionException.getCause());
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            activeThreadDepth -= n;
        }
    }
}

