/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import org.spoofax.interpreter.core.StackTracer;

public class UncaughtExceptionHandler {
    private final WeakReference<StackTracer> stackTracer;
    private final ActualHandler handler = new ActualHandler();
    private static final ThreadLocal<Thread.UncaughtExceptionHandler> originalHandler = new ThreadLocal();
    private boolean enabled;
    private boolean dumpedError;

    public UncaughtExceptionHandler(StackTracer stackTracer) {
        this.stackTracer = new WeakReference<StackTracer>(stackTracer);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.enable();
        } else {
            this.disable();
        }
    }

    private void enable() {
        if (!this.enabled) {
            this.enabled = true;
            if (!(Thread.currentThread().getUncaughtExceptionHandler() instanceof UncaughtExceptionHandler)) {
                originalHandler.set(Thread.currentThread().getUncaughtExceptionHandler());
            }
            Thread.currentThread().setUncaughtExceptionHandler(this.handler);
            Runtime.getRuntime().addShutdownHook(this.handler);
        }
    }

    private void disable() {
        if (this.enabled) {
            this.enabled = false;
            try {
                Thread.currentThread().setUncaughtExceptionHandler(originalHandler.get());
                Runtime.getRuntime().removeShutdownHook(this.handler);
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    protected synchronized boolean dumpError(String string) {
        if (this.dumpedError) {
            return true;
        }
        StackTracer stackTracer = (StackTracer)this.stackTracer.get();
        if (stackTracer != null && stackTracer.getTraceDepth(true) > 0) {
            if (string != null) {
                System.err.println(string);
            }
            try {
                stackTracer.printStackTrace(true);
            }
            catch (RuntimeException runtimeException) {}
            this.dumpedError = true;
        } else {
            this.dumpedError = false;
        }
        return this.dumpedError;
    }

    private class ActualHandler
    extends Thread
    implements Thread.UncaughtExceptionHandler {
        private ActualHandler() {
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            if (throwable instanceof StackOverflowError && UncaughtExceptionHandler.this.dumpError("Fatal error at")) {
                if (this.isStackTuned()) {
                    System.err.println("Stack overflow.");
                } else {
                    System.err.println("Stack overflow (use java -ss4m to increase the stack size)");
                }
            } else {
                UncaughtExceptionHandler.this.dumpError("Fatal error at");
            }
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = (Thread.UncaughtExceptionHandler)originalHandler.get();
            if (uncaughtExceptionHandler != null) {
                uncaughtExceptionHandler.uncaughtException(thread, throwable);
            }
        }

        private boolean isStackTuned() {
            for (String string : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                if (!string.startsWith("-Xss") && !string.startsWith("-ss")) continue;
                return true;
            }
            return false;
        }

        public void run() {
            UncaughtExceptionHandler.this.dumpError("Aborted at");
        }
    }

    static class Finalizer {
        final WeakReference<UncaughtExceptionHandler> handler;

        public Finalizer(UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.handler = new WeakReference<UncaughtExceptionHandler>(uncaughtExceptionHandler);
        }

        protected void finalize() throws Throwable {
            UncaughtExceptionHandler uncaughtExceptionHandler = (UncaughtExceptionHandler)this.handler.get();
            if (uncaughtExceptionHandler != null) {
                uncaughtExceptionHandler.setEnabled(false);
            }
        }
    }
}

