/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.spoofax.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakValueHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private Map hash;
    private ReferenceQueue queue = new ReferenceQueue();

    @Override
    public Set entrySet() {
        this.processQueue();
        throw new NotImplementedException();
    }

    private void processQueue() {
        WeakValueRef weakValueRef;
        while ((weakValueRef = (WeakValueRef)this.queue.poll()) != null) {
            if (weakValueRef != (WeakValueRef)this.hash.get(weakValueRef.key)) continue;
            this.hash.remove(weakValueRef.key);
        }
    }

    public WeakValueHashMap(int n, float f) {
        this.hash = new HashMap(n, f);
    }

    public WeakValueHashMap(int n) {
        this.hash = new HashMap(n);
    }

    public WeakValueHashMap() {
        this.hash = new HashMap();
    }

    public WeakValueHashMap(Map map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    @Override
    public int size() {
        this.processQueue();
        return this.hash.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.hash.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        this.processQueue();
        return this.hash.containsKey(object);
    }

    @Override
    public V get(Object object) {
        this.processQueue();
        WeakReference weakReference = (WeakReference)this.hash.get(object);
        if (weakReference != null) {
            return (V)weakReference.get();
        }
        return null;
    }

    @Override
    public Object put(Object object, Object object2) {
        this.processQueue();
        WeakValueRef weakValueRef = this.hash.put(object, WeakValueRef.create(object, object2, this.queue));
        if (weakValueRef != null) {
            weakValueRef = ((WeakReference)weakValueRef).get();
        }
        return weakValueRef;
    }

    @Override
    public V remove(Object object) {
        this.processQueue();
        return (V)((WeakReference)this.hash.remove(object)).get();
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    private static class WeakValueRef
    extends WeakReference {
        public Object key;

        private WeakValueRef(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.key = object;
        }

        private static WeakValueRef create(Object object, Object object2, ReferenceQueue referenceQueue) {
            if (object2 == null) {
                return null;
            }
            return new WeakValueRef(object, object2, referenceQueue);
        }
    }
}

