/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.parallel.stratego_parallel;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.Strategy;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelAll;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelJob;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelJobAbortedException;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelJobExecutor;
import org.strategoxt.lang.parallel.stratego_parallel.PureOperatorSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelContext
extends Context {
    private final ParallelJob job;
    private final AtomicBoolean isAborted;
    private final boolean allowUnordered;
    private AtomicReference<String> lastSynchronousOperation;

    public ParallelContext(Context context, ParallelJob parallelJob, AtomicBoolean atomicBoolean, boolean bl) {
        super(context.getFactory(), context.getOperatorRegistryMap(), context.getOperatorRegistries(), true);
        this.job = parallelJob;
        this.isAborted = atomicBoolean;
        this.allowUnordered = bl;
    }

    void setLastSynchronousOperation(AtomicReference<String> atomicReference) {
        this.lastSynchronousOperation = atomicReference;
    }

    protected void finalize() throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStrategoTerm invokePrimitive(AbstractPrimitive abstractPrimitive, IStrategoTerm iStrategoTerm, Strategy[] strategyArray, IStrategoTerm[] iStrategoTermArray) {
        if (this.isAborted.get() && !this.job.isFocusJob()) {
            throw new ParallelJobAbortedException();
        }
        String string = abstractPrimitive.getName();
        if (this.job.isFocusJob()) {
            return super.invokePrimitive(abstractPrimitive, iStrategoTerm, strategyArray, iStrategoTermArray);
        }
        if (PureOperatorSet.isWhiteListed(string)) {
            return super.invokePrimitive(abstractPrimitive, iStrategoTerm, strategyArray, iStrategoTermArray);
        }
        if (this.allowUnordered) {
            ParallelJobExecutor parallelJobExecutor = ParallelAll.instance.getExecutor();
            synchronized (parallelJobExecutor) {
                return super.invokePrimitive(abstractPrimitive, iStrategoTerm, strategyArray, iStrategoTermArray);
            }
        }
        this.waitForFocus();
        return super.invokePrimitive(abstractPrimitive, iStrategoTerm, strategyArray, iStrategoTermArray);
    }

    public final ParallelJob getJob() {
        return this.job;
    }

    public void waitForFocus() {
        if (this.allowUnordered || this.job.isFocusJob()) {
            return;
        }
        ParallelJobExecutor parallelJobExecutor = ParallelAll.instance.getExecutor();
        parallelJobExecutor.asyncBeginSleep();
        try {
            try {
                this.job.waitForFocus();
                if (this.isAborted.get() && !this.job.isFocusJob()) {
                    throw new ParallelJobAbortedException();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        finally {
            parallelJobExecutor.asyncEndSleep();
        }
    }
}

