/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.DataValidatorFactory;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Properties;

public class ConsoleInstaller
extends InstallerBase {
    private AutomatedInstallData installdata = new AutomatedInstallData();
    private boolean result = false;
    private Properties properties;
    private PrintWriter printWriter;

    public ConsoleInstaller() throws Exception {
        this.loadInstallData(this.installdata);
        this.installdata.localeISO3 = "eng";
        InputStream inputStream = this.getClass().getResourceAsStream("/langpacks/" + this.installdata.localeISO3 + ".xml");
        this.installdata.langpack = new LocaleDatabase(inputStream);
        this.installdata.setVariable("ISO3_LANG", this.installdata.localeISO3);
        ResourceManager.create(this.installdata);
        this.loadConditions(this.installdata);
        this.loadInstallerRequirements();
        this.loadDynamicVariables();
        if (!this.checkInstallerRequirements(this.installdata)) {
            Debug.log("not all installerconditions are fulfilled.");
            return;
        }
        this.addCustomLangpack(this.installdata);
    }

    protected void iterateAndPerformAction(String string) throws Exception {
        if (!this.checkInstallerRequirements(this.installdata)) {
            Debug.log("not all installerconditions are fulfilled.");
            return;
        }
        Debug.log("[ Starting console installation ] " + string);
        try {
            this.result = true;
            Iterator<Panel> iterator = this.installdata.panelsOrder.iterator();
            this.installdata.curPanelNumber = -1;
            VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.installdata.getVariables());
            while (iterator.hasNext()) {
                Panel panel = iterator.next();
                ++this.installdata.curPanelNumber;
                String string2 = "com.izforge.izpack.panels.";
                if (panel.className.compareTo(".") > -1) {
                    string2 = "";
                }
                if (!OsConstraint.oneMatchesCurrentSystem(panel.osConstraints)) continue;
                String string3 = panel.className;
                String string4 = string2 + string3 + "ConsoleHelper";
                Class<?> clazz = null;
                Debug.log("ConsoleHelper:" + string4);
                try {
                    clazz = Class.forName(string4);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Debug.log("ClassNotFoundException-skip :" + string4);
                    continue;
                }
                PanelConsole panelConsole = null;
                if (clazz != null) {
                    try {
                        Debug.log("Instantiate :" + string4);
                        this.refreshDynamicVariables(variableSubstitutor, this.installdata);
                        panelConsole = (PanelConsole)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        Debug.log("ERROR: no default constructor for " + string4 + ", skipping...");
                        continue;
                    }
                }
                if (panelConsole == null) continue;
                try {
                    Debug.log("consoleHelperInstance." + string + ":" + string4 + " entered.");
                    boolean bl = true;
                    boolean bl2 = true;
                    String string5 = panel.getCondition();
                    if (string5 != null) {
                        bl2 = this.installdata.getRules().isConditionTrue(string5);
                    }
                    if (string.equals("doInstall") && bl2) {
                        do {
                            bl = panelConsole.runConsole(this.installdata);
                        } while (!this.validatePanel(panel));
                    } else if (string.equals("doGeneratePropertiesFile")) {
                        bl = panelConsole.runGeneratePropertiesFile(this.installdata, this.printWriter);
                    } else if (string.equals("doInstallFromPropertiesFile") && bl2) {
                        bl = panelConsole.runConsoleFromPropertiesFile(this.installdata, this.properties);
                    }
                    if (!bl) {
                        this.result = false;
                        return;
                    }
                    Debug.log("consoleHelperInstance." + string + ":" + string4 + " successfully done.");
                }
                catch (Exception exception) {
                    Debug.log("ERROR: console installation failed for panel " + string3);
                    exception.printStackTrace();
                    this.result = false;
                }
            }
            if (this.result) {
                System.out.println("[ Console installation done ]");
            } else {
                System.out.println("[ Console installation FAILED! ]");
            }
        }
        catch (Exception exception) {
            this.result = false;
            System.err.println(exception.toString());
            exception.printStackTrace();
            System.out.println("[ Console installation FAILED! ]");
        }
    }

    protected void doInstall() throws Exception {
        try {
            this.iterateAndPerformAction("doInstall");
        }
        catch (Exception exception) {
            try {
                throw exception;
            }
            catch (Throwable throwable) {
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                throw throwable;
            }
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    protected void doGeneratePropertiesFile(String string) throws Exception {
        try {
            this.printWriter = new PrintWriter(string);
            this.iterateAndPerformAction("doGeneratePropertiesFile");
            this.printWriter.flush();
            this.printWriter.close();
        }
        catch (Exception exception) {
            try {
                throw exception;
            }
            catch (Throwable throwable) {
                this.printWriter.close();
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                throw throwable;
            }
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    protected void doInstallFromPropertiesFile(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            this.properties = new Properties();
            this.properties.load(fileInputStream);
            this.iterateAndPerformAction("doInstallFromPropertiesFile");
        }
        catch (Exception exception) {
            try {
                throw exception;
            }
            catch (Throwable throwable) {
                fileInputStream.close();
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                throw throwable;
            }
        }
        fileInputStream.close();
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    private boolean validatePanel(Panel panel) throws InstallerException {
        DataValidator dataValidator;
        DataValidator.Status status;
        boolean bl = true;
        String string = panel.getValidator();
        if (string != null && (status = (dataValidator = DataValidatorFactory.createDataValidator(string)).validateData(this.installdata)) != DataValidator.Status.OK) {
            if (status == DataValidator.Status.WARNING && dataValidator.getDefaultAnswer()) {
                System.out.println("Configuration said, it's ok to go on, if validation is not successfull");
            }
            bl = false;
            System.out.println("Validation failed, please verify your input");
        }
        return bl;
    }
}

