/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.CGPoint;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBundle;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSColorSpace;
import org.eclipse.swt.internal.cocoa.NSComboBox;
import org.eclipse.swt.internal.cocoa.NSDate;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageView;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNotificationCenter;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSResponder;
import org.eclipse.swt.internal.cocoa.NSRunLoop;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSearchField;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSSlider;
import org.eclipse.swt.internal.cocoa.NSStepper;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSTimer;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.NSWorkspace;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTApplicationDelegate;
import org.eclipse.swt.internal.cocoa.SWTWindowDelegate;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    Event[] eventQueue;
    EventTable eventTable;
    EventTable filterTable;
    boolean disposing;
    int sendEventCount;
    int[] deadKeyState = new int[1];
    int currentKeyboardUCHRdata;
    boolean eventSourceDelaySet;
    Synchronizer synchronizer;
    Thread thread;
    boolean allowTimers;
    boolean runAsyncMessages;
    GCData[] contexts;
    Caret currentCaret;
    boolean sendEvent;
    Control currentControl;
    Control trackingControl;
    Control tooltipControl;
    Widget tooltipTarget;
    NSMutableArray isPainting;
    NSMutableArray needsDisplay;
    NSMutableArray needsDisplayInRect;
    NSDictionary markedAttributes;
    boolean smallFonts;
    NSFont buttonFont;
    NSFont popUpButtonFont;
    NSFont textFieldFont;
    NSFont secureTextFieldFont;
    NSFont searchFieldFont;
    NSFont comboBoxFont;
    NSFont sliderFont;
    NSFont scrollerFont;
    NSFont textViewFont;
    NSFont tableViewFont;
    NSFont outlineViewFont;
    NSFont datePickerFont;
    NSFont boxFont;
    NSFont tabViewFont;
    NSFont progressIndicatorFont;
    Shell[] modalShells;
    Menu menuBar;
    Menu[] menus;
    Menu[] popups;
    NSApplication application;
    int applicationClass;
    NSImage dockImage;
    boolean isEmbedded;
    static boolean launched = false;
    Control focusControl;
    Control currentFocusControl;
    int focusEvent;
    NSWindow screenWindow;
    NSWindow keyWindow;
    NSAutoreleasePool[] pools;
    int poolCount;
    int loopCount;
    int[] screenID = new int[32];
    NSPoint[] screenCascade = new NSPoint[32];
    int runLoopObserver;
    Callback observerCallback;
    boolean lockCursor = true;
    int oldCursorSetProc;
    Callback cursorSetCallback;
    static Callback windowCallback2;
    static Callback windowCallback3;
    static Callback windowCallback4;
    static Callback windowCallback5;
    static Callback windowCallback6;
    static Callback dialogCallback3;
    static Callback dialogCallback4;
    static Callback dialogCallback5;
    static Callback applicationCallback2;
    static Callback applicationCallback3;
    static Callback applicationCallback6;
    static Callback fieldEditorCallback3;
    static Callback fieldEditorCallback4;
    Runnable[] disposeList;
    Tray tray;
    TrayItem currentTrayItem;
    Menu trayItemMenu;
    Image errorImage;
    Image infoImage;
    Image warningImage;
    Cursor[] cursors = new Cursor[22];
    float[][] colors;
    float[] alternateSelectedControlTextColor;
    float[] selectedControlTextColor;
    float[] alternateSelectedControlColor;
    float[] secondarySelectedControlColor;
    static int[][] KeyTable;
    static String APP_NAME;
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final byte[] SWT_OBJECT;
    static final byte[] SWT_IMAGE;
    static final byte[] SWT_ROW;
    static final byte[] SWT_COLUMN;
    static Display Default;
    static Display[] Displays;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    Runnable[] timerList;
    NSTimer[] nsTimers;
    SWTWindowDelegate timerDelegate;
    static SWTApplicationDelegate applicationDelegate;
    boolean runSettings;
    SWTWindowDelegate settingsDelegate;
    static final int DEFAULT_BUTTON_INTERVAL = 30;
    Object data;
    String[] keys;
    Object[] values;
    Runnable hoverTimer = new Runnable(){

        public void run() {
            if (Display.this.currentControl != null && !Display.this.currentControl.isDisposed()) {
                Display.this.currentControl.sendMouseEvent(NSApplication.sharedApplication().currentEvent(), 32, Display.this.trackingControl != null && !Display.this.trackingControl.isDisposed());
            }
        }
    };
    Runnable caretTimer = new Runnable(){

        public void run() {
            if (Display.this.currentCaret != null) {
                if (Display.this.currentCaret == null || Display.this.currentCaret.isDisposed()) {
                    return;
                }
                if (Display.this.currentCaret.blinkCaret()) {
                    int blinkRate = Display.this.currentCaret.blinkRate;
                    if (blinkRate != 0) {
                        Display.this.timerExec(blinkRate, this);
                    }
                } else {
                    Display.this.currentCaret = null;
                }
            }
        }
    };
    Runnable defaultButtonTimer = new Runnable(){

        public void run() {
            Button defaultButton;
            if (Display.this.isDisposed()) {
                return;
            }
            Shell shell = Display.this.getActiveShell();
            if (shell != null && !shell.isDisposed() && (defaultButton = shell.defaultButton) != null && !defaultButton.isDisposed()) {
                NSView view = defaultButton.view;
                view.display();
            }
            if (Display.this.isDisposed()) {
                return;
            }
            if (Display.this.hasDefaultButton()) {
                Display.this.timerExec(30, this);
            }
        }
    };
    static /* synthetic */ Class class$0;

    static {
        KeyTable = new int[][]{{58, 65536}, {56, 131072}, {59, 262144}, {55, 0x400000}, {61, 65536}, {62, 262144}, {60, 131072}, {54, 0x400000}, {126, 0x1000001}, {125, 0x1000002}, {123, 0x1000003}, {124, 0x1000004}, {116, 0x1000005}, {121, 0x1000006}, {115, 0x1000007}, {119, 0x1000008}, {51, 8}, {36, 13}, {117, 127}, {53, 27}, {76, 10}, {48, 9}, {122, 0x100000A}, {120, 0x100000B}, {99, 0x100000C}, {118, 0x100000D}, {96, 0x100000E}, {97, 0x100000F}, {98, 0x1000010}, {100, 0x1000011}, {101, 0x1000012}, {109, 0x1000013}, {103, 0x1000014}, {111, 0x1000015}, {105, 0x1000016}, {107, 0x1000017}, {113, 0x1000018}, {67, 16777258}, {69, 16777259}, {76, 0x1000050}, {78, 16777261}, {65, 16777262}, {75, 16777263}, {82, 0x1000030}, {83, 0x1000031}, {84, 16777266}, {85, 0x1000033}, {86, 16777268}, {87, 16777269}, {88, 16777270}, {89, 16777271}, {91, 16777272}, {92, 16777273}, {81, 16777277}, {57, 16777298}, {71, 16777299}, {114, 0x1000051}};
        byte[] byArray = new byte[11];
        byArray[0] = 83;
        byArray[1] = 87;
        byArray[2] = 84;
        byArray[3] = 95;
        byArray[4] = 79;
        byArray[5] = 66;
        byArray[6] = 74;
        byArray[7] = 69;
        byArray[8] = 67;
        byArray[9] = 84;
        SWT_OBJECT = byArray;
        byte[] byArray2 = new byte[10];
        byArray2[0] = 83;
        byArray2[1] = 87;
        byArray2[2] = 84;
        byArray2[3] = 95;
        byArray2[4] = 73;
        byArray2[5] = 77;
        byArray2[6] = 65;
        byArray2[7] = 71;
        byArray2[8] = 69;
        SWT_IMAGE = byArray2;
        byte[] byArray3 = new byte[8];
        byArray3[0] = 83;
        byArray3[1] = 87;
        byArray3[2] = 84;
        byArray3[3] = 95;
        byArray3[4] = 82;
        byArray3[5] = 79;
        byArray3[6] = 87;
        SWT_ROW = byArray3;
        byte[] byArray4 = new byte[11];
        byArray4[0] = 83;
        byArray4[1] = 87;
        byArray4[2] = 84;
        byArray4[3] = 95;
        byArray4[4] = 67;
        byArray4[5] = 79;
        byArray4[6] = 76;
        byArray4[7] = 85;
        byArray4[8] = 77;
        byArray4[9] = 78;
        SWT_COLUMN = byArray4;
        Displays = new Display[4];
        DeviceFinder = new Runnable(){

            public void run() {
                Display device = Display.getCurrent();
                if (device == null) {
                    device = Display.getDefault();
                }
                Display.setDevice(device);
            }
        };
    }

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    static byte[] ascii(String name) {
        int length = name.length();
        char[] chars = new char[length];
        name.getChars(0, length, chars, 0);
        byte[] buffer = new byte[length + 1];
        int i = 0;
        while (i < length) {
            buffer[i] = (byte)chars[i];
            ++i;
        }
        return buffer;
    }

    static int translateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][0] == key) {
                return KeyTable[i][1];
            }
            ++i;
        }
        return 0;
    }

    static int untranslateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][1] == key) {
                return KeyTable[i][0];
            }
            ++i;
        }
        return 0;
    }

    void addContext(GCData context) {
        if (this.contexts == null) {
            this.contexts = new GCData[12];
        }
        int i = 0;
        while (i < this.contexts.length) {
            if (this.contexts[i] != null && this.contexts[i] == context) {
                this.contexts[i] = context;
                return;
            }
            ++i;
        }
        GCData[] newContexts = new GCData[this.contexts.length + 12];
        newContexts[this.contexts.length] = context;
        System.arraycopy(this.contexts, 0, newContexts, 0, this.contexts.length);
        this.contexts = newContexts;
    }

    public void addFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(eventType, listener);
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[12];
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == null) {
                this.menus[i] = menu;
                return;
            }
            ++i;
        }
        Menu[] newMenus = new Menu[this.menus.length + 12];
        newMenus[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, newMenus, 0, this.menus.length);
        this.menus = newMenus;
    }

    void addPool() {
        this.addPool((NSAutoreleasePool)new NSAutoreleasePool().alloc().init());
    }

    void addPool(NSAutoreleasePool pool) {
        if (this.pools == null) {
            this.pools = new NSAutoreleasePool[4];
        }
        if (this.poolCount == this.pools.length) {
            NSAutoreleasePool[] temp = new NSAutoreleasePool[this.poolCount + 4];
            System.arraycopy(this.pools, 0, temp, 0, this.poolCount);
            this.pools = temp;
        }
        if (this.poolCount == 0) {
            NSMutableDictionary dictionary = NSThread.currentThread().threadDictionary();
            dictionary.setObject(NSNumber.numberWithInteger(pool.id), NSString.stringWith("SWT_NSAutoreleasePool"));
        }
        this.pools[this.poolCount++] = pool;
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int length = this.popups.length;
        int i = 0;
        while (i < length) {
            if (this.popups[i] == menu) {
                return;
            }
            ++i;
        }
        int index = 0;
        while (index < length) {
            if (this.popups[index] == null) break;
            ++index;
        }
        if (index == length) {
            Menu[] newPopups = new Menu[length + 4];
            System.arraycopy(this.popups, 0, newPopups, 0, length);
            this.popups = newPopups;
        }
        this.popups[index] = menu;
    }

    void addWidget(NSObject view, Widget widget) {
        if (view == null) {
            return;
        }
        OS.object_setInstanceVariable(view.id, SWT_OBJECT, widget.jniRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            this.synchronizer.asyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void beep() {
        this.checkDevice();
        OS.NSBeep();
    }

    void cascadeWindow(NSWindow window, NSScreen screen) {
        NSDictionary dictionary = screen.deviceDescription();
        int screenNumber = new NSNumber(dictionary.objectForKey((id)NSString.stringWith((String)"NSScreenNumber")).id).intValue();
        int index = 0;
        while (this.screenID[index] != 0 && this.screenID[index] != screenNumber) {
            ++index;
        }
        this.screenID[index] = screenNumber;
        NSPoint cascade = this.screenCascade[index];
        if (cascade == null) {
            NSRect frame = screen.frame();
            cascade = new NSPoint();
            cascade.x = frame.x;
            cascade.y = frame.y + frame.height;
        }
        this.screenCascade[index] = window.cascadeTopLeftFromPoint(cascade);
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    void checkEnterExit(Control control, NSEvent nsEvent, boolean send) {
        if (control != this.currentControl) {
            if (this.currentControl != null && !this.currentControl.isDisposed()) {
                this.currentControl.sendMouseEvent(nsEvent, 7, send);
            }
            if (control != null && control.isDisposed()) {
                control = null;
            }
            this.currentControl = control;
            if (control != null) {
                control.sendMouseEvent(nsEvent, 6, send);
            }
            this.setCursor(control);
        }
        this.timerExec(control != null && !control.isDisposed() ? this.getToolTipTime() : -1, this.hoverTimer);
    }

    void checkFocus() {
        Control oldControl = this.currentFocusControl;
        Control newControl = this.getFocusControl();
        if (oldControl != newControl) {
            if (oldControl != null && !oldControl.isDisposed()) {
                oldControl.sendFocusEvent(16);
            }
            this.currentFocusControl = newControl;
            if (newControl != null && !newControl.isDisposed()) {
                newControl.sendFocusEvent(15);
            }
        }
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData data) {
        super(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean multiple) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                if (Displays[i] != null) {
                    if (!multiple) {
                        SWT.error(20, null, " [multiple displays]");
                    }
                    if (Display.Displays[i].thread == thread) {
                        SWT.error(22);
                    }
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static String convertToLf(String text) {
        char Cr = '\r';
        char Lf = '\n';
        int length = text.length();
        if (length == 0) {
            return text;
        }
        int i = text.indexOf(Lf, 0);
        if (i == -1 || i == 0) {
            return text;
        }
        if (text.charAt(i - 1) != Cr) {
            return text;
        }
        i = 0;
        StringBuffer result = new StringBuffer();
        while (i < length) {
            int j = text.indexOf(Cr, i);
            if (j == -1) {
                j = length;
            }
            String s = text.substring(i, j);
            result.append(s);
            i = j + 2;
            result.append(Lf);
        }
        return result.toString();
    }

    void clearModal(Shell shell) {
        if (this.modalShells == null) {
            return;
        }
        int index = 0;
        int length = this.modalShells.length;
        while (index < length) {
            if (this.modalShells[index] == shell) break;
            if (this.modalShells[index] == null) {
                return;
            }
            ++index;
        }
        if (index == length) {
            return;
        }
        System.arraycopy(this.modalShells, index + 1, this.modalShells, index, --length - index);
        this.modalShells[length] = null;
        if (index == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].updateModal();
            ++i;
        }
    }

    void clearPool() {
        if (this.sendEventCount == 0 && this.loopCount == this.poolCount - 1 && Callback.getEntryCount() == 0) {
            this.removePool();
            this.addPool();
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData data) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, false);
        this.createDisplay(data);
        Display.register(this);
        this.synchronizer = new Synchronizer(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData data) {
        if (OS.VERSION < 4176) {
            System.out.println("***WARNING: SWT requires MacOS X version 10.5 or greater");
            System.out.println("***WARNING: Detected: " + Integer.toHexString((OS.VERSION & 0xFF00) >> 8) + "." + Integer.toHexString((OS.VERSION & 0xF0) >> 4) + "." + Integer.toHexString(OS.VERSION & 0xF));
            this.error(20);
        }
        NSThread nsthread = NSThread.currentThread();
        NSMutableDictionary dictionary = nsthread.threadDictionary();
        NSString key = NSString.stringWith("SWT_NSAutoreleasePool");
        NSNumber id2 = new NSNumber(dictionary.objectForKey(key));
        this.addPool(new NSAutoreleasePool(id2.integerValue()));
        this.application = NSApplication.sharedApplication();
        if (!this.application.isRunning()) {
            String className;
            int cls;
            int[] psn = new int[2];
            if (OS.GetCurrentProcess(psn) == 0) {
                int pid = OS.getpid();
                int ptr = Display.getAppName().UTF8String();
                if (ptr != 0) {
                    OS.CPSSetProcessName(psn, ptr);
                }
                OS.TransformProcessType(psn, 1);
                OS.SetFrontProcess(psn);
                ptr = OS.getenv(Display.ascii("APP_ICON_" + pid));
                if (ptr != 0) {
                    NSString path = NSString.stringWithUTF8String(ptr);
                    NSImage image = (NSImage)new NSImage().alloc();
                    this.dockImage = image = image.initByReferencingFile(path);
                    this.application.setApplicationIconImage(image);
                }
            }
            if ((cls = OS.objc_lookUpClass(className = "SWTApplication")) == 0) {
                int proc6;
                int proc3;
                Class<?> clazz = this.getClass();
                applicationCallback2 = new Callback(clazz, "applicationProc", 2);
                int proc2 = applicationCallback2.getAddress();
                if (proc2 == 0) {
                    this.error(3);
                }
                if ((proc3 = (applicationCallback3 = new Callback(clazz, "applicationProc", 3)).getAddress()) == 0) {
                    this.error(3);
                }
                if ((proc6 = (applicationCallback6 = new Callback(clazz, "applicationProc", 6)).getAddress()) == 0) {
                    this.error(3);
                }
                cls = OS.objc_allocateClassPair(OS.class_NSApplication, className, 0);
                OS.class_addMethod(cls, OS.sel_sendEvent_, proc3, "@:@");
                OS.class_addMethod(cls, OS.sel_nextEventMatchingMask_untilDate_inMode_dequeue_, proc6, "@:i@@B");
                OS.class_addMethod(cls, OS.sel_isRunning, proc2, "@:");
                OS.class_addMethod(cls, OS.sel_finishLaunching, proc2, "@:");
                OS.objc_registerClassPair(cls);
            }
            this.applicationClass = OS.object_setClass(this.application.id, cls);
            className = "SWTApplicationDelegate";
            if (OS.objc_lookUpClass(className) == 0) {
                int appProc3 = applicationCallback3.getAddress();
                if (appProc3 == 0) {
                    this.error(3);
                }
                cls = OS.objc_allocateClassPair(OS.class_NSObject, className, 0);
                OS.class_addMethod(cls, OS.sel_applicationWillFinishLaunching_, appProc3, "@:@");
                OS.class_addMethod(cls, OS.sel_terminate_, appProc3, "@:@");
                OS.class_addMethod(cls, OS.sel_quitRequested_, appProc3, "@:@");
                OS.class_addMethod(cls, OS.sel_orderFrontStandardAboutPanel_, appProc3, "@:@");
                OS.class_addMethod(cls, OS.sel_hideOtherApplications_, appProc3, "@:@");
                OS.class_addMethod(cls, OS.sel_hide_, appProc3, "@:@");
                OS.class_addMethod(cls, OS.sel_unhideAllApplications_, appProc3, "@:@");
                OS.class_addMethod(cls, OS.sel_applicationDidBecomeActive_, appProc3, "@:@");
                OS.class_addMethod(cls, OS.sel_applicationDidResignActive_, appProc3, "@:@");
                OS.objc_registerClassPair(cls);
            }
            if (applicationDelegate == null) {
                applicationDelegate = (SWTApplicationDelegate)new SWTApplicationDelegate().alloc().init();
                this.application.setDelegate(applicationDelegate);
            }
        } else {
            this.isEmbedded = true;
        }
    }

    void createMainMenu() {
        NSMenuItem menuItem;
        NSString appName = Display.getAppName();
        NSString emptyStr = NSString.stringWith("");
        NSMenu mainMenu = (NSMenu)new NSMenu().alloc();
        mainMenu.initWithTitle(emptyStr);
        NSString format = NSString.stringWith("%@ %@");
        NSMenuItem appItem = menuItem = mainMenu.addItemWithTitle(emptyStr, 0, emptyStr);
        NSMenu appleMenu = (NSMenu)new NSMenu().alloc();
        appleMenu.initWithTitle(emptyStr);
        OS.objc_msgSend(this.application.id, OS.sel_registerName("setAppleMenu:"), appleMenu.id);
        NSString title = new NSString(OS.objc_msgSend(OS.class_NSString, OS.sel_stringWithFormat_, format.id, NSString.stringWith((String)SWT.getMessage((String)"About")).id, appName.id));
        menuItem = appleMenu.addItemWithTitle(title, OS.sel_orderFrontStandardAboutPanel_, emptyStr);
        menuItem.setTarget(applicationDelegate);
        appleMenu.addItem(NSMenuItem.separatorItem());
        title = NSString.stringWith(SWT.getMessage("Preferences..."));
        menuItem = appleMenu.addItemWithTitle(title, 0, NSString.stringWith(","));
        appleMenu.addItem(NSMenuItem.separatorItem());
        title = NSString.stringWith(SWT.getMessage("Services"));
        menuItem = appleMenu.addItemWithTitle(title, 0, emptyStr);
        NSMenu servicesMenu = (NSMenu)new NSMenu().alloc();
        servicesMenu.initWithTitle(emptyStr);
        appleMenu.setSubmenu(servicesMenu, menuItem);
        servicesMenu.release();
        this.application.setServicesMenu(servicesMenu);
        appleMenu.addItem(NSMenuItem.separatorItem());
        title = new NSString(OS.objc_msgSend(OS.class_NSString, OS.sel_stringWithFormat_, format.id, NSString.stringWith((String)SWT.getMessage((String)"Hide")).id, appName.id));
        menuItem = appleMenu.addItemWithTitle(title, OS.sel_hide_, NSString.stringWith("h"));
        menuItem.setTarget(applicationDelegate);
        title = NSString.stringWith(SWT.getMessage("Hide Others"));
        menuItem = appleMenu.addItemWithTitle(title, OS.sel_hideOtherApplications_, NSString.stringWith("h"));
        menuItem.setKeyEquivalentModifierMask(0x180000);
        menuItem.setTarget(applicationDelegate);
        title = NSString.stringWith(SWT.getMessage("Show All"));
        menuItem = appleMenu.addItemWithTitle(title, OS.sel_unhideAllApplications_, emptyStr);
        menuItem.setTarget(applicationDelegate);
        appleMenu.addItem(NSMenuItem.separatorItem());
        title = new NSString(OS.objc_msgSend(OS.class_NSString, OS.sel_stringWithFormat_, format.id, NSString.stringWith((String)SWT.getMessage((String)"Quit")).id, appName.id));
        menuItem = appleMenu.addItemWithTitle(title, OS.sel_quitRequested_, NSString.stringWith("q"));
        menuItem.setTarget(applicationDelegate);
        mainMenu.setSubmenu(appleMenu, appItem);
        appleMenu.release();
        this.application.setMainMenu(mainMenu);
        mainMenu.release();
    }

    int cursorSetProc(int id2, int sel) {
        Cursor cursor;
        if (this.lockCursor && this.currentControl != null && (cursor = this.currentControl.findCursor()) != null && cursor.handle.id != id2) {
            return 0;
        }
        OS.call(this.oldCursorSetProc, id2, sel);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                if (display == Displays[i]) {
                    Display.Displays[i] = null;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
        this.application = null;
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int eventType) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(eventType);
    }

    public Widget findWidget(int handle) {
        this.checkDevice();
        return this.getWidget(handle);
    }

    public Widget findWidget(int handle, int id2) {
        this.checkDevice();
        return this.getWidget(handle);
    }

    public Widget findWidget(Widget widget, int id2) {
        this.checkDevice();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                Display display = Displays[i];
                if (display != null && display.thread == thread) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return display;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public Shell getActiveShell() {
        Widget widget;
        NSWindow window;
        this.checkDevice();
        NSWindow nSWindow = window = this.keyWindow != null ? this.keyWindow : this.application.keyWindow();
        if (window != null && (widget = this.getWidget(window.contentView())) instanceof Shell) {
            return (Shell)widget;
        }
        return null;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        NSArray screens = NSScreen.screens();
        return this.getBounds(screens);
    }

    Rectangle getBounds(NSArray screens) {
        NSRect primaryFrame = new NSScreen(screens.objectAtIndex(0)).frame();
        float minX = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float minY = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        int count = screens.count();
        int i = 0;
        while (i < count) {
            NSScreen screen = new NSScreen(screens.objectAtIndex(i));
            NSRect frame = screen.frame();
            float x1 = frame.x;
            float x2 = frame.x + frame.width;
            float y1 = primaryFrame.height - frame.y;
            float y2 = primaryFrame.height - (frame.y + frame.height);
            if (x1 < minX) {
                minX = x1;
            }
            if (x2 < minX) {
                minX = x2;
            }
            if (x1 > maxX) {
                maxX = x1;
            }
            if (x2 > maxX) {
                maxX = x2;
            }
            if (y1 < minY) {
                minY = y1;
            }
            if (y2 < minY) {
                minY = y2;
            }
            if (y1 > maxY) {
                maxY = y1;
            }
            if (y2 > maxY) {
                maxY = y2;
            }
            ++i;
        }
        return new Rectangle((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getCaretBlinkTime() {
        return 560;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        NSArray screens = NSScreen.screens();
        if (screens.count() != 1) {
            return this.getBounds(screens);
        }
        NSScreen screen = new NSScreen(screens.objectAtIndex(0));
        NSRect frame = screen.frame();
        NSRect visibleFrame = screen.visibleFrame();
        float y = frame.height - (visibleFrame.y + visibleFrame.height);
        return new Rectangle((int)visibleFrame.x, (int)y, (int)visibleFrame.width, (int)visibleFrame.height);
    }

    public Control getCursorControl() {
        this.checkDevice();
        return this.findControl(false);
    }

    public Point getCursorLocation() {
        this.checkDevice();
        NSPoint location = NSEvent.mouseLocation();
        NSRect primaryFrame = this.getPrimaryFrame();
        return new Point((int)location.x, (int)(primaryFrame.height - location.y));
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.GetDblTime() * 1000 / 60;
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        NSWindow window = this.keyWindow != null ? this.keyWindow : this.application.keyWindow();
        return this._getFocusControl(window);
    }

    Control _getFocusControl(NSWindow window) {
        if (window != null) {
            NSResponder responder = window.firstResponder();
            if (responder != null && !responder.respondsToSelector(OS.sel_superview)) {
                return null;
            }
            NSView view = new NSView(responder.id);
            if (view != null) {
                do {
                    Widget widget;
                    if (!((widget = Display.GetWidget(view.id)) instanceof Control)) continue;
                    return (Control)widget;
                } while ((view = view.superview()) != null);
            }
        }
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public int getIconDepth() {
        return this.getDepth();
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32), new Point(64, 64), new Point(128, 128)};
    }

    int getLastEventTime() {
        NSEvent event = this.application.currentEvent();
        return event != null ? (int)(event.timestamp() * 1000.0) : 0;
    }

    Menu[] getMenus(Decorations shell) {
        if (this.menus == null) {
            return new Menu[0];
        }
        int count = 0;
        int i = 0;
        while (i < this.menus.length) {
            Menu menu = this.menus[i];
            if (menu != null && menu.parent == shell) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Menu[] result = new Menu[count];
        int i2 = 0;
        while (i2 < this.menus.length) {
            Menu menu = this.menus[i2];
            if (menu != null && menu.parent == shell) {
                result[index++] = menu;
            }
            ++i2;
        }
        return result;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        NSArray screens = NSScreen.screens();
        NSRect primaryFrame = new NSScreen(screens.objectAtIndex(0)).frame();
        int count = screens.count();
        Monitor[] monitors = new Monitor[count];
        int i = 0;
        while (i < count) {
            Monitor monitor = new Monitor();
            NSScreen screen = new NSScreen(screens.objectAtIndex(i));
            NSRect frame = screen.frame();
            monitor.x = (int)frame.x;
            monitor.y = (int)(primaryFrame.height - (frame.y + frame.height));
            monitor.width = (int)frame.width;
            monitor.height = (int)frame.height;
            NSRect visibleFrame = screen.visibleFrame();
            monitor.clientX = (int)visibleFrame.x;
            monitor.clientY = (int)(primaryFrame.height - (visibleFrame.y + visibleFrame.height));
            monitor.clientWidth = (int)visibleFrame.width;
            monitor.clientHeight = (int)visibleFrame.height;
            monitors[i] = monitor;
            ++i;
        }
        return monitors;
    }

    NSRect getPrimaryFrame() {
        NSArray screens = NSScreen.screens();
        return new NSScreen(screens.objectAtIndex(0)).frame();
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        Monitor monitor = new Monitor();
        NSArray screens = NSScreen.screens();
        NSScreen screen = new NSScreen(screens.objectAtIndex(0));
        NSRect frame = screen.frame();
        monitor.x = (int)frame.x;
        monitor.y = (int)(frame.height - (frame.y + frame.height));
        monitor.width = (int)frame.width;
        monitor.height = (int)frame.height;
        NSRect visibleFrame = screen.visibleFrame();
        monitor.clientX = (int)visibleFrame.x;
        monitor.clientY = (int)(frame.height - (visibleFrame.y + visibleFrame.height));
        monitor.clientWidth = (int)visibleFrame.width;
        monitor.clientHeight = (int)visibleFrame.height;
        return monitor;
    }

    public Shell[] getShells() {
        this.checkDevice();
        NSArray windows = this.application.windows();
        int index = 0;
        Shell[] result = new Shell[windows.count()];
        int i = 0;
        while (i < result.length) {
            NSWindow window = new NSWindow(windows.objectAtIndex(i));
            Widget widget = this.getWidget(window.contentView());
            if (widget instanceof Shell) {
                result[index++] = (Shell)widget;
            }
            ++i;
        }
        if (index == result.length) {
            return result;
        }
        Shell[] newResult = new Shell[index];
        System.arraycopy(result, 0, newResult, 0, index);
        return newResult;
    }

    static boolean getSheetEnabled() {
        return !"false".equals(System.getProperty("org.eclipse.swt.sheet"));
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    public Color getSystemColor(int id2) {
        this.checkDevice();
        Color color = this.getWidgetColor(id2);
        if (color != null) {
            return color;
        }
        return super.getSystemColor(id2);
    }

    Color getWidgetColor(int id2) {
        if (id2 >= 0 && id2 < this.colors.length && this.colors[id2] != null) {
            return Color.cocoa_new(this, this.colors[id2]);
        }
        return null;
    }

    float[] getWidgetColorRGB(int id2) {
        NSColor color = null;
        switch (id2) {
            case 28: {
                color = NSColor.blackColor();
                break;
            }
            case 29: {
                return new float[]{1.0f, 1.0f, 0.88235295f, 1.0f};
            }
            case 30: {
                color = NSColor.windowFrameTextColor();
                break;
            }
            case 31: {
                color = NSColor.alternateSelectedControlColor();
                break;
            }
            case 32: {
                color = NSColor.selectedControlColor();
                break;
            }
            case 33: {
                color = NSColor.disabledControlTextColor();
                break;
            }
            case 34: {
                color = NSColor.secondarySelectedControlColor();
                break;
            }
            case 35: {
                color = NSColor.secondarySelectedControlColor();
                break;
            }
            case 17: {
                color = NSColor.controlDarkShadowColor();
                break;
            }
            case 18: {
                color = NSColor.controlShadowColor();
                break;
            }
            case 19: {
                color = NSColor.controlHighlightColor();
                break;
            }
            case 20: {
                color = NSColor.controlLightHighlightColor();
                break;
            }
            case 22: {
                color = NSColor.controlHighlightColor();
                break;
            }
            case 21: {
                color = NSColor.controlTextColor();
                break;
            }
            case 23: {
                color = NSColor.blackColor();
                break;
            }
            case 24: {
                color = NSColor.textColor();
                break;
            }
            case 25: {
                color = NSColor.textBackgroundColor();
                break;
            }
            case 27: {
                color = NSColor.selectedTextColor();
                break;
            }
            case 26: {
                color = NSColor.selectedTextBackgroundColor();
            }
        }
        return this.getWidgetColorRGB(color);
    }

    float[] getWidgetColorRGB(NSColor color) {
        if (color == null) {
            return null;
        }
        if ((color = color.colorUsingColorSpace(NSColorSpace.deviceRGBColorSpace())) == null) {
            return null;
        }
        float[] components = new float[color.numberOfComponents()];
        color.getComponents(components);
        return new float[]{components[0], components[1], components[2], components[3]};
    }

    public Cursor getSystemCursor(int id2) {
        this.checkDevice();
        if (id2 < 0 || id2 >= this.cursors.length) {
            return null;
        }
        if (this.cursors[id2] == null) {
            this.cursors[id2] = new Cursor(this, id2);
        }
        return this.cursors[id2];
    }

    public Image getSystemImage(int id2) {
        this.checkDevice();
        switch (id2) {
            case 1: {
                if (this.errorImage != null) {
                    return this.errorImage;
                }
                NSImage nsImage = NSWorkspace.sharedWorkspace().iconForFileType(new NSString(OS.NSFileTypeForHFSTypeCode(1937010544)));
                if (nsImage == null) {
                    return null;
                }
                nsImage.retain();
                this.errorImage = Image.cocoa_new(this, 1, nsImage);
                return this.errorImage;
            }
            case 2: 
            case 4: 
            case 16: {
                if (this.infoImage != null) {
                    return this.infoImage;
                }
                NSImage nsImage = NSWorkspace.sharedWorkspace().iconForFileType(new NSString(OS.NSFileTypeForHFSTypeCode(1852798053)));
                if (nsImage == null) {
                    return null;
                }
                nsImage.retain();
                this.infoImage = Image.cocoa_new(this, 1, nsImage);
                return this.infoImage;
            }
            case 8: {
                if (this.warningImage != null) {
                    return this.warningImage;
                }
                NSImage nsImage = NSWorkspace.sharedWorkspace().iconForFileType(new NSString(OS.NSFileTypeForHFSTypeCode(1667331444)));
                if (nsImage == null) {
                    return null;
                }
                nsImage.retain();
                this.warningImage = Image.cocoa_new(this, 1, nsImage);
                return this.warningImage;
            }
        }
        return null;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    int getToolTipTime() {
        this.checkDevice();
        return 560;
    }

    Widget getWidget(int id2) {
        return Display.GetWidget(id2);
    }

    static Widget GetWidget(int id2) {
        if (id2 == 0) {
            return null;
        }
        int[] jniRef = new int[1];
        OS.object_getInstanceVariable(id2, SWT_OBJECT, jniRef);
        if (jniRef[0] == 0) {
            return null;
        }
        return (Widget)OS.JNIGetObject(jniRef[0]);
    }

    Widget getWidget(NSView view) {
        if (view == null) {
            return null;
        }
        return this.getWidget(view.id);
    }

    boolean hasDefaultButton() {
        NSArray windows = this.application.windows();
        int count = windows.count();
        int i = 0;
        while (i < count) {
            NSWindow window = new NSWindow(windows.objectAtIndex(i));
            if (window.defaultButtonCell() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void init() {
        int method;
        super.init();
        this.initClasses();
        this.initColors();
        this.initFonts();
        if (!this.isEmbedded && !launched) {
            this.application.finishLaunching();
            launched = true;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    NSApplication.sharedApplication().terminate(null);
                }
            });
        }
        this.observerCallback = new Callback(this, "observerProc", 3);
        int observerProc = this.observerCallback.getAddress();
        if (observerProc == 0) {
            this.error(3);
        }
        int activities = 32;
        this.runLoopObserver = OS.CFRunLoopObserverCreate(0, activities, true, 0, observerProc, 0);
        if (this.runLoopObserver == 0) {
            this.error(2);
        }
        OS.CFRunLoopAddObserver(OS.CFRunLoopGetCurrent(), this.runLoopObserver, OS.kCFRunLoopCommonModes());
        this.cursorSetCallback = new Callback(this, "cursorSetProc", 2);
        int cursorSetProc = this.cursorSetCallback.getAddress();
        if (cursorSetProc == 0) {
            this.error(3);
        }
        if ((method = OS.class_getInstanceMethod(OS.class_NSCursor, OS.sel_set)) != 0) {
            this.oldCursorSetProc = OS.method_setImplementation(method, cursorSetProc);
        }
        this.timerDelegate = (SWTWindowDelegate)new SWTWindowDelegate().alloc().init();
        this.settingsDelegate = (SWTWindowDelegate)new SWTWindowDelegate().alloc().init();
        NSNotificationCenter defaultCenter = NSNotificationCenter.defaultCenter();
        defaultCenter.addObserver(this.settingsDelegate, OS.sel_systemSettingsChanged_, OS.NSSystemColorsDidChangeNotification, null);
        defaultCenter.addObserver(this.settingsDelegate, OS.sel_systemSettingsChanged_, OS.NSApplicationDidChangeScreenParametersNotification, null);
        NSTextView textView = (NSTextView)new NSTextView().alloc();
        textView.init();
        this.markedAttributes = textView.markedTextAttributes();
        this.markedAttributes.retain();
        textView.release();
        this.isPainting = (NSMutableArray)new NSMutableArray().alloc();
        this.isPainting = this.isPainting.initWithCapacity(12);
    }

    void addEventMethods(int cls, int proc2, int proc3, int drawRectProc, int hitTestProc, int needsDisplayInRectProc) {
        if (proc3 != 0) {
            OS.class_addMethod(cls, OS.sel_mouseDown_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_mouseUp_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_scrollWheel_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_rightMouseDown_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_rightMouseUp_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_rightMouseDragged_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_otherMouseDown_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_otherMouseUp_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_otherMouseDragged_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_mouseDragged_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_mouseMoved_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_mouseEntered_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_mouseExited_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_menuForEvent_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_keyDown_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_keyUp_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_flagsChanged_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_cursorUpdate_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_setNeedsDisplay_, proc3, "@:B");
            OS.class_addMethod(cls, OS.sel_shouldDelayWindowOrderingForEvent_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_acceptsFirstMouse_, proc3, "@:@");
        }
        if (proc2 != 0) {
            OS.class_addMethod(cls, OS.sel_resignFirstResponder, proc2, "@:");
            OS.class_addMethod(cls, OS.sel_becomeFirstResponder, proc2, "@:");
            OS.class_addMethod(cls, OS.sel_resetCursorRects, proc2, "@:");
            OS.class_addMethod(cls, OS.sel_updateTrackingAreas, proc2, "@:");
        }
        if (needsDisplayInRectProc != 0) {
            OS.class_addMethod(cls, OS.sel_setNeedsDisplayInRect_, needsDisplayInRectProc, "@:{NSRect}");
        }
        if (drawRectProc != 0) {
            OS.class_addMethod(cls, OS.sel_drawRect_, drawRectProc, "@:{NSRect}");
        }
        if (hitTestProc != 0) {
            OS.class_addMethod(cls, OS.sel_hitTest_, hitTestProc, "@:{NSPoint}");
        }
    }

    void addFrameMethods(int cls, int setFrameOriginProc, int setFrameSizeProc) {
        OS.class_addMethod(cls, OS.sel_setFrameOrigin_, setFrameOriginProc, "@:{NSPoint}");
        OS.class_addMethod(cls, OS.sel_setFrameSize_, setFrameSizeProc, "@:{NSSize}");
    }

    void addAccessibilityMethods(int cls, int proc2, int proc3, int proc4, int accessibilityHitTestProc) {
        OS.class_addMethod(cls, OS.sel_accessibilityActionNames, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_accessibilityAttributeNames, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_accessibilityParameterizedAttributeNames, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_accessibilityFocusedUIElement, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_accessibilityIsIgnored, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_accessibilityAttributeValue_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_accessibilityHitTest_, accessibilityHitTestProc, "@:{NSPoint}");
        OS.class_addMethod(cls, OS.sel_accessibilityAttributeValue_forParameter_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_accessibilityPerformAction_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_accessibilityActionDescription_, proc3, "@:@");
    }

    int registerCellSubclass(int cellClass, int size, int align, byte[] types) {
        String cellClassName = OS.class_getName(cellClass);
        int cls = OS.objc_allocateClassPair(cellClass, "SWTAccessible" + cellClassName, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.objc_registerClassPair(cls);
        return cls;
    }

    void initClasses() {
        int shouldChangeTextInRange_replacementString_Proc;
        int fieldEditorProc4;
        int fieldEditorProc3;
        int proc6;
        int proc5;
        int proc4;
        int proc2;
        int proc3;
        int dialogProc5;
        int dialogProc4;
        if (OS.objc_lookUpClass("SWTView") != 0) {
            return;
        }
        Class<?> clazz = this.getClass();
        dialogCallback3 = new Callback(clazz, "dialogProc", 3);
        int dialogProc3 = dialogCallback3.getAddress();
        if (dialogProc3 == 0) {
            this.error(3);
        }
        if ((dialogProc4 = (dialogCallback4 = new Callback(clazz, "dialogProc", 4)).getAddress()) == 0) {
            this.error(3);
        }
        if ((dialogProc5 = (dialogCallback5 = new Callback(clazz, "dialogProc", 5)).getAddress()) == 0) {
            this.error(3);
        }
        if ((proc3 = (windowCallback3 = new Callback(clazz, "windowProc", 3)).getAddress()) == 0) {
            this.error(3);
        }
        if ((proc2 = (windowCallback2 = new Callback(clazz, "windowProc", 2)).getAddress()) == 0) {
            this.error(3);
        }
        if ((proc4 = (windowCallback4 = new Callback(clazz, "windowProc", 4)).getAddress()) == 0) {
            this.error(3);
        }
        if ((proc5 = (windowCallback5 = new Callback(clazz, "windowProc", 5)).getAddress()) == 0) {
            this.error(3);
        }
        if ((proc6 = (windowCallback6 = new Callback(clazz, "windowProc", 6)).getAddress()) == 0) {
            this.error(3);
        }
        if ((fieldEditorProc3 = (fieldEditorCallback3 = new Callback(clazz, "fieldEditorProc", 3)).getAddress()) == 0) {
            this.error(3);
        }
        if ((fieldEditorProc4 = (fieldEditorCallback4 = new Callback(clazz, "fieldEditorProc", 4)).getAddress()) == 0) {
            this.error(3);
        }
        int isFlippedProc = OS.isFlipped_CALLBACK();
        int drawRectProc = OS.CALLBACK_drawRect_(proc3);
        int drawInteriorWithFrameInViewProc = OS.CALLBACK_drawInteriorWithFrame_inView_(proc4);
        int drawWithExpansionFrameProc = OS.CALLBACK_drawWithExpansionFrame_inView_(proc4);
        int imageRectForBoundsProc = OS.CALLBACK_imageRectForBounds_(proc3);
        int titleRectForBoundsProc = OS.CALLBACK_titleRectForBounds_(proc3);
        int hitTestForEvent_inRect_ofViewProc = OS.CALLBACK_hitTestForEvent_inRect_ofView_(proc5);
        int cellSizeProc = OS.CALLBACK_cellSize(proc2);
        int drawImageWithFrameInViewProc = OS.CALLBACK_drawImage_withFrame_inView_(proc5);
        int setFrameOriginProc = OS.CALLBACK_setFrameOrigin_(proc3);
        int setFrameSizeProc = OS.CALLBACK_setFrameSize_(proc3);
        int hitTestProc = OS.CALLBACK_hitTest_(proc3);
        int markedRangeProc = OS.CALLBACK_markedRange(proc2);
        int selectedRangeProc = OS.CALLBACK_selectedRange(proc2);
        int highlightSelectionInClipRectProc = OS.CALLBACK_highlightSelectionInClipRect_(proc3);
        int setMarkedText_selectedRangeProc = OS.CALLBACK_setMarkedText_selectedRange_(proc4);
        int attributedSubstringFromRangeProc = OS.CALLBACK_attributedSubstringFromRange_(proc3);
        int characterIndexForPointProc = OS.CALLBACK_characterIndexForPoint_(proc3);
        int firstRectForCharacterRangeProc = OS.CALLBACK_firstRectForCharacterRange_(proc3);
        int textWillChangeSelectionProc = OS.CALLBACK_textView_willChangeSelectionFromCharacterRange_toCharacterRange_(proc5);
        int accessibilityHitTestProc = OS.CALLBACK_accessibilityHitTest_(proc3);
        int shouldChangeTextInRange_replacementString_fieldEditorProc = shouldChangeTextInRange_replacementString_Proc = OS.CALLBACK_shouldChangeTextInRange_replacementString_(fieldEditorProc4);
        int view_stringForToolTip_point_userDataProc = OS.CALLBACK_view_stringForToolTip_point_userData_(proc6);
        int canDragRowsWithIndexes_atPoint_Proc = OS.CALLBACK_canDragRowsWithIndexes_atPoint_(proc4);
        int setNeedsDisplayInRectProc = OS.CALLBACK_setNeedsDisplayInRect_(proc3);
        int expansionFrameWithFrameProc = OS.CALLBACK_expansionFrameWithFrame_inView_(proc4);
        byte[] byArray = new byte[2];
        byArray[0] = 42;
        byte[] types = byArray;
        int size = C.PTR_SIZEOF;
        int align = C.PTR_SIZEOF == 4 ? 2 : 3;
        String className = "SWTBox";
        int cls = OS.objc_allocateClassPair(OS.class_NSBox, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTButton";
        cls = OS.objc_allocateClassPair(OS.class_NSButton, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendSelection, proc2, "@:");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        OS.objc_registerClassPair(cls);
        cls = this.registerCellSubclass(NSButton.cellClass(), size, align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.class_addMethod(cls, OS.sel_nextState, proc2, "@:");
        NSButton.setCellClass(cls);
        className = "SWTButtonCell";
        cls = OS.objc_allocateClassPair(OS.class_NSButtonCell, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.class_addMethod(cls, OS.sel_drawImage_withFrame_inView_, drawImageWithFrameInViewProc, "@:@{NSFrame}@");
        OS.class_addMethod(cls, OS.sel_cellSize, cellSizeProc, "@:");
        OS.class_addMethod(cls, OS.sel_drawInteriorWithFrame_inView_, drawInteriorWithFrameInViewProc, "@:{NSRect}@");
        OS.class_addMethod(cls, OS.sel_titleRectForBounds_, titleRectForBoundsProc, "@:{NSRect}");
        OS.objc_registerClassPair(cls);
        className = "SWTCanvasView";
        cls = OS.objc_allocateClassPair(OS.class_NSView, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addProtocol(cls, OS.objc_getProtocol("NSTextInput"));
        OS.class_addMethod(cls, OS.sel_hasMarkedText, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_markedRange, markedRangeProc, "@:");
        OS.class_addMethod(cls, OS.sel_selectedRange, selectedRangeProc, "@:");
        OS.class_addMethod(cls, OS.sel_setMarkedText_selectedRange_, setMarkedText_selectedRangeProc, "@:@{NSRange}");
        OS.class_addMethod(cls, OS.sel_unmarkText, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_validAttributesForMarkedText, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_attributedSubstringFromRange_, attributedSubstringFromRangeProc, "@:{NSRange}");
        OS.class_addMethod(cls, OS.sel_insertText_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_characterIndexForPoint_, characterIndexForPointProc, "@:{NSPoint}");
        OS.class_addMethod(cls, OS.sel_firstRectForCharacterRange_, firstRectForCharacterRangeProc, "@:{NSRange}");
        OS.class_addMethod(cls, OS.sel_doCommandBySelector_, proc3, "@::");
        OS.class_addMethod(cls, OS.sel_canBecomeKeyView, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_isFlipped, isFlippedProc, "@:");
        OS.class_addMethod(cls, OS.sel_acceptsFirstResponder, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_isOpaque, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_updateOpenGLContext_, proc3, "@:@");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTComboBox";
        cls = OS.objc_allocateClassPair(OS.class_NSComboBox, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendSelection, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_textDidChange_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textViewDidChangeSelection_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_, textWillChangeSelectionProc, "@:@{NSRange}{NSRange}");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        cls = this.registerCellSubclass(NSComboBox.cellClass(), size, align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        NSComboBox.setCellClass(cls);
        className = "SWTDatePicker";
        cls = OS.objc_allocateClassPair(OS.class_NSDatePicker, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_isFlipped, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_sendSelection, proc2, "@:");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTEditorView";
        cls = OS.objc_allocateClassPair(OS.class_NSTextView, className, 0);
        this.addEventMethods(cls, 0, fieldEditorProc3, 0, 0, 0);
        OS.class_addMethod(cls, OS.sel_insertText_, fieldEditorProc3, "@:@");
        OS.class_addMethod(cls, OS.sel_doCommandBySelector_, fieldEditorProc3, "@::");
        OS.class_addMethod(cls, OS.sel_shouldChangeTextInRange_replacementString_, shouldChangeTextInRange_replacementString_fieldEditorProc, "@:{NSRange}@");
        OS.objc_registerClassPair(cls);
        className = "SWTImageView";
        cls = OS.objc_allocateClassPair(OS.class_NSImageView, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_isFlipped, isFlippedProc, "@:");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        cls = this.registerCellSubclass(NSImageView.cellClass(), size, align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        NSImageView.setCellClass(cls);
        className = "SWTImageTextCell";
        cls = OS.objc_allocateClassPair(OS.class_NSTextFieldCell, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addIvar(cls, SWT_IMAGE, size, (byte)align, types);
        OS.class_addIvar(cls, SWT_ROW, size, (byte)align, types);
        OS.class_addIvar(cls, SWT_COLUMN, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_drawInteriorWithFrame_inView_, drawInteriorWithFrameInViewProc, "@:{NSRect}@");
        OS.class_addMethod(cls, OS.sel_drawWithExpansionFrame_inView_, drawWithExpansionFrameProc, "@:{NSRect}@");
        OS.class_addMethod(cls, OS.sel_imageRectForBounds_, imageRectForBoundsProc, "@:{NSRect}");
        OS.class_addMethod(cls, OS.sel_titleRectForBounds_, titleRectForBoundsProc, "@:{NSRect}");
        OS.class_addMethod(cls, OS.sel_hitTestForEvent_inRect_ofView_, hitTestForEvent_inRect_ofViewProc, "@:@{NSRect}@");
        OS.class_addMethod(cls, OS.sel_cellSize, cellSizeProc, "@:");
        OS.class_addMethod(cls, OS.sel_image, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_setImage_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_expansionFrameWithFrame_inView_, expansionFrameWithFrameProc, "@:{NSRect}@");
        OS.objc_registerClassPair(cls);
        className = "SWTMenu";
        cls = OS.objc_allocateClassPair(OS.class_NSMenu, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_menuWillOpen_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_menuDidClose_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_menu_willHighlightItem_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_menuNeedsUpdate_, proc3, "@:@");
        OS.objc_registerClassPair(cls);
        className = "SWTMenuItem";
        cls = OS.objc_allocateClassPair(OS.class_NSMenuItem, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendSelection, proc2, "@:");
        OS.objc_registerClassPair(cls);
        className = "SWTOutlineView";
        cls = OS.objc_allocateClassPair(OS.class_NSOutlineView, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_highlightSelectionInClipRect_, highlightSelectionInClipRectProc, "@:{NSRect}");
        OS.class_addMethod(cls, OS.sel_sendDoubleSelection, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_outlineViewSelectionDidChange_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_outlineView_child_ofItem_, proc5, "@:@i@");
        OS.class_addMethod(cls, OS.sel_outlineView_isItemExpandable_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_outlineView_numberOfChildrenOfItem_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_outlineView_objectValueForTableColumn_byItem_, proc5, "@:@@@");
        OS.class_addMethod(cls, OS.sel_outlineView_willDisplayCell_forTableColumn_item_, proc6, "@:@@@@");
        OS.class_addMethod(cls, OS.sel_outlineView_setObjectValue_forTableColumn_byItem_, proc6, "@:@@@@");
        OS.class_addMethod(cls, OS.sel_outlineViewColumnDidMove_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_outlineViewColumnDidResize_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_outlineView_didClickTableColumn_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_canDragRowsWithIndexes_atPoint_, canDragRowsWithIndexes_atPoint_Proc, "@:@{NSPoint=ff}");
        OS.class_addMethod(cls, OS.sel_outlineView_writeItems_toPasteboard_, proc5, "@:@@@");
        OS.class_addMethod(cls, OS.sel_expandItem_expandChildren_, proc4, "@:@Z");
        OS.class_addMethod(cls, OS.sel_collapseItem_collapseChildren_, proc4, "@:@Z");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTPanelDelegate";
        cls = OS.objc_allocateClassPair(OS.class_NSObject, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_windowWillClose_, dialogProc3, "@:@");
        OS.class_addMethod(cls, OS.sel_changeColor_, dialogProc3, "@:@");
        OS.class_addMethod(cls, OS.sel_changeFont_, dialogProc3, "@:@");
        OS.class_addMethod(cls, OS.sel_sendSelection_, dialogProc3, "@:@");
        OS.class_addMethod(cls, OS.sel_panel_shouldShowFilename_, dialogProc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_panelDidEnd_returnCode_contextInfo_, dialogProc5, "@:@i@");
        OS.objc_registerClassPair(cls);
        className = "SWTPopUpButton";
        cls = OS.objc_allocateClassPair(OS.class_NSPopUpButton, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendSelection, proc2, "@:");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        cls = this.registerCellSubclass(NSPopUpButton.cellClass(), size, align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        NSPopUpButton.setCellClass(cls);
        className = "SWTProgressIndicator";
        cls = OS.objc_allocateClassPair(OS.class_NSProgressIndicator, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_viewDidMoveToWindow, proc2, "@:");
        OS.class_addMethod(cls, OS.sel__drawThemeProgressArea_, proc3, "@:c");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTScroller";
        cls = OS.objc_allocateClassPair(OS.class_NSScroller, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendSelection, proc2, "@:");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTScrollView";
        cls = OS.objc_allocateClassPair(OS.class_NSScrollView, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendVerticalSelection, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_sendHorizontalSelection, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_pageDown_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_pageUp_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_reflectScrolledClipView_, proc3, "@:@");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTSearchField";
        cls = OS.objc_allocateClassPair(OS.class_NSSearchField, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.class_addMethod(cls, OS.sel_textDidChange_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textViewDidChangeSelection_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_, textWillChangeSelectionProc, "@:@{NSRange}{NSRange}");
        OS.class_addMethod(cls, OS.sel_sendSearchSelection, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_sendCancelSelection, proc2, "@:");
        OS.objc_registerClassPair(cls);
        cls = this.registerCellSubclass(NSSearchField.cellClass(), size, align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        NSSearchField.setCellClass(cls);
        className = "SWTSecureTextField";
        cls = OS.objc_allocateClassPair(OS.class_NSSecureTextField, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.class_addMethod(cls, OS.sel_textDidChange_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textViewDidChangeSelection_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_, textWillChangeSelectionProc, "@:@{NSRange}{NSRange}");
        OS.objc_registerClassPair(cls);
        className = "SWTSlider";
        cls = OS.objc_allocateClassPair(OS.class_NSSlider, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendSelection, proc2, "@:");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        cls = this.registerCellSubclass(NSSlider.cellClass(), size, align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        NSSlider.setCellClass(cls);
        className = "SWTStepper";
        cls = OS.objc_allocateClassPair(OS.class_NSStepper, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendSelection, proc2, "@:");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        cls = this.registerCellSubclass(NSStepper.cellClass(), size, align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        NSStepper.setCellClass(cls);
        className = "SWTTableHeaderCell";
        cls = OS.objc_allocateClassPair(OS.class_NSTableHeaderCell, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_drawInteriorWithFrame_inView_, drawInteriorWithFrameInViewProc, "@:{NSRect}@");
        OS.objc_registerClassPair(cls);
        className = "SWTTableHeaderView";
        cls = OS.objc_allocateClassPair(OS.class_NSTableHeaderView, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_mouseDown_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_resetCursorRects, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_updateTrackingAreas, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_menuForEvent_, proc3, "@:@");
        OS.objc_registerClassPair(cls);
        className = "SWTTableView";
        cls = OS.objc_allocateClassPair(OS.class_NSTableView, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_highlightSelectionInClipRect_, highlightSelectionInClipRectProc, "@:{NSRect}");
        OS.class_addMethod(cls, OS.sel_sendDoubleSelection, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_numberOfRowsInTableView_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_tableView_objectValueForTableColumn_row_, proc5, "@:@:@:@");
        OS.class_addMethod(cls, OS.sel_tableView_shouldEditTableColumn_row_, proc5, "@:@:@:@");
        OS.class_addMethod(cls, OS.sel_tableViewSelectionDidChange_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_tableView_willDisplayCell_forTableColumn_row_, proc6, "@:@@@i");
        OS.class_addMethod(cls, OS.sel_tableView_setObjectValue_forTableColumn_row_, proc6, "@:@@@i");
        OS.class_addMethod(cls, OS.sel_tableViewColumnDidMove_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_tableViewColumnDidResize_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_tableView_didClickTableColumn_, proc4, "@:@");
        OS.class_addMethod(cls, OS.sel_canDragRowsWithIndexes_atPoint_, canDragRowsWithIndexes_atPoint_Proc, "@:@{NSPoint=ff}");
        OS.class_addMethod(cls, OS.sel_tableView_writeRowsWithIndexes_toPasteboard_, proc5, "@:@@@");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTTabView";
        cls = OS.objc_allocateClassPair(OS.class_NSTabView, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_tabView_willSelectTabViewItem_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_tabView_didSelectTabViewItem_, proc4, "@:@@");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTTextView";
        cls = OS.objc_allocateClassPair(OS.class_NSTextView, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.class_addMethod(cls, OS.sel_insertText_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_doCommandBySelector_, proc3, "@::");
        OS.class_addMethod(cls, OS.sel_textDidChange_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textView_clickedOnLink_atIndex_, proc5, "@:@@@");
        OS.class_addMethod(cls, OS.sel_dragSelectionWithEvent_offset_slideBack_, proc5, "@:@@@");
        OS.class_addMethod(cls, OS.sel_shouldChangeTextInRange_replacementString_, shouldChangeTextInRange_replacementString_Proc, "@:{NSRange}@");
        OS.objc_registerClassPair(cls);
        className = "SWTTextField";
        cls = OS.objc_allocateClassPair(OS.class_NSTextField, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.class_addMethod(cls, OS.sel_acceptsFirstResponder, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_textDidChange_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textDidEndEditing_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textViewDidChangeSelection_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_, textWillChangeSelectionProc, "@:@{NSRange}{NSRange}");
        OS.objc_registerClassPair(cls);
        cls = this.registerCellSubclass(NSTextField.cellClass(), size, align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        NSTextField.setCellClass(cls);
        className = "SWTTreeItem";
        cls = OS.objc_allocateClassPair(OS.class_NSObject, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.objc_registerClassPair(cls);
        className = "SWTView";
        cls = OS.objc_allocateClassPair(OS.class_NSView, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_canBecomeKeyView, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_isFlipped, isFlippedProc, "@:");
        OS.class_addMethod(cls, OS.sel_acceptsFirstResponder, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_isOpaque, proc2, "@:");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTWindow";
        cls = OS.objc_allocateClassPair(OS.class_NSWindow, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendEvent_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_helpRequested_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_canBecomeKeyWindow, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_becomeKeyWindow, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_makeFirstResponder_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_noResponderFor_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_view_stringForToolTip_point_userData_, view_stringForToolTip_point_userDataProc, "@:@i{NSPoint}@");
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTWindowDelegate";
        cls = OS.objc_allocateClassPair(OS.class_NSObject, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_windowDidResize_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_windowDidMove_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_windowShouldClose_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_windowWillClose_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_windowDidResignKey_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_windowDidBecomeKey_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_timerProc_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_systemSettingsChanged_, proc3, "@:@");
        OS.objc_registerClassPair(cls);
    }

    NSFont getFont(int cls, int sel) {
        int widget = OS.objc_msgSend(OS.objc_msgSend(cls, OS.sel_alloc), OS.sel_initWithFrame_, new NSRect());
        int font = 0;
        if (OS.objc_msgSend_bool(widget, OS.sel_respondsToSelector_, sel)) {
            font = OS.objc_msgSend(widget, sel);
        }
        NSFont result = null;
        result = font != 0 ? new NSFont(font) : NSFont.systemFontOfSize(NSFont.systemFontSizeForControlSize(0));
        result.retain();
        OS.objc_msgSend(widget, OS.sel_release);
        return result;
    }

    void initColors() {
        this.colors = new float[36][];
        this.colors[28] = this.getWidgetColorRGB(28);
        this.colors[29] = this.getWidgetColorRGB(29);
        this.colors[30] = this.getWidgetColorRGB(30);
        this.colors[31] = this.getWidgetColorRGB(31);
        this.colors[32] = this.getWidgetColorRGB(32);
        this.colors[33] = this.getWidgetColorRGB(33);
        this.colors[34] = this.getWidgetColorRGB(34);
        this.colors[35] = this.getWidgetColorRGB(35);
        this.colors[17] = this.getWidgetColorRGB(17);
        this.colors[18] = this.getWidgetColorRGB(18);
        this.colors[19] = this.getWidgetColorRGB(19);
        this.colors[20] = this.getWidgetColorRGB(20);
        this.colors[22] = this.getWidgetColorRGB(22);
        this.colors[21] = this.getWidgetColorRGB(21);
        this.colors[23] = this.getWidgetColorRGB(23);
        this.colors[24] = this.getWidgetColorRGB(24);
        this.colors[25] = this.getWidgetColorRGB(25);
        this.colors[27] = this.getWidgetColorRGB(27);
        this.colors[26] = this.getWidgetColorRGB(26);
        this.alternateSelectedControlColor = this.getWidgetColorRGB(NSColor.alternateSelectedControlColor());
        this.alternateSelectedControlTextColor = this.getWidgetColorRGB(NSColor.alternateSelectedControlTextColor());
        this.secondarySelectedControlColor = this.getWidgetColorRGB(NSColor.secondarySelectedControlColor());
        this.selectedControlTextColor = this.getWidgetColorRGB(NSColor.selectedControlTextColor());
    }

    void initFonts() {
        this.smallFonts = System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null;
        this.buttonFont = this.getFont(OS.class_NSButton, OS.sel_font);
        this.popUpButtonFont = this.getFont(OS.class_NSPopUpButton, OS.sel_font);
        this.textFieldFont = this.getFont(OS.class_NSTextField, OS.sel_font);
        this.secureTextFieldFont = this.getFont(OS.class_NSSecureTextField, OS.sel_font);
        this.searchFieldFont = this.getFont(OS.class_NSSearchField, OS.sel_font);
        this.comboBoxFont = this.getFont(OS.class_NSComboBox, OS.sel_font);
        this.sliderFont = this.getFont(OS.class_NSSlider, OS.sel_font);
        this.scrollerFont = this.getFont(OS.class_NSScroller, OS.sel_font);
        this.textViewFont = this.getFont(OS.class_NSTextView, OS.sel_font);
        this.tableViewFont = this.getFont(OS.class_NSTableView, OS.sel_font);
        this.outlineViewFont = this.getFont(OS.class_NSOutlineView, OS.sel_font);
        this.datePickerFont = this.getFont(OS.class_NSDatePicker, OS.sel_font);
        this.boxFont = this.getFont(OS.class_NSBox, OS.sel_titleFont);
        this.tabViewFont = this.getFont(OS.class_NSTabView, OS.sel_font);
        this.progressIndicatorFont = this.getFont(OS.class_NSProgressIndicator, OS.sel_font);
    }

    public int internal_new_GC(GCData data) {
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if (this.screenWindow == null) {
            NSWindow window = (NSWindow)new NSWindow().alloc();
            NSRect rect = new NSRect();
            window = window.initWithContentRect(rect, 0, 2, false);
            window.setReleasedWhenClosed(false);
            this.screenWindow = window;
        }
        NSGraphicsContext context = this.screenWindow.graphicsContext();
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.background = this.getSystemColor((int)1).handle;
            data.foreground = this.getSystemColor((int)2).handle;
            data.font = this.getSystemFont();
        }
        return context.id;
    }

    public void internal_dispose_GC(int context, GCData data) {
        if (this.isDisposed()) {
            SWT.error(45);
        }
    }

    static boolean isValidClass(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index + 1).equals(PACKAGE_PREFIX);
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean post(Event event) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (event == null) {
                this.error(4);
            }
            if (!this.eventSourceDelaySet) {
                OS.CGSetLocalEventsSuppressionInterval(0.0);
                OS.CGEnableEventStateCombining(1);
                OS.CGSetLocalEventsFilterDuringSuppressionState(7, 0);
                OS.CGSetLocalEventsFilterDuringSuppressionState(7, 1);
                this.eventSourceDelaySet = true;
            }
            int type = event.type;
            switch (type) {
                case 1: 
                case 2: {
                    int vKey = Display.untranslateKey(event.keyCode);
                    if (vKey == 0) {
                        int uchrPtr = 0;
                        int currentKbd = OS.TISCopyCurrentKeyboardInputSource();
                        int uchrCFData = OS.TISGetInputSourceProperty(currentKbd, OS.kTISPropertyUnicodeKeyLayoutData());
                        if (uchrCFData == 0) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return false;
                        }
                        uchrPtr = OS.CFDataGetBytePtr(uchrCFData);
                        if (uchrPtr == 0) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return false;
                        }
                        if (OS.CFDataGetLength(uchrCFData) == 0) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return false;
                        }
                        int maxStringLength = 256;
                        vKey = -1;
                        char[] output = new char[maxStringLength];
                        int[] actualStringLength = new int[1];
                        int i = 0;
                        while (i <= 127) {
                            OS.UCKeyTranslate(uchrPtr, (short)i, (short)(type != 1 ? 1 : 0), 0, OS.LMGetKbdType(), 0, this.deadKeyState, maxStringLength, actualStringLength, output);
                            if (output[0] == event.character) {
                                vKey = i;
                                break;
                            }
                            i = (short)(i + 1);
                        }
                        if (vKey == -1) {
                            i = 0;
                            while (i <= 127) {
                                OS.UCKeyTranslate(uchrPtr, (short)i, (short)(type != 1 ? 1 : 0), 512, OS.LMGetKbdType(), 0, this.deadKeyState, maxStringLength, actualStringLength, output);
                                if (output[0] == event.character) {
                                    vKey = i;
                                    break;
                                }
                                i = (short)(i + 1);
                            }
                        }
                    }
                    if (vKey == -1 && event.character == '\u0000') {
                        vKey = 127;
                    }
                    if (vKey == -1) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return OS.CGPostKeyboardEvent((short)0, (short)vKey, type == 1) == 0;
                }
                case 3: 
                case 4: 
                case 5: {
                    CGPoint mouseCursorPosition = new CGPoint();
                    int chord = OS.GetCurrentButtonState();
                    if (type == 5) {
                        mouseCursorPosition.x = event.x;
                        mouseCursorPosition.y = event.y;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return OS.CGPostMouseEvent(mouseCursorPosition, true, 5, (chord & 1) != 0, (chord & 2) != 0, (chord & 4) != 0, (chord & 8) != 0, (chord & 0x10) != 0) == 0;
                    }
                    int button = event.button;
                    if (button < 1 || button > 5) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    boolean button1 = false;
                    boolean button2 = false;
                    boolean button3 = false;
                    boolean button4 = false;
                    boolean button5 = false;
                    switch (button) {
                        case 1: {
                            button1 = type == 3;
                            button2 = (chord & 4) != 0;
                            button3 = (chord & 2) != 0;
                            button4 = (chord & 8) != 0;
                            button5 = (chord & 0x10) != 0;
                            break;
                        }
                        case 2: {
                            button1 = (chord & 1) != 0;
                            button2 = type == 3;
                            button3 = (chord & 2) != 0;
                            button4 = (chord & 8) != 0;
                            button5 = (chord & 0x10) != 0;
                            break;
                        }
                        case 3: {
                            button1 = (chord & 1) != 0;
                            button2 = (chord & 4) != 0;
                            button3 = type == 3;
                            button4 = (chord & 8) != 0;
                            button5 = (chord & 0x10) != 0;
                            break;
                        }
                        case 4: {
                            button1 = (chord & 1) != 0;
                            button2 = (chord & 4) != 0;
                            button3 = (chord & 2) != 0;
                            button4 = type == 3;
                            button5 = (chord & 0x10) != 0;
                            break;
                        }
                        case 5: {
                            button1 = (chord & 1) != 0;
                            button2 = (chord & 4) != 0;
                            button3 = (chord & 2) != 0;
                            button4 = (chord & 8) != 0;
                            button5 = type == 3;
                        }
                    }
                    NSPoint nsCursorPosition = NSEvent.mouseLocation();
                    NSRect primaryFrame = this.getPrimaryFrame();
                    mouseCursorPosition.x = nsCursorPosition.x;
                    mouseCursorPosition.y = (int)(primaryFrame.height - nsCursorPosition.y);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return OS.CGPostMouseEvent(mouseCursorPosition, true, 5, button1, button3, button2, button4, button5) == 0;
                }
                case 37: {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return OS.CGPostScrollWheelEvent(1, event.count) == 0;
                }
                default: 
            }
        }
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int index = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            if (this.eventQueue[index] == null) break;
            ++index;
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
    }

    public Point map(Control from, Control to, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(from, to, point.x, point.y);
    }

    public Point map(Control from, Control to, int x, int y) {
        NSWindow toWindow;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Point point = new Point(x, y);
        if (from == to) {
            return point;
        }
        NSPoint pt = new NSPoint();
        pt.x = x;
        pt.y = y;
        NSWindow fromWindow = from != null ? from.view.window() : null;
        NSWindow nSWindow = toWindow = to != null ? to.view.window() : null;
        if (toWindow != null && fromWindow != null && toWindow.id == fromWindow.id) {
            if (!from.view.isFlipped()) {
                pt.y = from.view.bounds().height - pt.y;
            }
            pt = from.view.convertPoint_toView_(pt, to.view);
            if (!to.view.isFlipped()) {
                pt.y = to.view.bounds().height - pt.y;
            }
        } else {
            NSView view;
            NSRect primaryFrame = this.getPrimaryFrame();
            if (from != null) {
                view = from.eventView();
                if (!view.isFlipped()) {
                    pt.y = view.bounds().height - pt.y;
                }
                pt = view.convertPoint_toView_(pt, null);
                pt = fromWindow.convertBaseToScreen(pt);
                pt.y = primaryFrame.height - pt.y;
            }
            if (to != null) {
                view = to.eventView();
                pt.y = primaryFrame.height - pt.y;
                pt = toWindow.convertScreenToBase(pt);
                pt = view.convertPoint_fromView_(pt, null);
                if (!view.isFlipped()) {
                    pt.y = view.bounds().height - pt.y;
                }
            }
        }
        point.x = (int)pt.x;
        point.y = (int)pt.y;
        return point;
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        NSWindow toWindow;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Rectangle rectangle = new Rectangle(x, y, width, height);
        if (from == to) {
            return rectangle;
        }
        NSPoint pt = new NSPoint();
        pt.x = x;
        pt.y = y;
        NSWindow fromWindow = from != null ? from.view.window() : null;
        NSWindow nSWindow = toWindow = to != null ? to.view.window() : null;
        if (toWindow != null && fromWindow != null && toWindow.id == fromWindow.id) {
            if (!from.view.isFlipped()) {
                pt.y = from.view.bounds().height - pt.y;
            }
            pt = from.view.convertPoint_toView_(pt, to.view);
            if (!to.view.isFlipped()) {
                pt.y = to.view.bounds().height - pt.y;
            }
        } else {
            NSView view;
            NSRect primaryFrame = this.getPrimaryFrame();
            if (from != null) {
                view = from.eventView();
                if (!view.isFlipped()) {
                    pt.y = view.bounds().height - pt.y;
                }
                pt = view.convertPoint_toView_(pt, null);
                pt = fromWindow.convertBaseToScreen(pt);
                pt.y = primaryFrame.height - pt.y;
            }
            if (to != null) {
                view = to.eventView();
                pt.y = primaryFrame.height - pt.y;
                pt = toWindow.convertScreenToBase(pt);
                pt = view.convertPoint_fromView_(pt, null);
                if (!view.isFlipped()) {
                    pt.y = view.bounds().height - pt.y;
                }
            }
        }
        rectangle.x = (int)pt.x;
        rectangle.y = (int)pt.y;
        return rectangle;
    }

    int observerProc(int observer, int activity, int info) {
        switch (activity) {
            case 32: {
                if (!this.runAsyncMessages || !this.runAsyncMessages(false)) break;
                this.wakeThread();
            }
        }
        return 0;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        if (this.sendEventCount == 0 && this.loopCount == this.poolCount - 1 && Callback.getEntryCount() == 0) {
            this.removePool();
        }
        this.addPool();
        ++this.loopCount;
        boolean events = false;
        try {
            events |= this.runSettings();
            events |= this.runTimers();
            events |= this.runContexts();
            events |= this.runPopups();
            NSEvent event = this.application.nextEventMatchingMask(0, null, OS.NSDefaultRunLoopMode, true);
            if (event != null) {
                events = true;
                this.application.sendEvent(event);
            }
            events |= this.runPaint();
            if (!(events |= this.runDeferredEvents())) {
                events = this.isDisposed() || this.runAsyncMessages(false);
            }
        }
        finally {
            this.removePool();
            --this.loopCount;
            if (this.sendEventCount == 0 && this.loopCount == this.poolCount && Callback.getEntryCount() == 0) {
                this.addPool();
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                if (Displays[i] == null) {
                    Display.Displays[i] = display;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                ++i;
            }
            Display[] newDisplays = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
            newDisplays[Display.Displays.length] = display;
            Displays = newDisplays;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void release() {
        this.disposing = true;
        this.sendEvent(12, new Event());
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++i;
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            i = 0;
            while (i < this.disposeList.length) {
                if (this.disposeList[i] != null) {
                    this.disposeList[i].run();
                }
                ++i;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        int i;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        this.warningImage = null;
        this.infoImage = null;
        this.errorImage = null;
        this.currentCaret = null;
        if (this.hoverTimer != null) {
            this.timerExec(-1, this.hoverTimer);
        }
        this.hoverTimer = null;
        if (this.caretTimer != null) {
            this.timerExec(-1, this.caretTimer);
        }
        this.caretTimer = null;
        if (this.nsTimers != null) {
            i = 0;
            while (i < this.nsTimers.length) {
                if (this.nsTimers[i] != null) {
                    this.nsTimers[i].invalidate();
                    this.nsTimers[i].release();
                }
                ++i;
            }
        }
        this.nsTimers = null;
        if (this.timerDelegate != null) {
            this.timerDelegate.release();
        }
        this.timerDelegate = null;
        i = 0;
        while (i < this.cursors.length) {
            if (this.cursors[i] != null) {
                this.cursors[i].dispose();
            }
            ++i;
        }
        this.cursors = null;
        if (this.buttonFont != null) {
            this.buttonFont.release();
        }
        if (this.popUpButtonFont != null) {
            this.popUpButtonFont.release();
        }
        if (this.textFieldFont != null) {
            this.textFieldFont.release();
        }
        if (this.secureTextFieldFont != null) {
            this.secureTextFieldFont.release();
        }
        if (this.searchFieldFont != null) {
            this.searchFieldFont.release();
        }
        if (this.comboBoxFont != null) {
            this.comboBoxFont.release();
        }
        if (this.sliderFont != null) {
            this.sliderFont.release();
        }
        if (this.scrollerFont != null) {
            this.scrollerFont.release();
        }
        if (this.textViewFont != null) {
            this.textViewFont.release();
        }
        if (this.tableViewFont != null) {
            this.tableViewFont.release();
        }
        if (this.outlineViewFont != null) {
            this.outlineViewFont.release();
        }
        if (this.datePickerFont != null) {
            this.datePickerFont.release();
        }
        if (this.boxFont != null) {
            this.boxFont.release();
        }
        if (this.tabViewFont != null) {
            this.tabViewFont.release();
        }
        if (this.progressIndicatorFont != null) {
            this.progressIndicatorFont.release();
        }
        this.secureTextFieldFont = null;
        this.textFieldFont = null;
        this.popUpButtonFont = null;
        this.buttonFont = null;
        this.comboBoxFont = this.sliderFont = this.scrollerFont;
        this.searchFieldFont = this.sliderFont;
        this.datePickerFont = null;
        this.outlineViewFont = null;
        this.tableViewFont = null;
        this.textViewFont = null;
        this.progressIndicatorFont = null;
        this.tabViewFont = null;
        this.boxFont = null;
        if (this.dockImage != null) {
            this.dockImage.release();
        }
        this.dockImage = null;
        if (this.screenWindow != null) {
            this.screenWindow.release();
        }
        this.screenWindow = null;
        if (this.needsDisplay != null) {
            this.needsDisplay.release();
        }
        if (this.needsDisplayInRect != null) {
            this.needsDisplayInRect.release();
        }
        if (this.isPainting != null) {
            this.isPainting.release();
        }
        this.isPainting = null;
        this.needsDisplayInRect = null;
        this.needsDisplay = null;
        this.modalShells = null;
        this.menuBar = null;
        this.menus = null;
        if (this.markedAttributes != null) {
            this.markedAttributes.release();
        }
        this.markedAttributes = null;
        if (this.oldCursorSetProc != 0) {
            int method = OS.class_getInstanceMethod(OS.class_NSCursor, OS.sel_set);
            OS.method_setImplementation(method, this.oldCursorSetProc);
        }
        if (this.cursorSetCallback != null) {
            this.cursorSetCallback.dispose();
        }
        this.cursorSetCallback = null;
        this.deadKeyState = null;
        if (this.settingsDelegate != null) {
            NSNotificationCenter.defaultCenter().removeObserver(this.settingsDelegate);
            this.settingsDelegate.release();
        }
        this.settingsDelegate = null;
        if (!this.isEmbedded) {
            NSMenu menubar = this.application.mainMenu();
            int count = menubar.numberOfItems();
            while (count > 1) {
                menubar.removeItemAtIndex(count - 1);
                --count;
            }
        }
        if (this.application != null && this.applicationClass != 0) {
            OS.object_setClass(this.application.id, this.applicationClass);
        }
        this.application = null;
        this.applicationClass = 0;
        if (this.runLoopObserver != 0) {
            OS.CFRunLoopObserverInvalidate(this.runLoopObserver);
            OS.CFRelease(this.runLoopObserver);
        }
        this.runLoopObserver = 0;
        if (this.observerCallback != null) {
            this.observerCallback.dispose();
        }
        this.observerCallback = null;
    }

    void removeContext(GCData context) {
        if (this.contexts == null) {
            return;
        }
        int count = 0;
        int i = 0;
        while (i < this.contexts.length) {
            if (this.contexts[i] != null) {
                if (this.contexts[i] == context) {
                    this.contexts[i] = null;
                } else {
                    ++count;
                }
            }
            ++i;
        }
        if (count == 0) {
            this.contexts = null;
        }
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(eventType, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    Widget removeWidget(NSObject view) {
        if (view == null) {
            return null;
        }
        int[] jniRef = new int[1];
        OS.object_getInstanceVariable(view.id, SWT_OBJECT, jniRef);
        if (jniRef[0] == 0) {
            return null;
        }
        Widget widget = (Widget)OS.JNIGetObject(jniRef[0]);
        OS.object_setInstanceVariable(view.id, SWT_OBJECT, 0);
        return widget;
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == menu) {
                this.menus[i] = null;
                break;
            }
            ++i;
        }
    }

    void removePool() {
        NSAutoreleasePool pool = this.pools[this.poolCount - 1];
        this.pools[--this.poolCount] = null;
        if (this.poolCount == 0) {
            NSMutableDictionary dictionary = NSThread.currentThread().threadDictionary();
            dictionary.removeObjectForKey(NSString.stringWith("SWT_NSAutoreleasePool"));
        }
        pool.release();
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int i = 0;
        while (i < this.popups.length) {
            if (this.popups[i] == menu) {
                this.popups[i] = null;
                return;
            }
            ++i;
        }
    }

    boolean runAsyncMessages(boolean all) {
        return this.synchronizer.runAsyncMessages(all);
    }

    boolean runContexts() {
        if (this.contexts != null) {
            int i = 0;
            while (i < this.contexts.length) {
                if (this.contexts[i] != null && this.contexts[i].flippedContext != null) {
                    this.contexts[i].flippedContext.flushGraphics();
                }
                ++i;
            }
        }
        return false;
    }

    boolean runDeferredEvents() {
        boolean run = false;
        while (this.eventQueue != null) {
            Widget item;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            run = true;
            widget.notifyListeners(event.type, event);
        }
        this.eventQueue = null;
        return run;
    }

    boolean runPaint() {
        int i;
        int count;
        if (this.needsDisplay == null && this.needsDisplayInRect == null) {
            return false;
        }
        if (this.needsDisplay != null) {
            count = this.needsDisplay.count();
            i = 0;
            while (i < count) {
                OS.objc_msgSend(this.needsDisplay.objectAtIndex((int)i).id, OS.sel_setNeedsDisplay_, true);
                ++i;
            }
            this.needsDisplay.release();
            this.needsDisplay = null;
        }
        if (this.needsDisplayInRect != null) {
            count = this.needsDisplayInRect.count();
            i = 0;
            while (i < count) {
                NSValue value = new NSValue(this.needsDisplayInRect.objectAtIndex(i + 1));
                OS.objc_msgSend(this.needsDisplayInRect.objectAtIndex((int)i).id, OS.sel_setNeedsDisplayInRect_, value.rectValue());
                i += 2;
            }
            this.needsDisplayInRect.release();
            this.needsDisplayInRect = null;
        }
        return true;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean result = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            this.runDeferredEvents();
            int length = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --length);
            this.popups[length] = null;
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            result = true;
        }
        this.popups = null;
        return result;
    }

    boolean runSettings() {
        if (!this.runSettings) {
            return false;
        }
        this.runSettings = false;
        this.initColors();
        this.sendEvent(39, null);
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.redraw(true);
                shell.layout(true, true);
            }
            ++i;
        }
        return true;
    }

    boolean runTimers() {
        if (this.timerList == null) {
            return false;
        }
        boolean result = false;
        int i = 0;
        while (i < this.timerList.length) {
            if (this.nsTimers[i] == null && this.timerList[i] != null) {
                Runnable runnable = this.timerList[i];
                this.timerList[i] = null;
                if (runnable != null) {
                    result = true;
                    runnable.run();
                }
            }
            ++i;
        }
        return result;
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        this.sendEvent(this.eventTable, event);
    }

    void sendEvent(EventTable table, Event event) {
        try {
            ++this.sendEventCount;
            if (!this.filterEvent(event) && table != null) {
                table.sendEvent(event);
            }
        }
        finally {
            --this.sendEventCount;
        }
    }

    static NSString getAppName() {
        id value;
        NSString name = null;
        int pid = OS.getpid();
        int ptr = OS.getenv(Display.ascii("APP_NAME_" + pid));
        if (ptr != 0) {
            name = NSString.stringWithUTF8String(ptr);
        }
        if (name == null && APP_NAME != null) {
            name = NSString.stringWith(APP_NAME);
        }
        if (name == null && (value = NSBundle.mainBundle().objectForInfoDictionaryKey(NSString.stringWith("CFBundleName"))) != null) {
            name = new NSString(value);
        }
        if (name == null) {
            name = NSString.stringWith("SWT");
        }
        return name;
    }

    public static void setAppName(String name) {
        APP_NAME = name;
    }

    void setCurrentCaret(Caret caret) {
        this.currentCaret = caret;
        int blinkRate = this.currentCaret != null ? this.currentCaret.blinkRate : -1;
        this.timerExec(blinkRate, this.caretTimer);
    }

    void setCursor(Control control) {
        Cursor cursor = null;
        if (control != null && !control.isDisposed()) {
            cursor = control.findCursor();
        }
        if (cursor == null) {
            NSWindow window = this.application.keyWindow();
            if (window != null) {
                if (window.areCursorRectsEnabled()) {
                    window.disableCursorRects();
                    window.enableCursorRects();
                }
                return;
            }
            cursor = this.getSystemCursor(0);
        }
        this.lockCursor = false;
        cursor.handle.set();
        this.lockCursor = true;
    }

    public void setCursorLocation(int x, int y) {
        this.checkDevice();
        CGPoint pt = new CGPoint();
        pt.x = x;
        pt.y = y;
        OS.CGWarpMouseCursorPosition(pt);
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(ADD_WIDGET_KEY)) {
            Object[] data = (Object[])value;
            NSObject object = (NSObject)data[0];
            Widget widget = (Widget)data[1];
            if (widget == null) {
                this.removeWidget(object);
            } else {
                this.addWidget(object, widget);
            }
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    void setMenuBar(Menu menu) {
        if (menu == this.menuBar) {
            return;
        }
        this.menuBar = menu;
        NSMenu menubar = this.application.mainMenu();
        OS.CancelMenuTracking(OS.AcquireRootMenu(), true, 0);
        int count = menubar.numberOfItems();
        while (count > 1) {
            menubar.removeItemAtIndex(count - 1);
            --count;
        }
        if (menu != null) {
            MenuItem[] items = menu.getItems();
            int i = 0;
            while (i < items.length) {
                MenuItem item = items[i];
                NSMenuItem nsItem = item.nsItem;
                nsItem.setMenu(null);
                menubar.addItem(nsItem);
                boolean enabled = menu.getEnabled() && item.getEnabled();
                nsItem.setEnabled(!enabled);
                nsItem.setEnabled(enabled);
                ++i;
            }
        }
    }

    void setModalShell(Shell shell) {
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int index = 0;
        int length = this.modalShells.length;
        while (index < length) {
            if (this.modalShells[index] == shell) {
                return;
            }
            if (this.modalShells[index] == null) break;
            ++index;
        }
        if (index == length) {
            Shell[] newModalShells = new Shell[length + 4];
            System.arraycopy(this.modalShells, 0, newModalShells, 0, length);
            this.modalShells = newModalShells;
        }
        this.modalShells[index] = shell;
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].updateModal();
            ++i;
        }
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Synchronizer oldSynchronizer = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (oldSynchronizer != null) {
                oldSynchronizer.runAsyncMessages(true);
            }
            return;
        }
    }

    public boolean sleep() {
        this.checkDevice();
        if (this.getMessageCount() != 0) {
            return true;
        }
        try {
            this.addPool();
            this.runAsyncMessages = false;
            this.allowTimers = false;
            NSRunLoop.currentRunLoop().runMode(OS.NSDefaultRunLoopMode, NSDate.distantFuture());
            this.runAsyncMessages = true;
            this.allowTimers = true;
        }
        finally {
            this.removePool();
        }
        return true;
    }

    int sourceProc(int info) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.syncExec(runnable);
            return;
        }
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.nsTimers == null) {
            this.nsTimers = new NSTimer[4];
        }
        int index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == runnable) break;
            ++index;
        }
        if (index != this.timerList.length) {
            NSTimer timer = this.nsTimers[index];
            if (timer == null) {
                this.timerList[index] = null;
            } else {
                if (milliseconds < 0) {
                    timer.invalidate();
                    timer.release();
                    this.timerList[index] = null;
                    this.nsTimers[index] = null;
                } else {
                    timer.setFireDate(NSDate.dateWithTimeIntervalSinceNow((double)milliseconds / 1000.0));
                }
                return;
            }
        }
        if (milliseconds < 0) {
            return;
        }
        index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == null) break;
            ++index;
        }
        if (index == this.timerList.length) {
            Runnable[] newTimerList = new Runnable[this.timerList.length + 4];
            System.arraycopy(this.timerList, 0, newTimerList, 0, this.timerList.length);
            this.timerList = newTimerList;
            NSTimer[] newTimerIds = new NSTimer[this.nsTimers.length + 4];
            System.arraycopy(this.nsTimers, 0, newTimerIds, 0, this.nsTimers.length);
            this.nsTimers = newTimerIds;
        }
        NSNumber userInfo = NSNumber.numberWithInt(index);
        NSTimer timer = NSTimer.scheduledTimerWithTimeInterval((double)milliseconds / 1000.0, this.timerDelegate, OS.sel_timerProc_, userInfo, false);
        NSRunLoop.currentRunLoop().addTimer(timer, OS.NSEventTrackingRunLoopMode);
        timer.retain();
        if (timer != null) {
            this.nsTimers[index] = timer;
            this.timerList[index] = runnable;
        }
    }

    int timerProc(int id2, int sel, int timerID) {
        NSTimer timer = new NSTimer(timerID);
        NSNumber number = new NSNumber(timer.userInfo());
        int index = number.intValue();
        if (this.timerList == null) {
            return 0;
        }
        if (index >= 0 && index < this.timerList.length) {
            if (this.allowTimers) {
                Runnable runnable = this.timerList[index];
                this.timerList[index] = null;
                this.nsTimers[index] = null;
                if (runnable != null) {
                    runnable.run();
                }
            } else {
                this.nsTimers[index] = null;
                this.wakeThread();
            }
        }
        timer.invalidate();
        timer.release();
        return 0;
    }

    public void update() {
        this.checkDevice();
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.update(true);
            }
            ++i;
        }
    }

    void updateDefaultButton() {
        this.timerExec(this.hasDefaultButton() ? 30 : -1, this.defaultButtonTimer);
    }

    void updateQuitMenu() {
        NSMenu sm;
        int quitIndex;
        boolean enabled = true;
        Shell[] shells = this.getShells();
        int mask = 229376;
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if ((shell.style & mask) != 0 && shell.isVisible()) {
                enabled = false;
                break;
            }
            ++i;
        }
        NSMenu mainmenu = this.application.mainMenu();
        NSMenuItem appitem = mainmenu.itemAtIndex(0);
        if (appitem != null && (quitIndex = (sm = appitem.submenu()).indexOfItemWithTarget(applicationDelegate, OS.sel_quitRequested_)) != -1) {
            NSMenuItem quitItem = sm.itemAtIndex(quitIndex);
            quitItem.setEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThread() {
        NSObject object = new NSObject().alloc().init();
        object.performSelectorOnMainThread(OS.sel_release, null, false);
    }

    Control findControl(boolean checkTrim) {
        return this.findControl(checkTrim, null);
    }

    Control findControl(boolean checkTrim, NSView[] hitView) {
        NSView view = null;
        NSPoint screenLocation = NSEvent.mouseLocation();
        NSArray windows = this.application.orderedWindows();
        int i = 0;
        int count = windows.count();
        while (i < count && view == null) {
            NSWindow window = new NSWindow(windows.objectAtIndex(i));
            NSView contentView = window.contentView();
            if (contentView != null && OS.NSPointInRect(screenLocation, window.frame())) {
                NSPoint location = window.convertScreenToBase(screenLocation);
                view = contentView.hitTest(location);
                if (view != null || checkTrim) break;
                view = contentView;
                break;
            }
            ++i;
        }
        Control control = null;
        if (view != null) {
            do {
                Widget widget;
                if (!((widget = this.getWidget(view)) instanceof Control)) continue;
                control = (Control)widget;
                break;
            } while ((view = view.superview()) != null);
        }
        if (checkTrim && control != null && control.isTrim(view)) {
            control = null;
        }
        if (control != null && hitView != null) {
            hitView[0] = view;
        }
        return control;
    }

    void finishLaunching(int id2, int sel) {
        if (launched) {
            return;
        }
        launched = true;
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel);
    }

    void applicationDidBecomeActive(int id2, int sel, int notification) {
        this.checkFocus();
        this.checkEnterExit(this.findControl(true), null, false);
    }

    void applicationDidResignActive(int id2, int sel, int notification) {
        this.checkFocus();
        this.checkEnterExit(null, null, false);
    }

    int applicationNextEventMatchingMask(int id2, int sel, int mask, int expiration, int mode, int dequeue) {
        if (dequeue != 0 && this.trackingControl != null && !this.trackingControl.isDisposed()) {
            this.runDeferredEvents();
        }
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        int result = OS.objc_msgSendSuper(super_struct, sel, mask, expiration, mode, dequeue != 0);
        if (result != 0 && dequeue != 0 && this.trackingControl != null && !this.trackingControl.isDisposed()) {
            this.applicationSendTrackingEvent(new NSEvent(result), this.trackingControl);
        }
        return result;
    }

    void applicationSendTrackingEvent(NSEvent nsEvent, Control trackingControl) {
        int type = nsEvent.type();
        switch (type) {
            case 1: 
            case 3: 
            case 25: {
                trackingControl.sendMouseEvent(nsEvent, 3, true);
                break;
            }
            case 2: 
            case 4: 
            case 26: {
                this.checkEnterExit(this.findControl(true), nsEvent, true);
                if (trackingControl.isDisposed()) {
                    return;
                }
                trackingControl.sendMouseEvent(nsEvent, 4, true);
                break;
            }
            case 6: 
            case 7: 
            case 27: {
                this.checkEnterExit(trackingControl, nsEvent, true);
                if (trackingControl.isDisposed()) {
                    return;
                }
            }
            case 5: {
                trackingControl.sendMouseEvent(nsEvent, 5, true);
            }
        }
    }

    void applicationSendEvent(int id2, int sel, int event) {
        NSEvent nsEvent = new NSEvent(event);
        NSWindow window = nsEvent.window();
        int type = nsEvent.type();
        boolean down = false;
        switch (type) {
            case 1: 
            case 3: 
            case 25: {
                down = true;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 22: 
            case 26: 
            case 27: {
                Shell modalShell;
                Shell shell;
                if (window == null || (shell = (Shell)this.getWidget(window.id)) == null || (modalShell = shell.getModalShell()) == null) break;
                if (down) {
                    if (!this.application.isActive()) {
                        this.application.activateIgnoringOtherApps(true);
                    }
                    NSRect rect = window.contentRectForFrameRect(window.frame());
                    NSPoint pt = window.convertBaseToScreen(nsEvent.locationInWindow());
                    if (OS.NSPointInRect(pt, rect)) {
                        this.beep();
                    }
                }
                return;
            }
        }
        this.sendEvent = true;
        if (window != null && window.isKeyWindow() && nsEvent.type() == 10 && (nsEvent.modifierFlags() & 0x400000) != 0) {
            window.sendEvent(nsEvent);
        }
        if (window != null && window.isKeyWindow() && nsEvent.type() == 11 && (nsEvent.modifierFlags() & 0x100000) != 0) {
            window.sendEvent(nsEvent);
        } else {
            objc_super super_struct = new objc_super();
            super_struct.receiver = id2;
            super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
            OS.objc_msgSendSuper(super_struct, sel, event);
        }
        this.sendEvent = false;
    }

    void applicationWillFinishLaunching(int id2, int sel, int notification) {
        NSMenu mainmenu;
        NSMenuItem appitem;
        boolean loaded = false;
        NSBundle bundle = NSBundle.bundleWithIdentifier(NSString.stringWith("com.apple.JavaVM"));
        NSDictionary dict = NSDictionary.dictionaryWithObject(applicationDelegate, NSString.stringWith("NSOwner"));
        NSString path = bundle.pathForResource(NSString.stringWith("DefaultApp"), NSString.stringWith("nib"));
        if (!loaded) {
            boolean bl = loaded = path != null && NSBundle.loadNibFile(path, dict, 0);
        }
        if (!loaded) {
            NSString resourcePath = bundle.resourcePath();
            path = resourcePath != null ? resourcePath.stringByAppendingString(NSString.stringWith("/English.lproj/DefaultApp.nib")) : null;
            boolean bl = loaded = path != null && NSBundle.loadNibFile(path, dict, 0);
        }
        if (!loaded) {
            path = NSString.stringWith(String.valueOf(System.getProperty("java.home")) + "/../Resources/English.lproj/DefaultApp.nib");
            boolean bl = loaded = path != null && NSBundle.loadNibFile(path, dict, 0);
        }
        if (!loaded) {
            this.createMainMenu();
        }
        if ((appitem = (mainmenu = this.application.mainMenu()).itemAtIndex(0)) != null) {
            NSString name = Display.getAppName();
            NSString match = NSString.stringWith("%@");
            appitem.setTitle(name);
            NSMenu sm = appitem.submenu();
            NSArray ia = sm.itemArray();
            int i = 0;
            while (i < ia.count()) {
                NSMenuItem ni = new NSMenuItem(ia.objectAtIndex(i));
                NSString title = ni.title().stringByReplacingOccurrencesOfString(match, name);
                ni.setTitle(title);
                ++i;
            }
            int quitIndex = sm.indexOfItemWithTarget(applicationDelegate, OS.sel_terminate_);
            if (quitIndex != -1) {
                NSMenuItem quitItem = sm.itemAtIndex(quitIndex);
                quitItem.setAction(OS.sel_quitRequested_);
            }
        }
    }

    static int applicationProc(int id2, int sel) {
        Display display = Display.getCurrent();
        if (display == null) {
            return 0;
        }
        if (sel == OS.sel_isRunning) {
            return display.isDisposed() ? 0 : 1;
        }
        if (sel == OS.sel_finishLaunching) {
            display.finishLaunching(id2, sel);
        }
        return 0;
    }

    static int applicationProc(int id2, int sel, int arg0) {
        Display display = Display.getCurrent();
        if (display == null) {
            return 0;
        }
        NSApplication application = display.application;
        if (sel == OS.sel_sendEvent_) {
            display.applicationSendEvent(id2, sel, arg0);
        } else if (sel == OS.sel_applicationWillFinishLaunching_) {
            display.applicationWillFinishLaunching(id2, sel, arg0);
        } else if (sel != OS.sel_terminate_ && sel != OS.sel_orderFrontStandardAboutPanel_) {
            if (sel == OS.sel_hideOtherApplications_) {
                application.hideOtherApplications(application);
            } else if (sel == OS.sel_hide_) {
                application.hide(application);
            } else if (sel == OS.sel_unhideAllApplications_) {
                application.unhideAllApplications(application);
            } else if (sel == OS.sel_quitRequested_) {
                if (!display.disposing) {
                    Event event = new Event();
                    display.sendEvent(21, event);
                    if (event.doit) {
                        display.dispose();
                    }
                }
            } else if (sel == OS.sel_applicationDidBecomeActive_) {
                display.applicationDidBecomeActive(id2, sel, arg0);
            } else if (sel == OS.sel_applicationDidResignActive_) {
                display.applicationDidResignActive(id2, sel, arg0);
            }
        }
        return 0;
    }

    static int applicationProc(int id2, int sel, int arg0, int arg1, int arg2, int arg3) {
        Display display = Display.getCurrent();
        if (display == null) {
            return 0;
        }
        if (sel == OS.sel_nextEventMatchingMask_untilDate_inMode_dequeue_) {
            return display.applicationNextEventMatchingMask(id2, sel, arg0, arg1, arg2, arg3);
        }
        return 0;
    }

    static int dialogProc(int id2, int sel, int arg0) {
        int[] jniRef = new int[1];
        OS.object_getInstanceVariable(id2, SWT_OBJECT, jniRef);
        if (jniRef[0] == 0) {
            return 0;
        }
        if (sel == OS.sel_changeColor_) {
            ColorDialog dialog = (ColorDialog)OS.JNIGetObject(jniRef[0]);
            if (dialog == null) {
                return 0;
            }
            dialog.changeColor(id2, sel, arg0);
        } else if (sel == OS.sel_changeFont_) {
            FontDialog dialog = (FontDialog)OS.JNIGetObject(jniRef[0]);
            if (dialog == null) {
                return 0;
            }
            dialog.changeFont(id2, sel, arg0);
        } else if (sel == OS.sel_sendSelection_) {
            FileDialog dialog = (FileDialog)OS.JNIGetObject(jniRef[0]);
            if (dialog == null) {
                return 0;
            }
            dialog.sendSelection(id2, sel, arg0);
        } else if (sel == OS.sel_windowWillClose_) {
            Object object = OS.JNIGetObject(jniRef[0]);
            if (object instanceof FontDialog) {
                ((FontDialog)object).windowWillClose(id2, sel, arg0);
            } else if (object instanceof ColorDialog) {
                ((ColorDialog)object).windowWillClose(id2, sel, arg0);
            }
        }
        return 0;
    }

    static int dialogProc(int id2, int sel, int arg0, int arg1) {
        int[] jniRef = new int[1];
        OS.object_getInstanceVariable(id2, SWT_OBJECT, jniRef);
        if (jniRef[0] == 0) {
            return 0;
        }
        if (sel == OS.sel_panel_shouldShowFilename_) {
            FileDialog dialog = (FileDialog)OS.JNIGetObject(jniRef[0]);
            if (dialog == null) {
                return 0;
            }
            return dialog.panel_shouldShowFilename(id2, sel, arg0, arg1);
        }
        return 0;
    }

    static int dialogProc(int id2, int sel, int arg0, int arg1, int arg2) {
        int[] jniRef = new int[1];
        OS.object_getInstanceVariable(id2, SWT_OBJECT, jniRef);
        if (jniRef[0] == 0) {
            return 0;
        }
        if (sel == OS.sel_panelDidEnd_returnCode_contextInfo_) {
            MessageBox dialog = (MessageBox)OS.JNIGetObject(jniRef[0]);
            if (dialog == null) {
                return 0;
            }
            dialog.panelDidEnd_returnCode_contextInfo(id2, sel, arg0, arg1, arg2);
        }
        return 0;
    }

    static int fieldEditorProc(int id2, int sel, int arg0) {
        Widget widget = null;
        NSView view = new NSView(id2);
        while ((widget = Display.GetWidget(view.id)) == null && (view = view.superview()) != null) {
        }
        if (widget == null) {
            return 0;
        }
        if (sel == OS.sel_keyDown_) {
            widget.keyDown(id2, sel, arg0);
        } else if (sel == OS.sel_keyUp_) {
            widget.keyUp(id2, sel, arg0);
        } else if (sel == OS.sel_flagsChanged_) {
            widget.flagsChanged(id2, sel, arg0);
        } else {
            if (sel == OS.sel_insertText_) {
                return widget.insertText(id2, sel, arg0) ? 1 : 0;
            }
            if (sel == OS.sel_doCommandBySelector_) {
                widget.doCommandBySelector(id2, sel, arg0);
            } else {
                if (sel == OS.sel_menuForEvent_) {
                    return widget.menuForEvent(id2, sel, arg0);
                }
                if (sel == OS.sel_mouseDown_) {
                    widget.mouseDown(id2, sel, arg0);
                } else if (sel == OS.sel_mouseUp_) {
                    widget.mouseUp(id2, sel, arg0);
                } else if (sel == OS.sel_mouseMoved_) {
                    widget.mouseMoved(id2, sel, arg0);
                } else if (sel == OS.sel_mouseDragged_) {
                    widget.mouseDragged(id2, sel, arg0);
                } else if (sel == OS.sel_mouseEntered_) {
                    widget.mouseEntered(id2, sel, arg0);
                } else if (sel == OS.sel_mouseExited_) {
                    widget.mouseExited(id2, sel, arg0);
                } else if (sel == OS.sel_cursorUpdate_) {
                    widget.cursorUpdate(id2, sel, arg0);
                } else if (sel == OS.sel_rightMouseDown_) {
                    widget.rightMouseDown(id2, sel, arg0);
                } else if (sel == OS.sel_rightMouseDragged_) {
                    widget.rightMouseDragged(id2, sel, arg0);
                } else if (sel == OS.sel_rightMouseUp_) {
                    widget.rightMouseUp(id2, sel, arg0);
                } else if (sel == OS.sel_otherMouseDown_) {
                    widget.otherMouseDown(id2, sel, arg0);
                } else if (sel == OS.sel_otherMouseUp_) {
                    widget.otherMouseUp(id2, sel, arg0);
                } else if (sel == OS.sel_otherMouseDragged_) {
                    widget.otherMouseDragged(id2, sel, arg0);
                }
            }
        }
        return 0;
    }

    static int fieldEditorProc(int id2, int sel, int arg0, int arg1) {
        Widget widget = null;
        NSView view = new NSView(id2);
        while ((widget = Display.GetWidget(view.id)) == null && (view = view.superview()) != null) {
        }
        if (sel == OS.sel_shouldChangeTextInRange_replacementString_) {
            return widget.shouldChangeTextInRange_replacementString(id2, sel, arg0, arg1) ? 1 : 0;
        }
        return 0;
    }

    static int windowProc(int id2, int sel) {
        if (!NSThread.isMainThread() && sel == OS.sel_isOpaque) {
            return 1;
        }
        Widget widget = Display.GetWidget(id2);
        if (widget == null) {
            return 0;
        }
        if (sel == OS.sel_sendSelection) {
            widget.sendSelection();
        } else if (sel == OS.sel_sendDoubleSelection) {
            widget.sendDoubleSelection();
        } else if (sel == OS.sel_sendVerticalSelection) {
            widget.sendVerticalSelection();
        } else if (sel == OS.sel_sendHorizontalSelection) {
            widget.sendHorizontalSelection();
        } else if (sel == OS.sel_sendSearchSelection) {
            widget.sendSearchSelection();
        } else if (sel == OS.sel_sendCancelSelection) {
            widget.sendCancelSelection();
        } else {
            if (sel == OS.sel_acceptsFirstResponder) {
                return widget.acceptsFirstResponder(id2, sel) ? 1 : 0;
            }
            if (sel == OS.sel_becomeFirstResponder) {
                return widget.becomeFirstResponder(id2, sel) ? 1 : 0;
            }
            if (sel == OS.sel_resignFirstResponder) {
                return widget.resignFirstResponder(id2, sel) ? 1 : 0;
            }
            if (sel == OS.sel_isOpaque) {
                return widget.isOpaque(id2, sel) ? 1 : 0;
            }
            if (sel == OS.sel_isFlipped) {
                return widget.isFlipped(id2, sel) ? 1 : 0;
            }
            if (sel == OS.sel_canBecomeKeyView) {
                return widget.canBecomeKeyView(id2, sel) ? 1 : 0;
            }
            if (sel == OS.sel_becomeKeyWindow) {
                widget.becomeKeyWindow(id2, sel);
            } else if (sel != OS.sel_unmarkText) {
                if (sel == OS.sel_validAttributesForMarkedText) {
                    return widget.validAttributesForMarkedText(id2, sel);
                }
                if (sel == OS.sel_markedRange) {
                    NSRange range = widget.markedRange(id2, sel);
                    int result = OS.malloc(NSRange.sizeof);
                    OS.memmove(result, range, NSRange.sizeof);
                    return result;
                }
                if (sel == OS.sel_selectedRange) {
                    NSRange range = widget.selectedRange(id2, sel);
                    int result = OS.malloc(NSRange.sizeof);
                    OS.memmove(result, range, NSRange.sizeof);
                    return result;
                }
                if (sel == OS.sel_cellSize) {
                    NSSize size = widget.cellSize(id2, sel);
                    int result = OS.malloc(NSSize.sizeof);
                    OS.memmove(result, size, NSSize.sizeof);
                    return result;
                }
                if (sel == OS.sel_hasMarkedText) {
                    return widget.hasMarkedText(id2, sel) ? 1 : 0;
                }
                if (sel == OS.sel_canBecomeKeyWindow) {
                    return widget.canBecomeKeyWindow(id2, sel) ? 1 : 0;
                }
                if (sel == OS.sel_accessibilityActionNames) {
                    return widget.accessibilityActionNames(id2, sel);
                }
                if (sel == OS.sel_accessibilityAttributeNames) {
                    return widget.accessibilityAttributeNames(id2, sel);
                }
                if (sel == OS.sel_accessibilityParameterizedAttributeNames) {
                    return widget.accessibilityParameterizedAttributeNames(id2, sel);
                }
                if (sel == OS.sel_accessibilityFocusedUIElement) {
                    return widget.accessibilityFocusedUIElement(id2, sel);
                }
                if (sel == OS.sel_accessibilityIsIgnored) {
                    return widget.accessibilityIsIgnored(id2, sel) ? 1 : 0;
                }
                if (sel == OS.sel_nextState) {
                    return widget.nextState(id2, sel);
                }
                if (sel == OS.sel_resetCursorRects) {
                    widget.resetCursorRects(id2, sel);
                } else if (sel == OS.sel_updateTrackingAreas) {
                    widget.updateTrackingAreas(id2, sel);
                } else if (sel == OS.sel_viewDidMoveToWindow) {
                    widget.viewDidMoveToWindow(id2, sel);
                } else if (sel == OS.sel_image) {
                    return widget.image(id2, sel);
                }
            }
        }
        return 0;
    }

    static int windowProc(int id2, int sel, int arg0) {
        if (!NSThread.isMainThread() && sel == OS.sel_drawRect_) {
            return 0;
        }
        if (sel == OS.sel_timerProc_) {
            Display display = Display.getCurrent();
            if (display == null) {
                return 0;
            }
            return display.timerProc(id2, sel, arg0);
        }
        if (sel == OS.sel_systemSettingsChanged_) {
            Display display = Display.getCurrent();
            if (display == null) {
                return 0;
            }
            display.runSettings = true;
            return 0;
        }
        Widget widget = Display.GetWidget(id2);
        if (widget == null) {
            return 0;
        }
        if (sel == OS.sel_windowWillClose_) {
            widget.windowWillClose(id2, sel, arg0);
        } else if (sel == OS.sel_drawRect_) {
            NSRect rect = new NSRect();
            OS.memmove(rect, arg0, NSRect.sizeof);
            widget.drawRect(id2, sel, rect);
        } else if (sel == OS.sel__drawThemeProgressArea_) {
            widget._drawThemeProgressArea(id2, sel, arg0);
        } else if (sel == OS.sel_setFrameOrigin_) {
            NSPoint point = new NSPoint();
            OS.memmove(point, arg0, NSPoint.sizeof);
            widget.setFrameOrigin(id2, sel, point);
        } else if (sel == OS.sel_setFrameSize_) {
            NSSize size = new NSSize();
            OS.memmove(size, arg0, NSSize.sizeof);
            widget.setFrameSize(id2, sel, size);
        } else {
            if (sel == OS.sel_hitTest_) {
                NSPoint point = new NSPoint();
                OS.memmove(point, arg0, NSPoint.sizeof);
                return widget.hitTest(id2, sel, point);
            }
            if (sel == OS.sel_windowShouldClose_) {
                return widget.windowShouldClose(id2, sel, arg0) ? 1 : 0;
            }
            if (sel == OS.sel_mouseDown_) {
                widget.mouseDown(id2, sel, arg0);
            } else if (sel == OS.sel_keyDown_) {
                widget.keyDown(id2, sel, arg0);
            } else if (sel == OS.sel_keyUp_) {
                widget.keyUp(id2, sel, arg0);
            } else if (sel == OS.sel_flagsChanged_) {
                widget.flagsChanged(id2, sel, arg0);
            } else if (sel == OS.sel_mouseUp_) {
                widget.mouseUp(id2, sel, arg0);
            } else if (sel == OS.sel_rightMouseDown_) {
                widget.rightMouseDown(id2, sel, arg0);
            } else if (sel == OS.sel_rightMouseDragged_) {
                widget.rightMouseDragged(id2, sel, arg0);
            } else if (sel == OS.sel_rightMouseUp_) {
                widget.rightMouseUp(id2, sel, arg0);
            } else if (sel == OS.sel_otherMouseDown_) {
                widget.otherMouseDown(id2, sel, arg0);
            } else if (sel == OS.sel_otherMouseUp_) {
                widget.otherMouseUp(id2, sel, arg0);
            } else if (sel == OS.sel_otherMouseDragged_) {
                widget.otherMouseDragged(id2, sel, arg0);
            } else if (sel == OS.sel_mouseMoved_) {
                widget.mouseMoved(id2, sel, arg0);
            } else if (sel == OS.sel_mouseDragged_) {
                widget.mouseDragged(id2, sel, arg0);
            } else if (sel == OS.sel_mouseEntered_) {
                widget.mouseEntered(id2, sel, arg0);
            } else if (sel == OS.sel_mouseExited_) {
                widget.mouseExited(id2, sel, arg0);
            } else if (sel == OS.sel_cursorUpdate_) {
                widget.cursorUpdate(id2, sel, arg0);
            } else {
                if (sel == OS.sel_menuForEvent_) {
                    return widget.menuForEvent(id2, sel, arg0);
                }
                if (sel == OS.sel_noResponderFor_) {
                    widget.noResponderFor(id2, sel, arg0);
                } else {
                    if (sel == OS.sel_shouldDelayWindowOrderingForEvent_) {
                        return widget.shouldDelayWindowOrderingForEvent(id2, sel, arg0) ? 1 : 0;
                    }
                    if (sel == OS.sel_acceptsFirstMouse_) {
                        return widget.acceptsFirstMouse(id2, sel, arg0) ? 1 : 0;
                    }
                    if (sel == OS.sel_numberOfRowsInTableView_) {
                        return widget.numberOfRowsInTableView(id2, sel, arg0);
                    }
                    if (sel == OS.sel_tableViewSelectionDidChange_) {
                        widget.tableViewSelectionDidChange(id2, sel, arg0);
                    } else if (sel == OS.sel_windowDidResignKey_) {
                        widget.windowDidResignKey(id2, sel, arg0);
                    } else if (sel == OS.sel_windowDidBecomeKey_) {
                        widget.windowDidBecomeKey(id2, sel, arg0);
                    } else if (sel == OS.sel_windowDidResize_) {
                        widget.windowDidResize(id2, sel, arg0);
                    } else if (sel == OS.sel_windowDidMove_) {
                        widget.windowDidMove(id2, sel, arg0);
                    } else if (sel == OS.sel_menuWillOpen_) {
                        widget.menuWillOpen(id2, sel, arg0);
                    } else if (sel == OS.sel_menuDidClose_) {
                        widget.menuDidClose(id2, sel, arg0);
                    } else if (sel == OS.sel_menuNeedsUpdate_) {
                        widget.menuNeedsUpdate(id2, sel, arg0);
                    } else if (sel == OS.sel_outlineViewSelectionDidChange_) {
                        widget.outlineViewSelectionDidChange(id2, sel, arg0);
                    } else if (sel == OS.sel_sendEvent_) {
                        widget.windowSendEvent(id2, sel, arg0);
                    } else if (sel == OS.sel_helpRequested_) {
                        widget.helpRequested(id2, sel, arg0);
                    } else if (sel == OS.sel_scrollWheel_) {
                        widget.scrollWheel(id2, sel, arg0);
                    } else if (sel == OS.sel_pageDown_) {
                        widget.pageDown(id2, sel, arg0);
                    } else if (sel == OS.sel_pageUp_) {
                        widget.pageUp(id2, sel, arg0);
                    } else if (sel == OS.sel_textViewDidChangeSelection_) {
                        widget.textViewDidChangeSelection(id2, sel, arg0);
                    } else if (sel == OS.sel_textDidChange_) {
                        widget.textDidChange(id2, sel, arg0);
                    } else if (sel == OS.sel_textDidEndEditing_) {
                        widget.textDidEndEditing(id2, sel, arg0);
                    } else {
                        if (sel == OS.sel_attributedSubstringFromRange_) {
                            return widget.attributedSubstringFromRange(id2, sel, arg0);
                        }
                        if (sel == OS.sel_characterIndexForPoint_) {
                            return widget.characterIndexForPoint(id2, sel, arg0);
                        }
                        if (sel == OS.sel_firstRectForCharacterRange_) {
                            NSRect rect = widget.firstRectForCharacterRange(id2, sel, arg0);
                            int result = OS.malloc(NSRect.sizeof);
                            OS.memmove(result, rect, NSRect.sizeof);
                            return result;
                        }
                        if (sel == OS.sel_insertText_) {
                            return widget.insertText(id2, sel, arg0) ? 1 : 0;
                        }
                        if (sel == OS.sel_doCommandBySelector_) {
                            widget.doCommandBySelector(id2, sel, arg0);
                        } else if (sel == OS.sel_highlightSelectionInClipRect_) {
                            widget.highlightSelectionInClipRect(id2, sel, arg0);
                        } else if (sel == OS.sel_reflectScrolledClipView_) {
                            widget.reflectScrolledClipView(id2, sel, arg0);
                        } else {
                            if (sel == OS.sel_accessibilityHitTest_) {
                                NSPoint point = new NSPoint();
                                OS.memmove(point, arg0, NSPoint.sizeof);
                                return widget.accessibilityHitTest(id2, sel, point);
                            }
                            if (sel == OS.sel_accessibilityAttributeValue_) {
                                return widget.accessibilityAttributeValue(id2, sel, arg0);
                            }
                            if (sel == OS.sel_accessibilityPerformAction_) {
                                widget.accessibilityPerformAction(id2, sel, arg0);
                            } else if (sel == OS.sel_accessibilityActionDescription_) {
                                widget.accessibilityActionDescription(id2, sel, arg0);
                            } else {
                                if (sel == OS.sel_makeFirstResponder_) {
                                    return widget.makeFirstResponder(id2, sel, arg0) ? 1 : 0;
                                }
                                if (sel == OS.sel_tableViewColumnDidMove_) {
                                    widget.tableViewColumnDidMove(id2, sel, arg0);
                                } else if (sel == OS.sel_tableViewColumnDidResize_) {
                                    widget.tableViewColumnDidResize(id2, sel, arg0);
                                } else if (sel == OS.sel_outlineViewColumnDidMove_) {
                                    widget.outlineViewColumnDidMove(id2, sel, arg0);
                                } else if (sel == OS.sel_outlineViewColumnDidResize_) {
                                    widget.outlineViewColumnDidResize(id2, sel, arg0);
                                } else if (sel == OS.sel_setNeedsDisplay_) {
                                    widget.setNeedsDisplay(id2, sel, arg0 != 0);
                                } else if (sel == OS.sel_setNeedsDisplayInRect_) {
                                    widget.setNeedsDisplayInRect(id2, sel, arg0);
                                } else if (sel == OS.sel_setImage_) {
                                    widget.setImage(id2, sel, arg0);
                                } else {
                                    if (sel == OS.sel_imageRectForBounds_) {
                                        NSRect rect = new NSRect();
                                        OS.memmove(rect, arg0, NSRect.sizeof);
                                        rect = widget.imageRectForBounds(id2, sel, rect);
                                        int result = OS.malloc(NSRect.sizeof);
                                        OS.memmove(result, rect, NSRect.sizeof);
                                        return result;
                                    }
                                    if (sel == OS.sel_titleRectForBounds_) {
                                        NSRect rect = new NSRect();
                                        OS.memmove(rect, arg0, NSRect.sizeof);
                                        rect = widget.titleRectForBounds(id2, sel, rect);
                                        int result = OS.malloc(NSRect.sizeof);
                                        OS.memmove(result, rect, NSRect.sizeof);
                                        return result;
                                    }
                                    if (sel == OS.sel_setObjectValue_) {
                                        widget.setObjectValue(id2, sel, arg0);
                                    } else if (sel == OS.sel_updateOpenGLContext_) {
                                        widget.updateOpenGLContext(id2, sel, arg0);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return 0;
    }

    static int windowProc(int id2, int sel, int arg0, int arg1) {
        Widget widget = Display.GetWidget(id2);
        if (widget == null) {
            return 0;
        }
        if (sel == OS.sel_tabView_willSelectTabViewItem_) {
            widget.tabView_willSelectTabViewItem(id2, sel, arg0, arg1);
        } else if (sel == OS.sel_tabView_didSelectTabViewItem_) {
            widget.tabView_didSelectTabViewItem(id2, sel, arg0, arg1);
        } else {
            if (sel == OS.sel_outlineView_isItemExpandable_) {
                return widget.outlineView_isItemExpandable(id2, sel, arg0, arg1) ? 1 : 0;
            }
            if (sel == OS.sel_outlineView_numberOfChildrenOfItem_) {
                return widget.outlineView_numberOfChildrenOfItem(id2, sel, arg0, arg1);
            }
            if (sel == OS.sel_menu_willHighlightItem_) {
                widget.menu_willHighlightItem(id2, sel, arg0, arg1);
            } else if (sel == OS.sel_setMarkedText_selectedRange_) {
                widget.setMarkedText_selectedRange(id2, sel, arg0, arg1);
            } else if (sel == OS.sel_drawInteriorWithFrame_inView_) {
                NSRect rect = new NSRect();
                OS.memmove(rect, arg0, NSRect.sizeof);
                widget.drawInteriorWithFrame_inView(id2, sel, rect, arg1);
            } else if (sel == OS.sel_drawWithExpansionFrame_inView_) {
                NSRect rect = new NSRect();
                OS.memmove(rect, arg0, NSRect.sizeof);
                widget.drawWithExpansionFrame_inView(id2, sel, rect, arg1);
            } else {
                if (sel == OS.sel_accessibilityAttributeValue_forParameter_) {
                    return widget.accessibilityAttributeValue_forParameter(id2, sel, arg0, arg1);
                }
                if (sel == OS.sel_tableView_didClickTableColumn_) {
                    widget.tableView_didClickTableColumn(id2, sel, arg0, arg1);
                } else if (sel == OS.sel_outlineView_didClickTableColumn_) {
                    widget.outlineView_didClickTableColumn(id2, sel, arg0, arg1);
                } else {
                    if (sel == OS.sel_shouldChangeTextInRange_replacementString_) {
                        return widget.shouldChangeTextInRange_replacementString(id2, sel, arg0, arg1) ? 1 : 0;
                    }
                    if (sel == OS.sel_canDragRowsWithIndexes_atPoint_) {
                        return widget.canDragRowsWithIndexes_atPoint(id2, sel, arg0, arg1) ? 1 : 0;
                    }
                    if (sel == OS.sel_expandItem_expandChildren_) {
                        widget.expandItem_expandChildren(id2, sel, arg0, arg1 != 0);
                    } else if (sel == OS.sel_collapseItem_collapseChildren_) {
                        widget.collapseItem_collapseChildren(id2, sel, arg0, arg1 != 0);
                    } else if (sel == OS.sel_expansionFrameWithFrame_inView_) {
                        NSRect rect = new NSRect();
                        OS.memmove(rect, arg0, NSRect.sizeof);
                        rect = widget.expansionFrameWithFrame_inView(id2, sel, rect, arg1);
                        int result = OS.malloc(NSRect.sizeof);
                        OS.memmove(result, rect, NSRect.sizeof);
                        return result;
                    }
                }
            }
        }
        return 0;
    }

    static int windowProc(int id2, int sel, int arg0, int arg1, int arg2) {
        Widget widget = Display.GetWidget(id2);
        if (widget == null) {
            return 0;
        }
        if (sel == OS.sel_tableView_objectValueForTableColumn_row_) {
            return widget.tableView_objectValueForTableColumn_row(id2, sel, arg0, arg1, arg2);
        }
        if (sel == OS.sel_tableView_shouldEditTableColumn_row_) {
            return widget.tableView_shouldEditTableColumn_row(id2, sel, arg0, arg1, arg2) ? 1 : 0;
        }
        if (sel == OS.sel_textView_clickedOnLink_atIndex_) {
            return widget.textView_clickOnLink_atIndex(id2, sel, arg0, arg1, arg2) ? 1 : 0;
        }
        if (sel == OS.sel_outlineView_child_ofItem_) {
            return widget.outlineView_child_ofItem(id2, sel, arg0, arg1, arg2);
        }
        if (sel == OS.sel_outlineView_objectValueForTableColumn_byItem_) {
            return widget.outlineView_objectValueForTableColumn_byItem(id2, sel, arg0, arg1, arg2);
        }
        if (sel == OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_) {
            NSRange range = widget.textView_willChangeSelectionFromCharacterRange_toCharacterRange(id2, sel, arg0, arg1, arg2);
            int result = OS.malloc(NSRange.sizeof);
            OS.memmove(result, range, NSRange.sizeof);
            return result;
        }
        if (sel == OS.sel_dragSelectionWithEvent_offset_slideBack_) {
            NSSize offset = new NSSize();
            OS.memmove(offset, arg0, NSSize.sizeof);
            return widget.dragSelectionWithEvent(id2, sel, arg0, arg1, arg2) ? 1 : 0;
        }
        if (sel == OS.sel_drawImage_withFrame_inView_) {
            NSRect rect = new NSRect();
            OS.memmove(rect, arg1, NSRect.sizeof);
            widget.drawImageWithFrameInView(id2, sel, arg0, rect, arg2);
        } else {
            if (sel == OS.sel_hitTestForEvent_inRect_ofView_) {
                NSRect rect = new NSRect();
                OS.memmove(rect, arg1, NSRect.sizeof);
                return widget.hitTestForEvent(id2, sel, arg0, rect, arg2);
            }
            if (sel == OS.sel_tableView_writeRowsWithIndexes_toPasteboard_) {
                return widget.tableView_writeRowsWithIndexes_toPasteboard(id2, sel, arg0, arg1, arg2) ? 1 : 0;
            }
            if (sel == OS.sel_outlineView_writeItems_toPasteboard_) {
                return widget.outlineView_writeItems_toPasteboard(id2, sel, arg0, arg1, arg2) ? 1 : 0;
            }
        }
        return 0;
    }

    static int windowProc(int id2, int sel, int arg0, int arg1, int arg2, int arg3) {
        Widget widget = Display.GetWidget(id2);
        if (widget == null) {
            return 0;
        }
        if (sel == OS.sel_tableView_willDisplayCell_forTableColumn_row_) {
            widget.tableView_willDisplayCell_forTableColumn_row(id2, sel, arg0, arg1, arg2, arg3);
        } else if (sel == OS.sel_outlineView_willDisplayCell_forTableColumn_item_) {
            widget.outlineView_willDisplayCell_forTableColumn_item(id2, sel, arg0, arg1, arg2, arg3);
        } else if (sel == OS.sel_outlineView_setObjectValue_forTableColumn_byItem_) {
            widget.outlineView_setObjectValue_forTableColumn_byItem(id2, sel, arg0, arg1, arg2, arg3);
        } else if (sel == OS.sel_tableView_setObjectValue_forTableColumn_row_) {
            widget.tableView_setObjectValue_forTableColumn_row(id2, sel, arg0, arg1, arg2, arg3);
        } else if (sel == OS.sel_view_stringForToolTip_point_userData_) {
            return widget.view_stringForToolTip_point_userData(id2, sel, arg0, arg1, arg2, arg3);
        }
        return 0;
    }
}

