/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSOutlineView;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTTreeItem;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeItem
extends Item {
    Tree parent;
    TreeItem parentItem;
    TreeItem[] items;
    int itemCount;
    String[] strings;
    Image[] images;
    boolean checked;
    boolean grayed;
    boolean cached;
    boolean expanded;
    Color foreground;
    Color background;
    Color[] cellForeground;
    Color[] cellBackground;
    Font font;
    Font[] cellFont;
    int width = -1;
    public SWTTreeItem handle;

    public TreeItem(Tree parent, int style) {
        this(TreeItem.checkNull(parent), null, style, -1, true);
    }

    public TreeItem(Tree parent, int style, int index) {
        this(TreeItem.checkNull(parent), null, style, TreeItem.checkIndex(index), true);
    }

    public TreeItem(TreeItem parentItem, int style) {
        this(TreeItem.checkNull((TreeItem)parentItem).parent, parentItem, style, -1, true);
    }

    public TreeItem(TreeItem parentItem, int style, int index) {
        this(TreeItem.checkNull((TreeItem)parentItem).parent, parentItem, style, TreeItem.checkIndex(index), true);
    }

    TreeItem(Tree parent, TreeItem parentItem, int style, int index, boolean create) {
        super(parent, style);
        this.parent = parent;
        this.parentItem = parentItem;
        if (create) {
            parent.createItem(this, parentItem, index);
        } else {
            this.handle = (SWTTreeItem)new SWTTreeItem().alloc().init();
            this.createJNIRef();
            this.register();
            this.items = new TreeItem[4];
        }
    }

    static TreeItem checkNull(TreeItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    static Tree checkNull(Tree parent) {
        if (parent == null) {
            SWT.error(4);
        }
        return parent;
    }

    static int checkIndex(int index) {
        if (index < 0) {
            SWT.error(6);
        }
        return index;
    }

    int calculateWidth(int index, GC gc) {
        String text;
        if (index == 0 && this.width != -1) {
            return this.width;
        }
        Font font = null;
        if (this.cellFont != null) {
            font = this.cellFont[index];
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.parent.font;
        }
        if (font == null) {
            font = this.parent.defaultFont();
        }
        String string = index == 0 ? this.text : (text = this.strings == null ? "" : this.strings[index]);
        Image image = index == 0 ? this.image : (this.images == null ? null : this.images[index]);
        NSTextFieldCell cell = this.parent.dataCell;
        if (font.extraTraits != 0) {
            NSAttributedString attribStr = this.parent.createString(text, font, null, 0, true, false);
            cell.setAttributedStringValue(attribStr);
            attribStr.release();
        } else {
            cell.setFont(font.handle);
            cell.setTitle(NSString.stringWith(text != null ? text : ""));
        }
        objc_super super_struct = new objc_super();
        super_struct.receiver = cell.id;
        super_struct.super_class = OS.objc_msgSend(cell.id, OS.sel_superclass);
        NSSize size = new NSSize();
        OS.objc_msgSendSuper_stret(size, super_struct, OS.sel_cellSize);
        if (image != null) {
            size.width += (float)(this.parent.imageBounds.width + 3);
        }
        int width = (int)Math.ceil(size.width);
        boolean sendMeasure = true;
        if ((this.parent.style & 0x10000000) != 0) {
            sendMeasure = this.cached;
        }
        if (sendMeasure && this.parent.hooks(41)) {
            gc.setFont(font);
            Event event = new Event();
            event.item = this;
            event.index = index;
            event.gc = gc;
            NSTableView widget = (NSTableView)this.parent.view;
            int height = (int)widget.rowHeight();
            event.width = width;
            event.height = height;
            this.parent.sendEvent(41, event);
            if (height < event.height) {
                widget.setRowHeight(event.height);
                widget.setNeedsDisplay(true);
            }
            width = event.width;
        }
        if (index == 0) {
            NSOutlineView outlineView = (NSOutlineView)this.parent.view;
            this.width = width = (int)((float)width + outlineView.indentationPerLevel() * (float)(1 + outlineView.levelForItem(this.handle)));
        }
        return width;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.cached = false;
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        this.grayed = false;
        this.checked = false;
        this.background = null;
        this.foreground = null;
        this.cellBackground = null;
        this.cellForeground = null;
        this.font = null;
        this.cellFont = null;
        this.width = -1;
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            SWT.error(6);
        }
        this.parent.clear(this, index, all);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.parent.clearAll(this, all);
    }

    void clearSelection() {
        NSOutlineView widget = (NSOutlineView)this.parent.view;
        int row = widget.rowForItem(this.handle);
        if (widget.isRowSelected(row)) {
            widget.deselectRow(row);
        }
        if (this.items != null && this.getExpanded()) {
            int i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.clearSelection();
                }
                ++i;
            }
        }
    }

    NSObject createString(int index) {
        String text = index == 0 ? this.text : (this.strings == null ? "" : this.strings[index]);
        return NSString.stringWith(text != null ? text : "");
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.background != null ? this.background : this.parent.getBackground();
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getBackground();
        }
        if (this.cellBackground == null || this.cellBackground[index] == null) {
            return this.getBackground();
        }
        return this.cellBackground[index];
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        this.parent.checkItems();
        NSOutlineView outlineView = (NSOutlineView)this.parent.view;
        NSRect rect = outlineView.rectOfRow(outlineView.rowForItem(this.handle));
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    public Rectangle getBounds(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index < 0 || index >= Math.max(1, this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        this.parent.checkItems();
        NSOutlineView outlineView = (NSOutlineView)this.parent.view;
        if (this.parent.columnCount == 0) {
            index = (this.parent.style & 0x20) != 0 ? 1 : 0;
        } else {
            TreeColumn column = this.parent.getColumn(index);
            index = this.parent.indexOf(column.nsColumn);
        }
        NSRect rect = outlineView.frameOfCellAtColumn(index, outlineView.rowForItem(this.handle));
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[index] == null) {
            return this.getFont();
        }
        return this.cellFont[index];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.foreground != null ? this.foreground : this.parent.getForeground();
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getForeground();
        }
        if (this.cellForeground == null || this.cellForeground[index] == null) {
            return this.getForeground();
        }
        return this.cellForeground[index];
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index == 0) {
            return this.getImage();
        }
        if (this.images != null && index >= 0 && index < this.images.length) {
            return this.images[index];
        }
        return null;
    }

    public Rectangle getImageBounds(int index) {
        Image image;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index < 0 || index >= Math.max(1, this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        this.parent.checkItems();
        NSOutlineView outlineView = (NSOutlineView)this.parent.view;
        Image image2 = index == 0 ? this.image : (image = this.images != null ? this.images[index] : null);
        if (this.parent.columnCount == 0) {
            index = (this.parent.style & 0x20) != 0 ? 1 : 0;
        } else {
            TreeColumn column = this.parent.getColumn(index);
            index = this.parent.indexOf(column.nsColumn);
        }
        NSRect rect = outlineView.frameOfCellAtColumn(index, outlineView.rowForItem(this.handle));
        rect.x += 3.0f;
        rect.width = image != null ? (float)this.parent.imageBounds.width : 0.0f;
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        if (index < 0) {
            this.error(6);
        }
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index >= this.itemCount) {
            this.error(6);
        }
        return this.parent._getItem(this, index, true);
    }

    public int getItemCount() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.itemCount;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        TreeItem[] result = new TreeItem[this.itemCount];
        int i = 0;
        while (i < this.itemCount) {
            result[i] = this.parent._getItem(this, i, true);
            ++i;
        }
        return result;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index == 0) {
            return this.getText();
        }
        if (this.strings != null && index >= 0 && index < this.strings.length) {
            String string = this.strings[index];
            return string != null ? string : "";
        }
        return "";
    }

    public Rectangle getTextBounds(int index) {
        Image image;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index < 0 || index >= Math.max(1, this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        this.parent.checkItems();
        NSOutlineView outlineView = (NSOutlineView)this.parent.view;
        Image image2 = index == 0 ? this.image : (image = this.images != null ? this.images[index] : null);
        if (this.parent.columnCount == 0) {
            index = (this.parent.style & 0x20) != 0 ? 1 : 0;
        } else {
            TreeColumn column = this.parent.getColumn(index);
            index = this.parent.indexOf(column.nsColumn);
        }
        NSRect rect = outlineView.frameOfCellAtColumn(index, outlineView.rowForItem(this.handle));
        rect.x += 2.0f;
        rect.width -= 2.0f;
        if (image != null) {
            int offset = this.parent.imageBounds.width + 3;
            rect.x += (float)offset;
            rect.width -= (float)offset;
        }
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parentItem != this) {
            return -1;
        }
        int i = 0;
        while (i < this.itemCount) {
            if (item == this.items[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void redraw(int columnIndex) {
        NSRect rect;
        if (this.parent.ignoreRedraw || !this.isDrawing()) {
            return;
        }
        NSOutlineView outlineView = (NSOutlineView)this.parent.view;
        if (columnIndex == -1 || this.parent.hooks(41) || this.parent.hooks(40) || this.parent.hooks(42)) {
            rect = outlineView.rectOfRow(outlineView.rowForItem(this.handle));
        } else {
            int index;
            if (this.parent.columnCount == 0) {
                index = (this.parent.style & 0x20) != 0 ? 1 : 0;
            } else if (columnIndex >= 0 && columnIndex < this.parent.columnCount) {
                index = this.parent.indexOf(this.parent.columns[columnIndex].nsColumn);
            } else {
                return;
            }
            rect = outlineView.frameOfCellAtColumn(index, outlineView.rowForItem(this.handle));
        }
        outlineView.setNeedsDisplayInRect(rect);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
    }

    void release(boolean destroy) {
        if (destroy) {
            this.clearSelection();
        }
        super.release(destroy);
    }

    void releaseChildren(boolean destroy) {
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        this.items = null;
        this.itemCount = 0;
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.handle != null) {
            this.handle.release();
        }
        this.handle = null;
        this.parentItem = null;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.strings = null;
        this.images = null;
        this.foreground = null;
        this.background = null;
        this.font = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
    }

    public void removeAll() {
        this.checkWidget();
        this.parent.setItemCount(0);
    }

    void sendExpand(boolean expand, boolean recurse) {
        if (this.itemCount == 0) {
            return;
        }
        if (this.expanded != expand) {
            Event event = new Event();
            event.item = this;
            this.parent.sendEvent(expand ? 17 : 18, event);
            if (this.isDisposed()) {
                return;
            }
            this.expanded = expand;
        }
        if (recurse) {
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null) {
                    this.items[i].sendExpand(expand, recurse);
                }
                ++i;
            }
        }
    }

    public void setBackground(Color color) {
        Color oldColor;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((oldColor = this.background) == color) {
            return;
        }
        this.background = color;
        if (oldColor != null && oldColor.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(-1);
    }

    public void setBackground(int index, Color color) {
        Color oldColor;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellBackground == null) {
            if (color == null) {
                return;
            }
            this.cellBackground = new Color[count];
        }
        if ((oldColor = this.cellBackground[index]) == color) {
            return;
        }
        this.cellBackground[index] = color;
        if (oldColor != null && oldColor.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(index);
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == checked) {
            return;
        }
        this.checked = checked;
        this.cached = true;
        this.redraw(-1);
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        if (this.itemCount == 0 || expanded == this.getExpanded()) {
            return;
        }
        this.parent.checkItems();
        this.parent.ignoreExpand = true;
        this.expanded = expanded;
        if (expanded) {
            ((NSOutlineView)this.parent.view).expandItem(this.handle);
        } else {
            ((NSOutlineView)this.parent.view).collapseItem(this.handle);
        }
        this.parent.ignoreExpand = false;
        this.cached = true;
        if (!expanded) {
            this.parent.setScrollWidth();
        }
    }

    public void setFont(Font font) {
        Font oldFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((oldFont = this.font) == font) {
            return;
        }
        this.font = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        this.width = -1;
        this.cached = true;
        this.redraw(-1);
    }

    public void setFont(int index, Font font) {
        Font oldFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[count];
        }
        if ((oldFont = this.cellFont[index]) == font) {
            return;
        }
        this.cellFont[index] = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        this.width = -1;
        this.cached = true;
        this.redraw(index);
    }

    public void setForeground(Color color) {
        Color oldColor;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((oldColor = this.foreground) == color) {
            return;
        }
        this.foreground = color;
        if (oldColor != null && oldColor.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(-1);
    }

    public void setForeground(int index, Color color) {
        Color oldColor;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellForeground == null) {
            if (color == null) {
                return;
            }
            this.cellForeground = new Color[count];
        }
        if ((oldColor = this.cellForeground[index]) == color) {
            return;
        }
        this.cellForeground[index] = color;
        if (oldColor != null && oldColor.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(index);
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == grayed) {
            return;
        }
        this.grayed = grayed;
        this.cached = true;
        this.redraw(-1);
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (this.parent.imageBounds == null && image != null) {
            this.parent.setItemHeight(image, null, false);
        }
        if (index == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            this.width = -1;
            super.setImage(image);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index >= 0 && index < count) {
            if (this.images == null) {
                this.images = new Image[count];
            }
            if (image != null && image.type == 1 && image.equals(this.images[index])) {
                return;
            }
            this.images[index] = image;
        }
        this.cached = true;
        if (index == 0) {
            this.parent.setScrollWidth(this);
        }
        if (index >= 0 && index < count) {
            this.redraw(index);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setItemCount(int count) {
        this.checkWidget();
        count = Math.max(0, count);
        this.parent.setItemCount(this, count);
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index == 0) {
            if (string.equals(this.text)) {
                return;
            }
            this.width = -1;
            super.setText(string);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index >= 0 && index < count) {
            if (this.strings == null) {
                this.strings = new String[count];
            }
            if (string.equals(this.strings[index])) {
                return;
            }
            this.strings[index] = string;
        }
        this.cached = true;
        if (index == 0) {
            this.parent.setScrollWidth(this);
        }
        if (index >= 0 && index < count) {
            this.redraw(index);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    void updateExpanded() {
        if (this.itemCount == 0) {
            return;
        }
        NSOutlineView outlineView = (NSOutlineView)this.parent.view;
        if (this.expanded != outlineView.isItemExpanded(this.handle)) {
            if (this.expanded) {
                outlineView.expandItem(this.handle);
            } else {
                outlineView.collapseItem(this.handle);
            }
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] != null) {
                this.items[i].updateExpanded();
            }
            ++i;
        }
    }
}

