/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.carbon.OS;

public class HTMLTransfer
extends ByteArrayTransfer {
    static HTMLTransfer _instance = new HTMLTransfer();
    static final String HTML = "HTML";
    static final int HTMLID = HTMLTransfer.registerType("HTML");

    HTMLTransfer() {
    }

    public static HTMLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkHTML(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[cArray.length * 2];
        OS.memmove(byArray, cArray, byArray.length);
        transferData.data = new byte[1][];
        transferData.data[0] = byArray;
        transferData.result = 0;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.data.length == 0 || transferData.data[0].length == 0) {
            return null;
        }
        byte[] byArray = transferData.data[0];
        char[] cArray = new char[(byArray.length + 1) / 2];
        OS.memmove(cArray, byArray, byArray.length);
        return new String(cArray);
    }

    protected int[] getTypeIds() {
        return new int[]{HTMLID};
    }

    protected String[] getTypeNames() {
        return new String[]{HTML};
    }

    boolean checkHTML(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkHTML(object);
    }
}

