/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 01-Jul-2004
 *
 */
package uk.ac.imperial.doc.kenya.builtIns;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import uk.ac.imperial.doc.kenya.types.IBuiltInMethod;
import uk.ac.imperial.doc.kenya.util.PackageReflection;

/**
 * @author ms02
 *  
 */
public class BuiltInMethodsLoader {

    private static Set<IBuiltInMethod> builtInMethods = null;

    private static final String builtInMethodsPackage = BuiltInMethodsLoader.class
            .getPackage().getName()
            + ".builtInMethods";

    public static Set<IBuiltInMethod> getBuiltInMethods() {
        if (builtInMethods == null) builtInMethods = loadBuiltInMethods();
        return builtInMethods;
    }

    private static synchronized Set<IBuiltInMethod> loadBuiltInMethods() {
        List<String> methodClasses = PackageReflection.getPackageClasses(builtInMethodsPackage);
                
        Set<IBuiltInMethod> builtInMethods = new HashSet<IBuiltInMethod>();
        for (String methodName : methodClasses)
    	{
	            IBuiltInMethodFactory bim = loadBuiltInMethod(methodName);
	            if (bim != null)
	            {
	                    builtInMethods.addAll(bim.buildMethods());
	            }
        }
       
        return builtInMethods;
    }

    private static IBuiltInMethodFactory loadBuiltInMethod(String name) {
        try {
            Class<?> loadedClass = Class.forName(builtInMethodsPackage + "."
                    + name, true, BuiltInMethodsLoader.class.getClassLoader());
            Class<?>[] interfaces = loadedClass.getInterfaces();

            boolean found = false;

            for (int idx = 0; idx < interfaces.length && !found; idx++)
                if (interfaces[idx].getName().equals(
                        IBuiltInMethodFactory.LOCATION)) found = true;

            if (!found) return null;

            IBuiltInMethodFactory m = (IBuiltInMethodFactory) loadedClass
                    .newInstance();

            return m;

        } catch (Exception e) {
            System.err.println("Unable to load class '" + name + "': "
                    + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        Set<IBuiltInMethod> methods = getBuiltInMethods();
        System.out.println("I got " + methods.size() + " methods.");
    }
}