/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 01-Jul-2004
 */
package uk.ac.imperial.doc.kenya.builtIns;

import java.util.List;

import uk.ac.imperial.doc.kenya.types.KType;

/**
 * This is implemented by all builtins which return some kind of String
 * represeting the Java code achieving the semantics of the built in method.
 * 
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public interface IGetMethodCode {

    /**
     * Returns the Java code corresponding to the built in method.
     * 
     * @param parameterNames
     *            A List of Strings[] containing the representation of the 
     * 			  parameters to be passed to the method: each of the elements of
     * 			  the arrays represent tokens that cannot be broken across newlines
     * @param parameterTypes
     *            A List of KTypes which are the types for the method.
     * @return String[] representing the Java code. Each element of the array is
     * 			a token which cannot be split across newlines. No code is allowed to
     * 			contain newlines
     */
    String[] getCode(List<String[]> parameterNames, List<KType> parameterTypes);
}