/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 16-Jul-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.builtIns.builtInMethods.io;

import java.util.List;
import java.util.Set;

import uk.ac.imperial.doc.kenya.builtIns.BuiltInMethod;
import uk.ac.imperial.doc.kenya.builtIns.IBuiltInMethodFactory;
import uk.ac.imperial.doc.kenya.builtIns.IGetMethodCode;
import uk.ac.imperial.doc.kenya.builtIns.SMIOContainer;
import uk.ac.imperial.doc.kenya.builtIns.common.AbstractBuiltInMethodFactory;
import uk.ac.imperial.doc.kenya.nio.IKenyaNIO;
import uk.ac.imperial.doc.kenya.stackMachine.IStackMachine;
import uk.ac.imperial.doc.kenya.stackMachine.types.AbstractAtomicClosure;
import uk.ac.imperial.doc.kenya.stackMachine.types.PrimitiveTypeFactory;
import uk.ac.imperial.doc.kenya.stackMachine.types.StringTypeFactory;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IInterpretedMethod;
import uk.ac.imperial.doc.kenya.types.IBuiltInMethod;
import uk.ac.imperial.doc.kenya.types.KType;

/**
 * @author toa02
 *  
 */
public class Readers extends AbstractBuiltInMethodFactory implements IBuiltInMethodFactory {

    private static final AbstractAtomicClosure readIntC = new AbstractAtomicClosure("readIntC") {

        public void execute(IStackMachine sm) {
            IKenyaNIO io = SMIOContainer.getIKenyaNIO(sm);
            io.setPrintStream(sm.getOut());
            sm.push(PrimitiveTypeFactory.createPrimitiveType(io.readInt()));
        }
    };

    private static final AbstractAtomicClosure readDoubleC = new AbstractAtomicClosure("readDoubleC") {

        public void execute(IStackMachine sm) {
            IKenyaNIO io = SMIOContainer.getIKenyaNIO(sm);
            io.setPrintStream(sm.getOut());
            sm.push(PrimitiveTypeFactory.createPrimitiveType(io.readDouble()));
        }
    };

    private static final AbstractAtomicClosure failedLastReadC = new AbstractAtomicClosure("failedLastReadC") {

        public void execute(IStackMachine sm) {
            IKenyaNIO io = SMIOContainer.getIKenyaNIO(sm);
            io.setPrintStream(sm.getOut());
            sm.push(PrimitiveTypeFactory.createPrimitiveType(io.failedLastRead()));
        }
    };

    private static final AbstractAtomicClosure readCharC = new AbstractAtomicClosure("readCharC") {

        public void execute(IStackMachine sm) {
            IKenyaNIO io = SMIOContainer.getIKenyaNIO(sm);
            io.setPrintStream(sm.getOut());
            sm.push(PrimitiveTypeFactory.createPrimitiveType(io.readChar()));
        }
    };

    private static final AbstractAtomicClosure readC = new AbstractAtomicClosure("readC") {

        public void execute(IStackMachine sm) {
            IKenyaNIO io = SMIOContainer.getIKenyaNIO(sm);
            io.setPrintStream(sm.getOut());
            sm.push(PrimitiveTypeFactory.createPrimitiveType(io.read()));
        }
    };

    private static final AbstractAtomicClosure readStringC = new AbstractAtomicClosure("readStringC") {

        public void execute(IStackMachine sm) {
            IKenyaNIO io = SMIOContainer.getIKenyaNIO(sm);
            io.setPrintStream(sm.getOut());
            sm.push(StringTypeFactory.createStringType(io.readString()));
        }
    };

    private static final AbstractAtomicClosure isEOFC = new AbstractAtomicClosure("isEOFC") {

        public void execute(IStackMachine sm) {
            IKenyaNIO io = SMIOContainer.getIKenyaNIO(sm);
            io.setPrintStream(sm.getOut());
            sm.push(PrimitiveTypeFactory.createPrimitiveType(io.isEOF()));
        }
    };

    /**
     * @see uk.ac.imperial.doc.kenya.builtIns.IBuiltInMethodFactory#getName()
     */
    public String getName() {
        return "Readers";
    }

    /**
     * @see uk.ac.imperial.doc.kenya.builtIns.IBuiltInMethodFactory#buildMethods()
     */
    public Set<IBuiltInMethod> buildMethods() {

    	Set<IBuiltInMethod> methods = getMethodList();
    	IInterpretedMethod method;
    	
    	method = getMethod("readInt", readIntC);
        methods.add(new BuiltInMethod(	"readInt",
						        		returnInt,
						        		paramVoid,
						        		new QuickCodeHook("readInt"),
						        		reservedClassesKenyaNIO,
						        		importSetKenyaNIO,
										method,
										null));

        method = getMethod("failedLastRead", failedLastReadC);
        methods.add(new BuiltInMethod(	"failedLastRead",
						        		returnBoolean,
						        		paramVoid,
						        		new QuickCodeHook("failedLastRead"),
						        		reservedClassesKenyaNIO,
						        		importSetKenyaNIO,
										method,
										null));

        method = getMethod("readDouble", readDoubleC);
        methods.add(new BuiltInMethod(	"readDouble",
						        		returnDouble,
						        		paramVoid,
						        		new QuickCodeHook("readDouble"),
						        		reservedClassesKenyaNIO,
						        		importSetKenyaNIO,
										method,
										null));

        method = getMethod("readChar", readCharC);
        methods.add(new BuiltInMethod(	"readChar",
						        		returnChar,
						        		paramVoid,
						        		new QuickCodeHook("readChar"),
						        		reservedClassesKenyaNIO,
						        		importSetKenyaNIO,
										method,
										null));

        method = getMethod("readString", readStringC);
        methods.add(new BuiltInMethod(	"readString",
						        		returnString,
						        		paramVoid,
						        		new QuickCodeHook("readString"),
						        		reservedClassesKenyaNIO,
						        		importSetKenyaNIO,
										method,
										null));

        method = getMethod("read", readC);
        methods.add(new BuiltInMethod(	"read",
						        		returnChar,
						        		paramVoid,
						        		new QuickCodeHook("read"),
						        		reservedClassesKenyaNIO,
						        		importSetKenyaNIO,
										method,
										null));


        method = getMethod("isEOF", isEOFC);
        methods.add(new BuiltInMethod(	"isEOF",
						        		returnBoolean,
						        		paramVoid,
						        		new QuickCodeHook("isEOF"),
						        		reservedClassesKenyaNIO,
						        		importSetKenyaNIO,
										method,
										null));

        return methods;
    }

}

class QuickCodeHook implements IGetMethodCode {

    private final String _name;

    public QuickCodeHook(String methodName) {
        _name = methodName;
    }

    /**
     * @see uk.ac.imperial.doc.kenya.builtIns.IGetMethodCode#getCode(java.util.List,
     *      java.util.List)
     */
    public String[] getCode(List<String[]> parameterNames, List<KType> parameterTypes) {
        return new String[] { "KenyaNIO.", "get().", _name, "()" };
    }

}

