/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 02-Jul-2004
 */
package uk.ac.imperial.doc.kenya.builtIns.builtInMethods.string;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import uk.ac.imperial.doc.kenya.builtIns.IBuiltInMethodFactory;
import uk.ac.imperial.doc.kenya.builtIns.IGetMethodCode;
import uk.ac.imperial.doc.kenya.builtIns.common.AbstractBuiltInString;
import uk.ac.imperial.doc.kenya.stackMachine.IStackMachine;
import uk.ac.imperial.doc.kenya.stackMachine.types.AbstractAtomicClosure;
import uk.ac.imperial.doc.kenya.stackMachine.types.StringTypeFactory;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IArrayType;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.ICharType;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IType;
import uk.ac.imperial.doc.kenya.types.IBuiltInMethod;
import uk.ac.imperial.doc.kenya.types.KType;

public class CharsToString extends AbstractBuiltInString implements IBuiltInMethodFactory
{

    private static final String name = "charsToString";

    public String getName() {
        return name;
    }
    
	private static Map<List<KType>, KType> signatures = new HashMap<List<KType>, KType>();
    static 
    { 	
    	signatures.put(paramArrayChar, returnString);    	
    }
        
    public Set<IBuiltInMethod> buildMethods()
    {
    	return getStringBuildMethods(name, execute, signatures, javaCode);
    }
    
    
    private static final IGetMethodCode javaCode = getStringIGetMethodCode("new String( ", " )");

    private static final AbstractAtomicClosure execute = new AbstractAtomicClosure(name) {

        public void execute(IStackMachine sm) {
            IArrayType arg = (IArrayType) sm.pop();
            IType[] charTypes = arg.getValue();
            char[] chars = new char[charTypes.length];
            for (int idx = 0; idx < charTypes.length;idx++) {
                chars[idx] = ((ICharType) charTypes[idx]).getValue().charValue();
            }
            String stringResult = new String(chars);
            sm.push(StringTypeFactory.createStringType(stringResult));
        }
    };

    public String toString() {
        return getName();
    }
}

