/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 02-Jul-2004
 */
package uk.ac.imperial.doc.kenya.builtIns.builtInMethods.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import uk.ac.imperial.doc.kenya.builtIns.BuiltInMethod;
import uk.ac.imperial.doc.kenya.builtIns.IBuiltInMethodFactory;
import uk.ac.imperial.doc.kenya.builtIns.IGetMethodCode;
import uk.ac.imperial.doc.kenya.builtIns.common.AbstractBuiltInMethodFactory;
import uk.ac.imperial.doc.kenya.stackMachine.IStackMachine;
import uk.ac.imperial.doc.kenya.stackMachine.types.AbstractAtomicClosure;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IArrayType;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IInterpretedMethod;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IType;
import uk.ac.imperial.doc.kenya.types.IBuiltInMethod;
import uk.ac.imperial.doc.kenya.types.KArrayType;
import uk.ac.imperial.doc.kenya.types.KParamType;
import uk.ac.imperial.doc.kenya.types.KType;

/**
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public class ArrayCopy extends AbstractBuiltInMethodFactory implements IBuiltInMethodFactory  {

    private static final String name = "arraycopy";

    private static final List<KType> templateParameters = new LinkedList<KType>();

    private static final Map<String,KParamType> templateMap = new HashMap<String,KParamType>();

    static {
    	KParamType arrayType = new KParamType("AT");
        templateParameters.add(new KArrayType(arrayType));
        templateParameters.add(new KArrayType(arrayType));
        templateMap.put("AT", arrayType);
    }

    public String getName() {
        return name;
    }

    private static final IGetMethodCode javaCode = new IGetMethodCode() {

        public String[] getCode(List<String[]> parameterValues, List<KType> parameterTypes) {
            if (parameterValues.size() != parameterTypes.size())
                    throw new RuntimeException("I was expecting "
                            + parameterTypes.size()
                            + " templateParameters and received "
                            + parameterValues.size() + " templateParameters");

            String[] lho = (String[]) parameterValues.get(0);
            String[] rho = (String[]) parameterValues.get(1);

            String[] lhsA = { "System.", "arraycopy", "(", " " };
            String[] midA = lho;
            String[] rhsA = { ",", " ", "0", ",", " " };

            String[] lhsGen = BuiltInMethod.concatenate(lhsA, midA, rhsA);
            String[] midGen = rho;
            String[] rhsGen = { ",", " ", "0", ",", " ", "Math.", "min", "(",
                    " " };

            String[] lhsOverall = BuiltInMethod.concatenate(lhsGen, midGen,
                    rhsGen);

            String[] lhsB = lho;
            String[] midB = { ".length", ",", " " };
            String[] rhsB = rho;

            String[] midOverall = BuiltInMethod.concatenate(lhsB, midB, rhsB);

            String[] rhsOverall = { ".length", " ", ")", " ", ")" };

            return BuiltInMethod
                    .concatenate(lhsOverall, midOverall, rhsOverall);
            //return( "System.arraycopy( " + lhs + ", 0, " + rhs + ", 0,
            // Math.min( " + lhs + ", " + rhs + ") )" );
        }
    };

    private static final AbstractAtomicClosure execute = new AbstractAtomicClosure(name) {

        public void execute(IStackMachine sm) {
            IType[] ary0 = ((IArrayType) sm.pop()).getValue();
            IArrayType ary1 = (IArrayType) sm.pop();
            for (int idx = 0; idx < ary0.length && idx < ary1.getLength(); idx++) {
                ary1.set(idx, ary0[idx]);
            }
            sm.push(ary1);
        }
    };

    public Set<IBuiltInMethod> buildMethods() {
    	
        Set<IBuiltInMethod> methods = getMethodList();
        IInterpretedMethod method = getMethod(name, execute);

        methods.add(new BuiltInMethod(	name,
						        		returnVoid,
						        		templateParameters,
										javaCode,
										reservedClassesSystem,
										null,
										method,
										templateMap));
        
        methods.add(new BuiltInMethod(	name,
						        		returnVoid,
						        		paramArrayBooleanBoolean,
										javaCode,
										reservedClassesSystem,
										null,
										method,
										null));
      
        methods.add(new BuiltInMethod(	name,
						        		returnVoid,
						        		paramArrayIntInt,
										javaCode,
										reservedClassesSystem,
										null,
										method,
										null));
        
        methods.add(new BuiltInMethod(	name,
						        		returnVoid,
						        		paramArrayDoubleDouble,
										javaCode,
										reservedClassesSystem,
										null,
										method,
										null));
        
        methods.add(new BuiltInMethod(	name,
						        		returnVoid,
						        		paramArrayCharChar,
										javaCode,
										reservedClassesSystem,
										null,
										method,
										null));
       
        methods.add(new BuiltInMethod(	name,
						        		returnVoid,
						        		paramArrayStringString,
										javaCode,
										reservedClassesSystem,
										null,
										method,
										null));   
        
        return methods;
    }

    public String toString() {
        return getName();
    }
}

