/*
 * Created on Aug 24, 2005
 */
package uk.ac.imperial.doc.kenya.builtIns.builtInMethods.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import uk.ac.imperial.doc.kenya.builtIns.BuiltInMethod;
import uk.ac.imperial.doc.kenya.builtIns.IBuiltInMethodFactory;
import uk.ac.imperial.doc.kenya.builtIns.IGetMethodCode;
import uk.ac.imperial.doc.kenya.builtIns.common.AbstractBuiltInMethodFactory;
import uk.ac.imperial.doc.kenya.stackMachine.IStackMachine;
import uk.ac.imperial.doc.kenya.stackMachine.types.AbstractAtomicClosure;
import uk.ac.imperial.doc.kenya.stackMachine.types.EnumTypeFactory;
import uk.ac.imperial.doc.kenya.stackMachine.types.NullTypeFactory;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IEnumType;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IInterpretedMethod;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.INullType;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IType;
import uk.ac.imperial.doc.kenya.types.IBuiltInMethod;
import uk.ac.imperial.doc.kenya.types.KParamType;
import uk.ac.imperial.doc.kenya.types.KType;

public class EnumSuccessor extends AbstractBuiltInMethodFactory implements IBuiltInMethodFactory {

    private static final KParamType template = new KParamType("T"); //changed from KType
    private static final KType returnTemplate = template;

    private static final List<KType> paramTemplate;
    static {
    	paramTemplate = new LinkedList<KType>();
    	paramTemplate.add(template);
    }

    private static final Map<String,KParamType> templateMapping;
    static {
        Map<String,KParamType> m = new HashMap<String,KParamType>();
        m.put("T", template);
        templateMapping = Collections.unmodifiableMap(m);
    }

    private static final String name = "enumSucc";
    
    public String getName() {
        return name;
    }

    public Set<IBuiltInMethod> buildMethods() {
    	
        Set<IBuiltInMethod> methods = getMethodList();

        IInterpretedMethod method = getMethod(name, execute);
        methods.add(new BuiltInMethod(	name,
						        		returnTemplate,
						        		paramTemplate,
										javaCode,
										null,
										null,
										method,
										templateMapping));

        return methods;
    }

    private static final AbstractAtomicClosure execute = new AbstractAtomicClosure(name) {

        public void execute(IStackMachine sm) {
            IType arg = sm.pop();
            if (arg instanceof INullType) {
                throw new NullPointerException();
            }
            IEnumType enumType = (IEnumType) arg;
            Object[] values = enumType.getEnumeration().getValues();
            Object value = enumType.getValue();
            Object nextValue = null;
            for (int idx = 0; null == nextValue && idx < values.length - 1; ++idx) {
                if (value.equals(values[idx])) {
                    nextValue = values[idx + 1];
                }
            }
            if (null == nextValue) {
                sm.push(NullTypeFactory.createNullType());
            } else {
                sm.push(EnumTypeFactory.createEnumType(enumType.getEnumeration(), nextValue));
            }
        }
    };

    private static final IGetMethodCode javaCode = new IGetMethodCode() {

        public String[] getCode(List<String[]> parameterNames, List<KType> parameterTypes) {

            String[] name = (String[]) parameterNames.get(0);

            StringBuilder sb = new StringBuilder();
            for (String s : name) {
                sb.append(s);
            }

            return new String[] { "(", sb.toString(), ".ordinal() < ",
                    sb.toString(), ".getClass().getEnumConstants()",
                    ".length-1)", "?", sb.toString(),
                    ".getClass().getEnumConstants()[", sb.toString(),
                    ".ordinal()+1] : null" };

        }

    };

}

