package uk.ac.imperial.doc.kenya.builtIns.common;

import java.util.List;
import java.util.Map;
import java.util.Set;

import uk.ac.imperial.doc.kenya.builtIns.BuiltInMethod;
import uk.ac.imperial.doc.kenya.builtIns.IBuiltInMethodFactory;
import uk.ac.imperial.doc.kenya.builtIns.IGetMethodCode;
import uk.ac.imperial.doc.kenya.stackMachine.types.AbstractAtomicClosure;
import uk.ac.imperial.doc.kenya.types.IBuiltInMethod;
import uk.ac.imperial.doc.kenya.types.KType;

public abstract class AbstractBuiltInMaths extends AbstractBuiltInMethodFactory implements IBuiltInMethodFactory
{
	// Generates the java code for all maths built-in functions
    protected static final IGetMethodCode getMathsIGetMethodCode(final String sName)
    {
    	return getMathsIGetMethodCode(sName, "");
    }	
	protected static final IGetMethodCode getMathsIGetMethodCode(final String sName, final String cast)
    {
    	IGetMethodCode javaCode = new IGetMethodCode() {
	        public String[] getCode(List<String[]> parameterValues, List<KType> parameterTypes) {
	            if (parameterValues.size() != parameterTypes.size())
	                throw new RuntimeException("I was expecting "
	                        + parameterTypes.size() + " parameters and received "
	                        + parameterValues.size() + " parameters");
	
	            // Function name
	            String[] lhs = { cast, "Math.", sName, "(", " " };

	            // Add parameters
	            String[] commaSpace = { "," , " " };
	            String[] params = { "" , "" };
	            for (int i=0; i < parameterValues.size(); i++)
	            {
	            	if (i>0)
	            	{
	            		params = BuiltInMethod.concatenate (params, commaSpace, (String[]) parameterValues.get(i));
	            	}
	            	else
	            	{
	            		params = BuiltInMethod.concatenate (params, params, (String[]) parameterValues.get(i));
	            	}
	            }

	            // Close
	            String[] rhs = new String[] { " ", ")" };
	
	            return BuiltInMethod.concatenate(lhs, params, rhs);
	        }
	    };
	    return javaCode;
    }
          
    protected Set<IBuiltInMethod> getMathsBuildMethods(String sName, AbstractAtomicClosure execute, Map<List<KType>, KType> signatures, IGetMethodCode javaCode)
    {      
    	return getBuildMethods(sName, execute, signatures, javaCode, reservedClassesMaths);
    }
	    
}

