package uk.ac.imperial.doc.kenya.builtIns.common;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import uk.ac.imperial.doc.kenya.builtIns.BuiltInMethod;
import uk.ac.imperial.doc.kenya.builtIns.IBuiltInMethodFactory;
import uk.ac.imperial.doc.kenya.builtIns.IGetMethodCode;
import uk.ac.imperial.doc.kenya.builtIns.SMLibraryContainer;
import uk.ac.imperial.doc.kenya.nio.KenyaNIO;
import uk.ac.imperial.doc.kenya.stackMachine.InterpretedMethod;
import uk.ac.imperial.doc.kenya.stackMachine.types.AbstractAtomicClosure;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IInterpretedMethod;
import uk.ac.imperial.doc.kenya.types.IBuiltInMethod;
import uk.ac.imperial.doc.kenya.types.KArrayType;
import uk.ac.imperial.doc.kenya.types.KBasicType;
import uk.ac.imperial.doc.kenya.types.KParamType;
import uk.ac.imperial.doc.kenya.types.KType;

public abstract class AbstractBuiltInMethodFactory implements IBuiltInMethodFactory {

    protected static SMLibraryContainer smLibrary = SMLibraryContainer.getLibrary();	
	
    // Return types:
	protected static final KType returnVoid = KBasicType.getVoid();
    protected static final KType returnBoolean = KBasicType.getBoolean();
    protected static final KType returnInt = KBasicType.getInt();
    protected static final KType returnDouble = KBasicType.getDouble();
    protected static final KType returnChar = KBasicType.getChar();
    protected static final KType returnString = KBasicType.getString();
    protected static final KType returnTemplate = new KParamType("T");
    protected static final KType returnArrayChar = new KArrayType(KBasicType.getChar());
    
    
	// Single Parameter lists:
    protected static final List<KType> paramVoid = new LinkedList<KType>();
    protected static final List<KType> paramBoolean = new LinkedList<KType>();
    protected static final List<KType> paramInt = new LinkedList<KType>();
    protected static final List<KType> paramDouble = new LinkedList<KType>();
    protected static final List<KType> paramChar = new LinkedList<KType>();
    protected static final List<KType> paramString = new LinkedList<KType>();
    protected static final List<KType> paramTemplate = new LinkedList<KType>();   
    protected static final List<KType> paramArrayChar = new LinkedList<KType>();

    
    // Two Parameter lists
    protected static final List<KType> paramDoubleDouble = new LinkedList<KType>();
    protected static final List<KType> paramArrayBooleanBoolean = new LinkedList<KType>();
    protected static final List<KType> paramArrayIntInt = new LinkedList<KType>();
    protected static final List<KType> paramArrayDoubleDouble = new LinkedList<KType>();
    protected static final List<KType> paramArrayCharChar = new LinkedList<KType>();
    protected static final List<KType> paramArrayStringString = new LinkedList<KType>();
    
    // Reserved classes
    protected static final Set<String> reservedClassesMaths = new HashSet<String>();
    protected static final Set<String> reservedClassesSystem = new HashSet<String>();
    protected static final Set<String> reservedClassesKenyaNIO= new HashSet<String>();
    
    // Import set
    protected static final Set<String> importSetKenyaNIO = new HashSet<String>();
        
    static {
        paramBoolean.add(KBasicType.getBoolean());
        paramInt.add(KBasicType.getInt());
    	paramDouble.add(KBasicType.getDouble());
        paramChar.add(KBasicType.getChar());
    	paramString.add(KBasicType.getString());
        paramTemplate.add(new KParamType("T"));
        paramArrayChar.add(new KArrayType(KBasicType.getChar()));

        paramDoubleDouble.add(KBasicType.getDouble());
    	paramDoubleDouble.add(KBasicType.getDouble());    
        paramArrayBooleanBoolean.add(new KArrayType(KBasicType.getBoolean()));
        paramArrayBooleanBoolean.add(new KArrayType(KBasicType.getBoolean()));
        paramArrayIntInt.add(new KArrayType(KBasicType.getInt()));
        paramArrayIntInt.add(new KArrayType(KBasicType.getInt()));
        paramArrayDoubleDouble.add(new KArrayType(KBasicType.getDouble()));
        paramArrayDoubleDouble.add(new KArrayType(KBasicType.getDouble()));       
        paramArrayCharChar.add(new KArrayType(KBasicType.getChar()));
        paramArrayCharChar.add(new KArrayType(KBasicType.getChar()));
        paramArrayStringString.add(new KArrayType(KBasicType.getString()));
        paramArrayStringString.add(new KArrayType(KBasicType.getString()));
    	
        reservedClassesMaths.add("Math");
        reservedClassesSystem.add("System");
        reservedClassesKenyaNIO.add("KenyaNIO");

        importSetKenyaNIO.add(KenyaNIO.class.getName());
    }
	
	public Set<IBuiltInMethod> buildMethods() {
		return null;
	}

	public String getName() {
		return null;
	}
	
    protected Set<IBuiltInMethod> getMethodList()
    {	
        return new HashSet<IBuiltInMethod>();
    }
    
    protected IInterpretedMethod getMethod(String sName, final AbstractAtomicClosure exec)
    {
    	return getMethod(sName, exec, true, true);
    }
    
    protected IInterpretedMethod getMethod(String sName, final AbstractAtomicClosure exec, boolean isStatic, boolean hasReturnType)
    {
        IInterpretedMethod method = new InterpretedMethod(sName, smLibrary.getLibraryClass(), isStatic, hasReturnType);
        method.setMethodBody(exec);
        smLibrary.addStaticMethod(method);  	
    	return method;
    }
    
    protected Set<IBuiltInMethod> getBuildMethods(String sName, AbstractAtomicClosure execute, Map<List<KType>, KType> signatures, IGetMethodCode javaCode, final Set<String> reservedClasses)
    {
        Set<IBuiltInMethod> methods = getMethodList();
        IInterpretedMethod method = getMethod(sName, execute);

        for (Entry<List<KType>, KType> entry: signatures.entrySet())
        {
            methods.add(new BuiltInMethod(	sName,
											entry.getValue(),
											entry.getKey(),
											javaCode,
											reservedClasses,
											null,
											method,
											null ));
        }
        
        return methods;
    }
    
}

