package uk.ac.imperial.doc.kenya.builtIns.common;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import uk.ac.imperial.doc.kenya.builtIns.BuiltInMethod;
import uk.ac.imperial.doc.kenya.builtIns.IBuiltInMethodFactory;
import uk.ac.imperial.doc.kenya.builtIns.IGetMethodCode;
import uk.ac.imperial.doc.kenya.stackMachine.types.AbstractAtomicClosure;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IInterpretedMethod;
import uk.ac.imperial.doc.kenya.types.IBuiltInMethod;
import uk.ac.imperial.doc.kenya.types.KType;

public abstract class AbstractBuiltInPrint extends AbstractBuiltInMethodFactory implements IBuiltInMethodFactory  {
    
    protected static List<List<KType>> availableParamTypes = new LinkedList<List<KType>>();

    protected abstract IGetMethodCode getJavaCode();
    
    public abstract String getName();

    protected abstract AbstractAtomicClosure getExecuteClosure();
    
    
    static {
        availableParamTypes.add(paramBoolean);
        availableParamTypes.add(paramInt);
        availableParamTypes.add(paramDouble);
        availableParamTypes.add(paramChar);
        availableParamTypes.add(paramString);
        availableParamTypes.add(paramTemplate);
    }

    public String toString() {
        return getName();
    }
    
    public Set<IBuiltInMethod> buildMethods() {
    	
        Set<IBuiltInMethod> methods = new HashSet<IBuiltInMethod>();
        IInterpretedMethod method = getMethod(getName(), getExecuteClosure(), true, false);

        for (int idx = 0; idx < availableParamTypes.size(); idx++) {
        	methods.add(new BuiltInMethod(	getName(),
						            		returnVoid,
						            		availableParamTypes.get(idx),
						            		getJavaCode(),
						            		reservedClassesSystem,
						            		null,
						    				method,
						    				null));
        }
        
        return methods;
    }
    
    protected IGetMethodCode getJavaCode(final boolean allowedNoArgs) {
        return new IGetMethodCode() {
            public String[] getCode(List<String[]> parameterValues, List<KType> parameterTypes) {
                if (parameterValues.size() != parameterTypes.size())
                        throw new RuntimeException("I was expecting "
                                + parameterTypes.size()
                                + " parameters and received "
                                + parameterValues.size() + " parameters");
                
                String[] param;
                if(parameterValues.size() == 0){
                    if (allowedNoArgs)
                        param = new String[]{};
                    else
                        throw new NullPointerException("param can't be null"); 
                } else {
                    param = parameterValues.get(0);
                }                
                
                //TODO - to fix bug in bug list we would need to generate differing java code here .. but we don't know the real type of this ... ie even if its an array!!!
                
                String[] lhs = new String[] { "System.","out.", getName() + "(", " " };
                String[] middle = param;
                String[] rhs = new String[] { " ", ")" };

                return BuiltInMethod.concatenate(lhs, middle, rhs);
           }
        };
    }
    
    
}

