package uk.ac.imperial.doc.kenya.builtIns.common;

import java.util.List;
import java.util.Map;
import java.util.Set;

import uk.ac.imperial.doc.kenya.builtIns.BuiltInMethod;
import uk.ac.imperial.doc.kenya.builtIns.IBuiltInMethodFactory;
import uk.ac.imperial.doc.kenya.builtIns.IGetMethodCode;
import uk.ac.imperial.doc.kenya.stackMachine.types.AbstractAtomicClosure;
import uk.ac.imperial.doc.kenya.types.IBuiltInMethod;
import uk.ac.imperial.doc.kenya.types.KType;

public class AbstractBuiltInString extends AbstractBuiltInMethodFactory implements IBuiltInMethodFactory
{

	protected static final IGetMethodCode getStringIGetMethodCode(final String preFix, final String postFix)
    {
   	        	IGetMethodCode javaCode = new IGetMethodCode() {
	    	        public String[] getCode(List<String[]> parameterValues, List<KType> parameterTypes) {
	    	            if (parameterValues.size() != parameterTypes.size())
	    	                throw new RuntimeException("I was expecting "
	    	                        + parameterTypes.size() + " parameters and received "
	    	                        + parameterValues.size() + " parameters");
	    	
	    	            // Function name
	    	            String[] lhs = new String[] { preFix };
	    	            
	    	            String[] param = (String[]) parameterValues.get(0);
	    	           
	    	            // Close
	    	            String[] rhs = new String[] { postFix };
	    	
	    	            return BuiltInMethod.concatenate(lhs, param, rhs);
	    	        }
	    	    };
	    	    return javaCode;
	    }
	
    protected Set<IBuiltInMethod> getStringBuildMethods(String sName, AbstractAtomicClosure execute, Map<List<KType>, KType> signatures, IGetMethodCode javaCode)
    {      
    	return getBuildMethods(sName, execute, signatures, javaCode, null);
    }
	
}

