/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/
/*
 * Created on 23-Jul-2004
 */
package uk.ac.imperial.doc.kenya.gui.editor.highlighting;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;


/**
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public class DefaultSeaDrawer implements ISeaDrawer {

    public void drawLine(GC gc, int x1, int y1, int x2, int y2, Color color) {
        gc.setLineWidth(1);
        gc.setForeground(color);
        int y = (int) (((double) y1 + (double) y2) / 2.0);
        while (x1 + 2 < x2) {
            gc.drawLine(x1, y, x1 + 1, y - 1); // up stroke
            x1 += 2;
            gc.drawLine(x1, y - 1, x1 + 1, y); // down stroke
            x1 += 2;
        }
    }

}

