/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/
/*
 * Created on Jul 25, 2004
 *
 */
package uk.ac.imperial.doc.kenya.gui.editor.highlighting;


import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;

import uk.ac.imperial.doc.kenya.sourceCodeInformation.interfaces.ISourceCodeError;
import uk.ac.imperial.doc.kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import uk.ac.imperial.doc.kenya.styleCheckers.IStyleCheckResult;

/**
 * @author Matthew Sackman
 * @version 1
 */
public interface IHighlightingManager {

    ErrorHighlighter getErrorHighlighter();

    WarningHighlighter getWarningHighlighter();

    LinkedLocationHighlighter getLinkedLocationHighlighter();
    
    void paint(PaintEvent e);
    
    void clear();
    
    void addSourceCodeError(ISourceCodeError error);
    
    void addSourceCodeWarning(ISourceCodeInformation warning);
    
    MouseListener createKenyaMouseListener(IKenyaHighlightedText window);
    
    LineBackgroundListener createKenyaLineBackgroundListener(IKenyaHighlightedText window);
    
    void showLinkedHighlights(int offset);

    void addStyleCheckResult(IStyleCheckResult scr);
}

