/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 3, 2004
 *
 */
package uk.ac.imperial.doc.kenya.gui.editor.icons;

import java.net.URL;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.graphics.Image;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class ButtonManager implements IButtonManager {

    private static final String BUTTON_MANAGER_PACKAGE_PATH = ButtonManager.class
            .getPackage().getName().replace('.', '/');

    private static final String REDBUTTONURL = "/redButton.png";

    private static final String YELLOWBUTTONURL = "/yellowButton.png";

    private static final String BLUEBUTTONURL = "/blueButton.png";
    
    private static final String REDCARROTURL = "/redCarrot.png";

    private static final String BLUECARROTURL = "/blueCarrot.png";

    private final ImageRegistry ir = new ImageRegistry();

    private final ApplicationWindow window;

    public ButtonManager(ApplicationWindow window) {
        this.window = window;
        ir.put(REDBUTTON, loadImage(REDBUTTONURL));
        ir.put(YELLOWBUTTON, loadImage(YELLOWBUTTONURL));
        ir.put(BLUEBUTTON, loadImage(BLUEBUTTONURL));
        ir.put(REDCARROT, loadImage(REDCARROTURL));
        ir.put(BLUECARROT, loadImage(BLUECARROTURL));
    }

    public Image getImage(String image) {
        return ir.get(image);
    }

    private ImageDescriptor loadImage(String location) {
        URL url = window.getClass().getClassLoader().getResource(
                BUTTON_MANAGER_PACKAGE_PATH + location);
        return ImageDescriptor.createFromURL(url);
    }
}