/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 4, 2004
 *
 */
package uk.ac.imperial.doc.kenya.gui.editor.indenter;

import java.util.regex.Pattern;

/**
 * @author Matthew Sackman
 * @version 1
 */
public interface ILineIndentation {

    static final Pattern INDENT = Pattern.compile("^(\\s+).*?$");

    static final Pattern DECREASINGEND = Pattern
            .compile("^.*\\}\\s*((\\/\\/|\\/\\*).*)?$");

    static final Pattern DECREASINGSTART = Pattern.compile("^\\s*\\}.*$");

    static final Pattern INCREASINGEND = Pattern
            .compile("^.*\\{\\s*((\\/\\/|\\/\\*).*)?$");
    
    static final Pattern INCREASINGSTART = Pattern.compile("^\\s*\\{.*$");

    static final Pattern DECREASEREMOVE = Pattern.compile("^(.*)\\}(.*)$");

    static final Pattern INCREASEREMOVE = Pattern.compile("^(.*)\\{(.*)$");

    static final Pattern SEMICOLONEND = Pattern
            .compile("^.*?;\\s*((\\/\\/|\\/\\*).*)?$");

    static final Pattern SPACELINE = Pattern
            .compile("^\\s*((\\/\\/|\\/\\*).*)?$");

    static final Pattern TRAILINGSPACE = Pattern.compile("^.*?\\S+(\\s+)$");

    static final Pattern BLOCKSTART = Pattern.compile("^(.*?)\\/\\*(.*)$");

    static final Pattern BLOCKEND = Pattern
            .compile("^(.*?)\\*\\/(.*)$");

    static final String UNIT = "    ";

    int getLineNumber();

    void setLineNumber(int lineNumber);

    void setNextLine(ILineIndentation nextLine);

    void setPreviousLine(ILineIndentation previousLine);

    ILineIndentation getNextLine();

    ILineIndentation getPreviousLine();

    boolean isComplete();

    String getNextLineIndentation();

    int getDepth();

    void parselineText(String thisLineText, String nextLineText);

    ILineIndentation getLine(int lineNumber);

    boolean isBlockStart();

    boolean isBlockEnd();

    boolean isInBlock();

    void recount();
    
}