/* *******************************************************************************
 *   kenya                                                             *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/
/*
 * Created on 17-Sep-2004
 */
package uk.ac.imperial.doc.kenya.gui.editor.menuActions;


import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import uk.ac.imperial.doc.kenya.gui.editor.utils.EditingWindowUtilsFactory;

/**
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public class AboutDialog extends Dialog {

    private static final String BASED_ON_A_PROJECT_BY_ROBERT_CHATLEY = "Based on a project by Rob Chatley";

    private static final String MATTHEW_SACKMAN = "Matthew Sackman";

    private static final String TRISTAN_ALLWOOD = "Tristan Allwood";
    
    private static final String HUBERT_PLOCINICZAK = "Hubert Plociniczak";
    
    private static final String ANTON_STEFANEK = "Anton Stefanek";

    private static final String AUTHORS = "Authors";

    private static final String VERSION = "Version ";

    private static final String KENYA = "Kenya";

    /**
     * @param parentShell
     */
    protected AboutDialog(Shell parentShell) {
        super(parentShell);

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
     */
    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        RowLayout layout = new RowLayout();
        layout.type = SWT.VERTICAL;
        layout.justify = true;
        layout.fill = true;
        composite.setLayout(layout);

        Label l = new Label(composite, SWT.NONE);
        l.setText(KENYA);
        l.setAlignment(SWT.CENTER);

        l = new Label(composite, SWT.NONE);
        l.setText(VERSION + EditingWindowUtilsFactory.kenya.getVersion());
        l.setAlignment(SWT.CENTER);

        l = new Label(composite, SWT.NONE);
        l.setText(AUTHORS);
        l.setAlignment(SWT.CENTER);

        l = new Label(composite, SWT.NONE);
        l.setText(TRISTAN_ALLWOOD);
        l.setAlignment(SWT.CENTER);

        l = new Label(composite, SWT.NONE);
        l.setText(MATTHEW_SACKMAN);
        l.setAlignment(SWT.CENTER);
        
        l = new Label(composite, SWT.NONE);
        l.setText(HUBERT_PLOCINICZAK);
        l.setAlignment(SWT.CENTER);
        
        l = new Label(composite, SWT.NONE);
        l.setText(ANTON_STEFANEK);
        l.setAlignment(SWT.CENTER);

        l = new Label(composite, SWT.NONE);
        l.setText(BASED_ON_A_PROJECT_BY_ROBERT_CHATLEY);
        l.setAlignment(SWT.CENTER);

        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        RowLayout layout = new RowLayout();
        layout.type = SWT.VERTICAL;
        layout.justify = true;
        layout.fill = true;
        composite.setLayout(layout);

        Button ok = new Button(composite, SWT.PUSH | SWT.CENTER);
        ok.setText("OK");
        ok.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                close();
            }
        });

        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        gd.horizontalAlignment = GridData.CENTER;
        gd.verticalAlignment = GridData.CENTER;
        composite.setLayoutData(gd);

        return composite;
    }

}