/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Jul 28, 2004
 *
 */
package uk.ac.imperial.doc.kenya.gui.editor.menuActions;

import org.eclipse.jface.action.Action;

import uk.ac.imperial.doc.kenya.gui.editor.EditingWindow;
import uk.ac.imperial.doc.kenya.gui.editor.utils.FileLoaderSaver;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class AlwaysSaveJavaAutomatically extends Action {

    private static ISaveKenyaContinuation continuation = new ISaveKenyaContinuation() {

        public void invoke(boolean savedSuccess, EditingWindow window) {
            if (savedSuccess && window.isJavaGoodToSave()) {
                FileLoaderSaver kenyaFLS = window.getKenyaFile();
                if (null != kenyaFLS && null != kenyaFLS.getPath()) {
                    String path = kenyaFLS.getPath();
                    if (path.endsWith(".java")) {
                        return;
                    }
                    int end = path.lastIndexOf('.') + 1;
                    if (0 == end) {
                        end = path.length();
                    }
                    path = path.substring(0, end);
                    path += "java";
                    FileLoaderSaver javaFLS = window.getJavaFileLoaderSaver();
                    if (null == javaFLS || null == javaFLS.getPath()) {
                        javaFLS = new FileLoaderSaver();
                        javaFLS.setPath(path);
                        window.setJavaFileLoaderSaver(javaFLS);
                    }
                    window.saveJava();
                }                
            }
        }};
    
    private static ISaveKenyaActionHandler saveHandler = new ISaveKenyaActionHandler() {

        public void saveKenya(EditingWindow window, boolean saveAs) {
            if (saveAs) {
                window.saveKenyaAs(continuation);
            } else {
                window.saveKenya(continuation);
            }
        }
    };

    private final EditingWindow window;

    public AlwaysSaveJavaAutomatically(EditingWindow w) {
        super("Save Java automatically when Kenya is saved", AS_CHECK_BOX);
        window = w;
        setText("Save Java automatically when Kenya is saved");
        setToolTipText("Save Java automatically when Kenya is saved");
        setChecked(true);
        run();
    }

    public void run() {
        window.setSaveableJava(false);
        window.setSaveKenyaActionHandler(saveHandler);
    }

}
