/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Jul 28, 2004
 *
 */
package uk.ac.imperial.doc.kenya.gui.editor.menuActions;


import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

import uk.ac.imperial.doc.kenya.gui.editor.EditingWindow;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class IOMediumFontAction extends Action {

    private final EditingWindow window;

    public IOMediumFontAction(EditingWindow w) {
        super("&Medium@Ctrl+Alt+2", AS_CHECK_BOX);
        window = w;
        setText("&Medium@Ctrl+Alt+2");
        setToolTipText("Medium Font");
        setChecked(true);
    }

    public void run() {

        FontData fd = window.getJavaStdOutText().getFont().getFontData()[0];
        fd.setHeight(12);
        Font mediumFont = new Font(window.getTopTabs().getDisplay(), fd);

        window.setIOFonts(mediumFont);
    }
}