/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Jul 28, 2004
 *
 */
package uk.ac.imperial.doc.kenya.gui.editor.menuActions;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

import uk.ac.imperial.doc.kenya.gui.editor.EditingWindow;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class PromptToSaveJava extends Action {

    private static ISaveKenyaActionHandler saveHandler = new ISaveKenyaActionHandler() {

        public void saveKenya(EditingWindow window, final boolean saveAs) {
            ISaveKenyaContinuation continuation = new ISaveKenyaContinuation() {

                public void invoke(boolean savedSuccess, EditingWindow window) {
                    if (savedSuccess && window.isJavaGoodToSave()) {
                        Shell shell = new Shell();
                        MessageBox messageBox = new MessageBox(shell, SWT.YES
                                | SWT.NO);
                        messageBox
                                .setMessage("Your Kenya source code can be successfully "
                                        + "translated to Java. Would you like to save "
                                        + "the Java translation of your Kenya code?");
                        int result = messageBox.open();
                        if (result == SWT.YES) {
                            if (saveAs) {
                                window.saveJavaAs();
                            } else {
                                window.saveJava();
                            }
                        }
                    }
                }
            };

            if (saveAs) {
                window.saveKenyaAs(continuation);
            } else {
                window.saveKenya(continuation);
            }
        }
    };

    private final EditingWindow window;

    public PromptToSaveJava(EditingWindow w) {
        super("Prompt to save Java whenever Kenya is saved", AS_CHECK_BOX);
        window = w;
        setText("Prompt to save Java whenever Kenya is saved");
        setToolTipText("Prompt to save Java whenever Kenya is saved");
    }

    public void run() {
        window.setSaveableJava(true);
        window.setSaveKenyaActionHandler(saveHandler);
    }
}
