/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Sep 8, 2004
 *
 */
package uk.ac.imperial.doc.kenya.gui.editor.menuActions;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

/**
 * @author matthew
 *  
 */
public class UniqueCheckedManager implements IPropertyChangeListener {

    private final Set<IAction> actions = new HashSet<IAction>();

    private volatile IAction lastChecked = null;

    public synchronized void addAction(IAction action) {
        actions.add(action);
        action.addPropertyChangeListener(this);
        if (action.isChecked()) {
            if (lastChecked == null) {
                lastChecked = action;
            } else {
                System.err.println("Can't cope with two checked actions: "
                        + lastChecked + ", " + action);
            }
        }
    }

    public synchronized void propertyChange(PropertyChangeEvent event) {
        if (event.getNewValue() == Boolean.FALSE
                && event.getOldValue() == Boolean.TRUE
                && event.getSource() == lastChecked) {
            lastChecked.removePropertyChangeListener(this);
            lastChecked.setChecked(true); // you can't deselect
            lastChecked.addPropertyChangeListener(this);
            return;
        }
        IAction fired = (IAction) event.getSource();
        if (actions.contains(fired)) {
            if (lastChecked != null && lastChecked != fired) {
                lastChecked.removePropertyChangeListener(this);
                lastChecked.setChecked(false);
                lastChecked.addPropertyChangeListener(this);
            } else if (lastChecked == null) {
                for(IAction action : actions) {
                    action.removePropertyChangeListener(this);
                    action.setChecked(false);
                    action.addPropertyChangeListener(this);
                }
                fired.removePropertyChangeListener(this);
                fired.setChecked(true);
                fired.addPropertyChangeListener(this);
            }
            lastChecked = fired;
        }
    }

}