package uk.ac.imperial.doc.kenya.gui.editor.sourceCodeInformationTable;

import java.io.BufferedReader;
import java.io.IOException;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

import uk.ac.imperial.doc.kenya.gui.editor.icons.IButtonManager;
import uk.ac.imperial.doc.kenya.sourceCodeInformation.interfaces.ISourceCodeError;
import uk.ac.imperial.doc.kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import uk.ac.imperial.doc.kenya.styleCheckers.IStyleCheckResult;

public abstract class AbstractErrorLabelContentProvider implements ITableLabelProvider {
    protected IButtonManager ibm;
    protected String delimiter;
    

    public Image getColumnImage(Object element, int columnIndex) {
        if(columnIndex != 0) {return null;} 
        
        if (element instanceof ISourceCodeError)
            return ibm.getImage(IButtonManager.REDBUTTON);
        else if(element instanceof IStyleCheckResult)
            return ibm.getImage(IButtonManager.BLUEBUTTON);
        else /* if(element instanceof ISourceCodeWarning) */            
            return ibm.getImage(IButtonManager.YELLOWBUTTON);

    }
    
    public String getColumnText(Object element, int columnIndex) {
        if(columnIndex != 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        handleColumnText(element, columnIndex, buffer);
        return buffer.toString();
    }
    
    protected void handleSourceCodeInformationText(ISourceCodeInformation element,
        int columnIndex, StringBuffer buffer) {
        buffer.append("Line ");
        buffer.append(element.getLocation()
                .getLineNumber());
        buffer.append(": ");
        BufferedReader reader = new BufferedReader(element.getHumanStyleMessage());
        try {
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append(delimiter);
                line = reader.readLine();
            }
        } catch (IOException e) {
            // Don't care
        }
        buffer.delete(buffer.length() - delimiter.length(), buffer.length());

    }
    
    protected abstract void handleColumnText(Object element, int columnIndex, StringBuffer buffer);
    
    public void addListener(ILabelProviderListener listener) { }

    public void dispose() { }

    public boolean isLabelProperty(Object element, String property) { return false; }

    public void removeListener(ILabelProviderListener listener) { }
}

