/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Jul 29, 2004
 *
 */
package uk.ac.imperial.doc.kenya.gui.editor.sourceCodeInformationTable;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

import uk.ac.imperial.doc.kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import uk.ac.imperial.doc.kenya.styleCheckers.ICheckedCode;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class KenyaErrorContentProvider implements IStructuredContentProvider {

    private static final Comparator<ISourceCodeInformation> itemComparator = new Comparator<ISourceCodeInformation>() {

        public int compare(ISourceCodeInformation inf0,
                ISourceCodeInformation inf1) {

            int res = Integer.valueOf(inf0.getPriority()).compareTo(
                    inf1.getPriority());
            if (res != 0) {
                return res;
            }

            return inf0.getLocation().compareTo(inf1.getLocation());

        }

    };

    private final SortedSet<ISourceCodeInformation> errors = new TreeSet<ISourceCodeInformation>(
            itemComparator);

    public synchronized Object[] getElements(Object inputElement) {
        errors.clear();
        ICheckedCode checker = (ICheckedCode) inputElement;
        if (checker.isErroredCode()) {
            errors.addAll(checker.getErrors());
        }
        errors.addAll(checker.getInfos());
        errors.addAll(checker.getStyleCheckResults());

        return errors.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public synchronized int getIndex(ISourceCodeInformation error) {
        if(!errors.contains(error)) {
            return -1;
        }
        
        int count = 0;

        for (ISourceCodeInformation item: errors) {
            if (error.equals(item))
                return count;
            count++;
        }
        return -1;
    }

}
