package uk.ac.imperial.doc.kenya.gui.editor.sourceCodeInformationTable;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import uk.ac.imperial.doc.kenya.styleCheckers.ICheckedCode;
import uk.ac.imperial.doc.kenya.styleCheckers.IFixSuggestion;
import uk.ac.imperial.doc.kenya.styleCheckers.IStyleCheckResult;

public class SourceCodeInformationTableManager implements ISourceCodeInformationTableManager{

    private final Table table;
    private final TableViewer tableViewer;
    private final KenyaErrorContentProvider contentProvider;
    private final IKenyaTextProvider parent;
    
    public SourceCodeInformationTableManager(IKenyaTextProvider parent, TabFolder kenyaTabs, IBaseLabelProvider labels, ISelectionChangedListener tableSelectionChanged,
            KenyaErrorContentProvider contentProvider) {
        this.contentProvider = contentProvider;
        this.parent = parent;
        
        this.table = new Table(kenyaTabs, SWT.BORDER
                | SWT.SINGLE | SWT.FULL_SELECTION | SWT.H_SCROLL | SWT.V_SCROLL );

        new TableColumn(table, SWT.LEFT,0);
        new TableColumn(table, SWT.RIGHT,1); 
        this.tableViewer = new TableViewer(table);
        tableViewer.setUseHashlookup(true);

        tableViewer.setContentProvider(contentProvider);
        tableViewer.setLabelProvider(labels);

        this.tableViewer.addSelectionChangedListener(tableSelectionChanged);
        this.table.setLinesVisible(false);
        this.table.setHeaderVisible(false);
        
        this.table.pack();
        
    }

    public Control getControl() {
        return table;
    }

    public void deselectAll() {
        this.table.deselectAll();
    }

    private final Collection<TableEditor> eds = new ArrayList<TableEditor>();
    
    public void setInput(ICheckedCode checker) {
    
        synchronized(eds) {
            
            for(TableEditor te : eds) {
                te.getEditor().dispose();
            }
            eds.clear();
            
            
            this.tableViewer.setInput(checker);
            
            for(IStyleCheckResult scr: checker.getStyleCheckResults()) {
                if(scr.getPossibleFixes().isEmpty()) {
                    continue;
                }
                
                TableEditor editor = new TableEditor(table);
                final Button button = new Button(table, SWT.ARROW);
                button.pack();
                
                button.addListener(SWT.Selection, new Listener() {

                    public void handleEvent(Event arg0) {
                        button.getMenu().setVisible(true);
                    }
                    
                });          
                button.setMenu(createFixMenu(scr, button));
                
                editor.minimumWidth = button.getSize().x;
                editor.horizontalAlignment = SWT.LEFT;
                editor.setEditor(button,table.getItem(contentProvider.getIndex(scr)),1);
                
                eds.add(editor);
            }
            
            this.table.getColumn(0).pack();
            this.table.getColumn(1).pack();
        }
    }

    private Menu createFixMenu(IStyleCheckResult scr, Control control) {

        Menu menu = new Menu(control);
        
        for(final IFixSuggestion suggestion :  scr.getPossibleFixes()) {
            MenuItem item = new MenuItem(menu, SWT.POP_UP); 
            item.setText(suggestion.getDescription());
            item.addListener(SWT.Selection,new Listener() {

                public void handleEvent(Event arg0) {
                    parent.getKenyaTextWidget().setText(suggestion.getFixedSourceCode());
                } 
            });
        }
        
        return menu;
    }

    public void setSelection(int index) {
        this.table.setSelection(index);
    }

    public void showSelection() {
        this.table.showSelection();
    }
}
