/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/
/*
 * Created on Jul 25, 2004
 *
 */
package uk.ac.imperial.doc.kenya.gui.editor.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;

import org.eclipse.swt.widgets.Display;

import uk.ac.imperial.doc.kenya.gui.KenyaGUIApplication;
import uk.ac.imperial.doc.kenya.gui.editor.EditingWindow;
import uk.ac.imperial.doc.kenya.gui.editor.highlighting.DefaultHighlightingManager;
import uk.ac.imperial.doc.kenya.gui.editor.highlighting.HighlightingFactory;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class EditingWindowUtilsFactory {

    private static int counter = 0;

    private static final Set<EditingWindow> editingWindows = new HashSet<EditingWindow>();

    private EditingWindowUtilsFactory() {
    }
    
    public static KenyaGUIApplication kenya; 

    public static EditingWindow createAndOpenEditorWindow(KenyaGUIApplication kenyaApp) {
    	kenya = kenyaApp; 
    	return createAndOpenEditorWindow();
    }
    
    /* Can only be called when the kenya app is already properly set up */
    public static EditingWindow createAndOpenEditorWindow() {
        EditingWindow window = new EditingWindow(getNextClassName());
        openEditorWindow(window);
        return window;
    }

    public static EditingWindow createAndOpenEditorWindow(FileLoaderSaver fls) {
        EditingWindow window = new EditingWindow(getNextClassName());
        window.setKenyaFile(fls);
        window.loadFromKenyaFile();
        openEditorWindow(window);
        return window;
    }
    public static EditingWindow createAndOpenEditorWindow(FileLoaderSaver fls, KenyaGUIApplication kenyaApp) {
        kenya = kenyaApp;
        return createAndOpenEditorWindow(fls);
    }

    private static void openEditorWindow(final EditingWindow window) {
        ExecutorService executor = window.getExecutorService();
        final Runnable editorThread = new Runnable() {

            public void run() {
                Runnable exitListener = new ExitListener(window);
                kenya.addExitListener(exitListener);
                synchronized (window) {
                    window.setHighlightingManager(new DefaultHighlightingManager(
                                    window,
                                    HighlightingFactory
                                            .createErrorHighlighter(window),
                                    HighlightingFactory
                                            .createWarningHighlighter(window),
                                    HighlightingFactory
                                            .createLinkedLocationHighlighter(window),
                                    HighlightingFactory.createStyleHighlighter(window)));
                }
                window.setBlockOnOpen(true);
                windowOpened(window);
                window.open();
                windowClosed(window);
                kenya.removeExitListener(exitListener);
            }
        };
        Runnable start = new Runnable() {

            public void run() {
                if (Display.getDefault().equals(Thread.currentThread())) {
                    editorThread.run();
                } else {
                    Display.getDefault().syncExec(editorThread);
                }
            }
        };
        executor.execute(new KenyaHelperThread(window));
        start.run();//needs to run from the current thread
    }

    private synchronized static void windowOpened(EditingWindow window) {
        editingWindows.add(window);
    }

    private synchronized static void windowClosed(EditingWindow window) {
        editingWindows.remove(window);
        if (editingWindows.size() == 0) {
            if (Display.getCurrent().isDisposed())
                    Display.getCurrent().dispose();
            kenya.exit();
        }
    }

    public synchronized static void closeEditingWindows() {
        Iterator<EditingWindow> it = editingWindows.iterator();
        while (it.hasNext()) {
            EditingWindow window = (EditingWindow) it.next();
            window.closeWindow();
        }
    }

    private static synchronized String getNextClassName() {
        counter++;
        return "Class" + counter;
    }
}