/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/
/*
 * Created on Jul 25, 2004
 *
 */
package uk.ac.imperial.doc.kenya.gui.editor.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class FileLoaderSaver {

    private String path = "";
    
    private String name = "";
    
    private String dir = "";

    private static Pattern tabElimination = Pattern.compile("\\t",
            Pattern.MULTILINE);

    public synchronized String loadFile(String path) {
        File file = new File(path);
        name = file.getName();
        dir = file.getParent();
        if (file.isFile() && file.canRead()) {
            this.path = path;
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                StringBuffer contents = new StringBuffer();
                while (reader.ready()) {
                    contents.append((char) reader.read());
                }
                reader.close();
                String text = contents.toString();
                Matcher match = tabElimination.matcher(text);
                return match.replaceAll("    ");
            } catch (FileNotFoundException e) {
                e.printStackTrace();
                return "";
            } catch (IOException e) {
                e.printStackTrace();
                return "";
            }
        } else {
            return "";
        }
    }

    public synchronized void saveFile(String text) {
        if (path.equals("")) { throw new IllegalStateException(
                "Attempt to save file to unknown path."); }
        File file = new File(path);
        name = file.getName();
        dir = file.getParent();
        if ((file.isFile() && file.canWrite()) || !file.exists()) {
            try {
                FileWriter writer = new FileWriter(file);
                writer.write(text);
                writer.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("Unable to write to "
                    + file.getAbsolutePath());
        }
    }

    public synchronized void saveFile(String text, String path) {
        File file = new File(path);
        name = file.getName();
        dir = file.getParent();
        if (!file.exists() || (file.isFile() && file.canWrite())) {
            this.path = path;
            saveFile(text);
        } else {
            throw new RuntimeException("Unable to write to "
                    + file.getAbsolutePath());
        }
    }

    public synchronized String getPath() {
        return path;
    }

    public synchronized String getName() {
        return name;
    }
    
    public synchronized String getDir() {
        return dir;
    }

    public synchronized void setPath(String path) {
        this.path = path;
        File file = new File(path);
        name = file.getName();
        dir = file.getParent();
    }

    public FileLoaderSaver() {
    }

}

