package uk.ac.imperial.doc.kenya.gui.editor.utils;

import java.util.ArrayList;
import java.util.List;

public abstract class GenericScanner {
    
    abstract int read();
    abstract void unread(int character);
    abstract void unreadBuffer(List<Integer> buffer);
    
    int nextGenericToken(int c, int GENERIC, int EOF,  int EOL, int OTHER) {
        int depth = 1;
        List<Integer> reads = new ArrayList<Integer>();
        while (depth > 0) {
            c = read();
            reads.add(new Integer(c));
            if (c == '>') {
                depth--;
                if (depth == 0) return GENERIC;
            } else if (c == EOL || c == EOF) {
                unreadBuffer(reads);
                return OTHER;
            } else {
                if (!(c == ' ' || c == ',' || c == '_' || c == '<'
                        || c == '>' || c == '[' || c == ']'
                        || (c >= '0' && c <= '9')
                        || (c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z'))) {
                    unreadBuffer(reads);
                    return OTHER;
                }
                if (c == '<') depth++;
            }
        }
        return OTHER;
    }
    
    int nextDigitToken(int NUMBER) {
        int c = -1;  // will always be initialized, to make the compiler happy      
        do {
            c = read();
        } while (Character.isDigit((char) c));
        unread(c);
        return NUMBER;
    }

}

